<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BomRevisionComponentList StructType
 * @subpackage Structs
 */
class BomRevisionComponentList extends AbstractStructBase
{
    /**
     * The bomRevisionComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BomRevisionComponent[]
     */
    public $bomRevisionComponent;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for BomRevisionComponentList
     * @uses BomRevisionComponentList::setBomRevisionComponent()
     * @uses BomRevisionComponentList::setReplaceAll()
     * @param \StructType\BomRevisionComponent[] $bomRevisionComponent
     * @param bool $replaceAll
     */
    public function __construct(array $bomRevisionComponent = array(), $replaceAll = true)
    {
        $this
            ->setBomRevisionComponent($bomRevisionComponent)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get bomRevisionComponent value
     * @return \StructType\BomRevisionComponent[]|null
     */
    public function getBomRevisionComponent()
    {
        return $this->bomRevisionComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setBomRevisionComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBomRevisionComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBomRevisionComponentForArrayConstraintsFromSetBomRevisionComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bomRevisionComponentListBomRevisionComponentItem) {
            // validation for constraint: itemType
            if (!$bomRevisionComponentListBomRevisionComponentItem instanceof \StructType\BomRevisionComponent) {
                $invalidValues[] = is_object($bomRevisionComponentListBomRevisionComponentItem) ? get_class($bomRevisionComponentListBomRevisionComponentItem) : sprintf('%s(%s)', gettype($bomRevisionComponentListBomRevisionComponentItem), var_export($bomRevisionComponentListBomRevisionComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bomRevisionComponent property can only contain items of type \StructType\BomRevisionComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bomRevisionComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\BomRevisionComponent[] $bomRevisionComponent
     * @return \StructType\BomRevisionComponentList
     */
    public function setBomRevisionComponent(array $bomRevisionComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($bomRevisionComponentArrayErrorMessage = self::validateBomRevisionComponentForArrayConstraintsFromSetBomRevisionComponent($bomRevisionComponent))) {
            throw new \InvalidArgumentException($bomRevisionComponentArrayErrorMessage, __LINE__);
        }
        $this->bomRevisionComponent = $bomRevisionComponent;
        return $this;
    }
    /**
     * Add item to bomRevisionComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\BomRevisionComponent $item
     * @return \StructType\BomRevisionComponentList
     */
    public function addToBomRevisionComponent(\StructType\BomRevisionComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BomRevisionComponent) {
            throw new \InvalidArgumentException(sprintf('The bomRevisionComponent property can only contain items of type \StructType\BomRevisionComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bomRevisionComponent[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\BomRevisionComponentList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
