<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BinTransferInventory StructType
 * @subpackage Structs
 */
class BinTransferInventory extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The preferredBin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $preferredBin;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The itemUnitsLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemUnitsLabel;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The fromBins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromBins;
    /**
     * The toBins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toBins;
    /**
     * Constructor method for BinTransferInventory
     * @uses BinTransferInventory::setLine()
     * @uses BinTransferInventory::setItem()
     * @uses BinTransferInventory::setDescription()
     * @uses BinTransferInventory::setPreferredBin()
     * @uses BinTransferInventory::setQuantity()
     * @uses BinTransferInventory::setItemUnitsLabel()
     * @uses BinTransferInventory::setInventoryDetail()
     * @uses BinTransferInventory::setFromBins()
     * @uses BinTransferInventory::setToBins()
     * @param int $line
     * @param \StructType\RecordRef $item
     * @param string $description
     * @param string $preferredBin
     * @param float $quantity
     * @param string $itemUnitsLabel
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $fromBins
     * @param string $toBins
     */
    public function __construct($line = null, \StructType\RecordRef $item = null, $description = null, $preferredBin = null, $quantity = null, $itemUnitsLabel = null, \StructType\InventoryDetail $inventoryDetail = null, $fromBins = null, $toBins = null)
    {
        $this
            ->setLine($line)
            ->setItem($item)
            ->setDescription($description)
            ->setPreferredBin($preferredBin)
            ->setQuantity($quantity)
            ->setItemUnitsLabel($itemUnitsLabel)
            ->setInventoryDetail($inventoryDetail)
            ->setFromBins($fromBins)
            ->setToBins($toBins);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\BinTransferInventory
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\BinTransferInventory
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\BinTransferInventory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get preferredBin value
     * @return string|null
     */
    public function getPreferredBin()
    {
        return $this->preferredBin;
    }
    /**
     * Set preferredBin value
     * @param string $preferredBin
     * @return \StructType\BinTransferInventory
     */
    public function setPreferredBin($preferredBin = null)
    {
        // validation for constraint: string
        if (!is_null($preferredBin) && !is_string($preferredBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredBin, true), gettype($preferredBin)), __LINE__);
        }
        $this->preferredBin = $preferredBin;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\BinTransferInventory
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get itemUnitsLabel value
     * @return string|null
     */
    public function getItemUnitsLabel()
    {
        return $this->itemUnitsLabel;
    }
    /**
     * Set itemUnitsLabel value
     * @param string $itemUnitsLabel
     * @return \StructType\BinTransferInventory
     */
    public function setItemUnitsLabel($itemUnitsLabel = null)
    {
        // validation for constraint: string
        if (!is_null($itemUnitsLabel) && !is_string($itemUnitsLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemUnitsLabel, true), gettype($itemUnitsLabel)), __LINE__);
        }
        $this->itemUnitsLabel = $itemUnitsLabel;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\BinTransferInventory
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get fromBins value
     * @return string|null
     */
    public function getFromBins()
    {
        return $this->fromBins;
    }
    /**
     * Set fromBins value
     * @param string $fromBins
     * @return \StructType\BinTransferInventory
     */
    public function setFromBins($fromBins = null)
    {
        // validation for constraint: string
        if (!is_null($fromBins) && !is_string($fromBins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromBins, true), gettype($fromBins)), __LINE__);
        }
        $this->fromBins = $fromBins;
        return $this;
    }
    /**
     * Get toBins value
     * @return string|null
     */
    public function getToBins()
    {
        return $this->toBins;
    }
    /**
     * Set toBins value
     * @param string $toBins
     * @return \StructType\BinTransferInventory
     */
    public function setToBins($toBins = null)
    {
        // validation for constraint: string
        if (!is_null($toBins) && !is_string($toBins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toBins, true), gettype($toBins)), __LINE__);
        }
        $this->toBins = $toBins;
        return $this;
    }
}
