<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingScheduleMilestone StructType
 * @subpackage Structs
 */
class BillingScheduleMilestone extends AbstractStructBase
{
    /**
     * The milestoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $milestoneId;
    /**
     * The milestoneAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $milestoneAmount;
    /**
     * The milestoneTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $milestoneTerms;
    /**
     * The projectTask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $projectTask;
    /**
     * The milestoneDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $milestoneDate;
    /**
     * The milestoneCompleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $milestoneCompleted;
    /**
     * The milestoneActualCompletionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $milestoneActualCompletionDate;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * Constructor method for BillingScheduleMilestone
     * @uses BillingScheduleMilestone::setMilestoneId()
     * @uses BillingScheduleMilestone::setMilestoneAmount()
     * @uses BillingScheduleMilestone::setMilestoneTerms()
     * @uses BillingScheduleMilestone::setProjectTask()
     * @uses BillingScheduleMilestone::setMilestoneDate()
     * @uses BillingScheduleMilestone::setMilestoneCompleted()
     * @uses BillingScheduleMilestone::setMilestoneActualCompletionDate()
     * @uses BillingScheduleMilestone::setComments()
     * @param int $milestoneId
     * @param float $milestoneAmount
     * @param \StructType\RecordRef $milestoneTerms
     * @param \StructType\RecordRef $projectTask
     * @param string $milestoneDate
     * @param bool $milestoneCompleted
     * @param string $milestoneActualCompletionDate
     * @param string $comments
     */
    public function __construct($milestoneId = null, $milestoneAmount = null, \StructType\RecordRef $milestoneTerms = null, \StructType\RecordRef $projectTask = null, $milestoneDate = null, $milestoneCompleted = null, $milestoneActualCompletionDate = null, $comments = null)
    {
        $this
            ->setMilestoneId($milestoneId)
            ->setMilestoneAmount($milestoneAmount)
            ->setMilestoneTerms($milestoneTerms)
            ->setProjectTask($projectTask)
            ->setMilestoneDate($milestoneDate)
            ->setMilestoneCompleted($milestoneCompleted)
            ->setMilestoneActualCompletionDate($milestoneActualCompletionDate)
            ->setComments($comments);
    }
    /**
     * Get milestoneId value
     * @return int|null
     */
    public function getMilestoneId()
    {
        return $this->milestoneId;
    }
    /**
     * Set milestoneId value
     * @param int $milestoneId
     * @return \StructType\BillingScheduleMilestone
     */
    public function setMilestoneId($milestoneId = null)
    {
        // validation for constraint: int
        if (!is_null($milestoneId) && !(is_int($milestoneId) || ctype_digit($milestoneId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($milestoneId, true), gettype($milestoneId)), __LINE__);
        }
        $this->milestoneId = $milestoneId;
        return $this;
    }
    /**
     * Get milestoneAmount value
     * @return float|null
     */
    public function getMilestoneAmount()
    {
        return $this->milestoneAmount;
    }
    /**
     * Set milestoneAmount value
     * @param float $milestoneAmount
     * @return \StructType\BillingScheduleMilestone
     */
    public function setMilestoneAmount($milestoneAmount = null)
    {
        // validation for constraint: float
        if (!is_null($milestoneAmount) && !(is_float($milestoneAmount) || is_numeric($milestoneAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($milestoneAmount, true), gettype($milestoneAmount)), __LINE__);
        }
        $this->milestoneAmount = $milestoneAmount;
        return $this;
    }
    /**
     * Get milestoneTerms value
     * @return \StructType\RecordRef|null
     */
    public function getMilestoneTerms()
    {
        return $this->milestoneTerms;
    }
    /**
     * Set milestoneTerms value
     * @param \StructType\RecordRef $milestoneTerms
     * @return \StructType\BillingScheduleMilestone
     */
    public function setMilestoneTerms(\StructType\RecordRef $milestoneTerms = null)
    {
        $this->milestoneTerms = $milestoneTerms;
        return $this;
    }
    /**
     * Get projectTask value
     * @return \StructType\RecordRef|null
     */
    public function getProjectTask()
    {
        return $this->projectTask;
    }
    /**
     * Set projectTask value
     * @param \StructType\RecordRef $projectTask
     * @return \StructType\BillingScheduleMilestone
     */
    public function setProjectTask(\StructType\RecordRef $projectTask = null)
    {
        $this->projectTask = $projectTask;
        return $this;
    }
    /**
     * Get milestoneDate value
     * @return string|null
     */
    public function getMilestoneDate()
    {
        return $this->milestoneDate;
    }
    /**
     * Set milestoneDate value
     * @param string $milestoneDate
     * @return \StructType\BillingScheduleMilestone
     */
    public function setMilestoneDate($milestoneDate = null)
    {
        // validation for constraint: string
        if (!is_null($milestoneDate) && !is_string($milestoneDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($milestoneDate, true), gettype($milestoneDate)), __LINE__);
        }
        $this->milestoneDate = $milestoneDate;
        return $this;
    }
    /**
     * Get milestoneCompleted value
     * @return bool|null
     */
    public function getMilestoneCompleted()
    {
        return $this->milestoneCompleted;
    }
    /**
     * Set milestoneCompleted value
     * @param bool $milestoneCompleted
     * @return \StructType\BillingScheduleMilestone
     */
    public function setMilestoneCompleted($milestoneCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($milestoneCompleted) && !is_bool($milestoneCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($milestoneCompleted, true), gettype($milestoneCompleted)), __LINE__);
        }
        $this->milestoneCompleted = $milestoneCompleted;
        return $this;
    }
    /**
     * Get milestoneActualCompletionDate value
     * @return string|null
     */
    public function getMilestoneActualCompletionDate()
    {
        return $this->milestoneActualCompletionDate;
    }
    /**
     * Set milestoneActualCompletionDate value
     * @param string $milestoneActualCompletionDate
     * @return \StructType\BillingScheduleMilestone
     */
    public function setMilestoneActualCompletionDate($milestoneActualCompletionDate = null)
    {
        // validation for constraint: string
        if (!is_null($milestoneActualCompletionDate) && !is_string($milestoneActualCompletionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($milestoneActualCompletionDate, true), gettype($milestoneActualCompletionDate)), __LINE__);
        }
        $this->milestoneActualCompletionDate = $milestoneActualCompletionDate;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\BillingScheduleMilestone
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
}
