<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingAccount StructType
 * @subpackage Structs
 */
class BillingAccount extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The idNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idNumber;
    /**
     * The customerDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $customerDefault;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The createdBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdBy;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frequency;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The lastBillDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastBillDate;
    /**
     * The lastBillCycleDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastBillCycleDate;
    /**
     * The nextBillCycleDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nextBillCycleDate;
    /**
     * The invoiceForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $invoiceForm;
    /**
     * The cashSaleForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $cashSaleForm;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for BillingAccount
     * @uses BillingAccount::setCustomForm()
     * @uses BillingAccount::setIdNumber()
     * @uses BillingAccount::setCustomerDefault()
     * @uses BillingAccount::setCustomer()
     * @uses BillingAccount::setSubsidiary()
     * @uses BillingAccount::setName()
     * @uses BillingAccount::setInactive()
     * @uses BillingAccount::setMemo()
     * @uses BillingAccount::setCreatedDate()
     * @uses BillingAccount::setCreatedBy()
     * @uses BillingAccount::setCurrency()
     * @uses BillingAccount::setClass()
     * @uses BillingAccount::setDepartment()
     * @uses BillingAccount::setLocation()
     * @uses BillingAccount::setBillingSchedule()
     * @uses BillingAccount::setFrequency()
     * @uses BillingAccount::setStartDate()
     * @uses BillingAccount::setLastBillDate()
     * @uses BillingAccount::setLastBillCycleDate()
     * @uses BillingAccount::setNextBillCycleDate()
     * @uses BillingAccount::setInvoiceForm()
     * @uses BillingAccount::setCashSaleForm()
     * @uses BillingAccount::setCustomFieldList()
     * @uses BillingAccount::setInternalId()
     * @uses BillingAccount::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $idNumber
     * @param bool $customerDefault
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $subsidiary
     * @param string $name
     * @param bool $inactive
     * @param string $memo
     * @param string $createdDate
     * @param string $createdBy
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $billingSchedule
     * @param string $frequency
     * @param string $startDate
     * @param string $lastBillDate
     * @param string $lastBillCycleDate
     * @param string $nextBillCycleDate
     * @param \StructType\RecordRef $invoiceForm
     * @param \StructType\RecordRef $cashSaleForm
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $idNumber = null, $customerDefault = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $subsidiary = null, $name = null, $inactive = null, $memo = null, $createdDate = null, $createdBy = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $class = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $billingSchedule = null, $frequency = null, $startDate = null, $lastBillDate = null, $lastBillCycleDate = null, $nextBillCycleDate = null, \StructType\RecordRef $invoiceForm = null, \StructType\RecordRef $cashSaleForm = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setIdNumber($idNumber)
            ->setCustomerDefault($customerDefault)
            ->setCustomer($customer)
            ->setSubsidiary($subsidiary)
            ->setName($name)
            ->setInactive($inactive)
            ->setMemo($memo)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setCurrency($currency)
            ->setClass($class)
            ->setDepartment($department)
            ->setLocation($location)
            ->setBillingSchedule($billingSchedule)
            ->setFrequency($frequency)
            ->setStartDate($startDate)
            ->setLastBillDate($lastBillDate)
            ->setLastBillCycleDate($lastBillCycleDate)
            ->setNextBillCycleDate($nextBillCycleDate)
            ->setInvoiceForm($invoiceForm)
            ->setCashSaleForm($cashSaleForm)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\BillingAccount
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get idNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->idNumber;
    }
    /**
     * Set idNumber value
     * @param string $idNumber
     * @return \StructType\BillingAccount
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idNumber, true), gettype($idNumber)), __LINE__);
        }
        $this->idNumber = $idNumber;
        return $this;
    }
    /**
     * Get customerDefault value
     * @return bool|null
     */
    public function getCustomerDefault()
    {
        return $this->customerDefault;
    }
    /**
     * Set customerDefault value
     * @param bool $customerDefault
     * @return \StructType\BillingAccount
     */
    public function setCustomerDefault($customerDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerDefault) && !is_bool($customerDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerDefault, true), gettype($customerDefault)), __LINE__);
        }
        $this->customerDefault = $customerDefault;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\BillingAccount
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\BillingAccount
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\BillingAccount
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\BillingAccount
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\BillingAccount
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\BillingAccount
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get createdBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->createdBy;
    }
    /**
     * Set createdBy value
     * @param string $createdBy
     * @return \StructType\BillingAccount
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->createdBy = $createdBy;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\BillingAccount
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\BillingAccount
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\BillingAccount
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\BillingAccount
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\BillingAccount
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->frequency;
    }
    /**
     * Set frequency value
     * @uses \EnumType\BillingAccountFrequency::valueIsValid()
     * @uses \EnumType\BillingAccountFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\BillingAccount
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingAccountFrequency::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingAccountFrequency', is_array($frequency) ? implode(', ', $frequency) : var_export($frequency, true), implode(', ', \EnumType\BillingAccountFrequency::getValidValues())), __LINE__);
        }
        $this->frequency = $frequency;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\BillingAccount
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get lastBillDate value
     * @return string|null
     */
    public function getLastBillDate()
    {
        return $this->lastBillDate;
    }
    /**
     * Set lastBillDate value
     * @param string $lastBillDate
     * @return \StructType\BillingAccount
     */
    public function setLastBillDate($lastBillDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastBillDate) && !is_string($lastBillDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastBillDate, true), gettype($lastBillDate)), __LINE__);
        }
        $this->lastBillDate = $lastBillDate;
        return $this;
    }
    /**
     * Get lastBillCycleDate value
     * @return string|null
     */
    public function getLastBillCycleDate()
    {
        return $this->lastBillCycleDate;
    }
    /**
     * Set lastBillCycleDate value
     * @param string $lastBillCycleDate
     * @return \StructType\BillingAccount
     */
    public function setLastBillCycleDate($lastBillCycleDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastBillCycleDate) && !is_string($lastBillCycleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastBillCycleDate, true), gettype($lastBillCycleDate)), __LINE__);
        }
        $this->lastBillCycleDate = $lastBillCycleDate;
        return $this;
    }
    /**
     * Get nextBillCycleDate value
     * @return string|null
     */
    public function getNextBillCycleDate()
    {
        return $this->nextBillCycleDate;
    }
    /**
     * Set nextBillCycleDate value
     * @param string $nextBillCycleDate
     * @return \StructType\BillingAccount
     */
    public function setNextBillCycleDate($nextBillCycleDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextBillCycleDate) && !is_string($nextBillCycleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextBillCycleDate, true), gettype($nextBillCycleDate)), __LINE__);
        }
        $this->nextBillCycleDate = $nextBillCycleDate;
        return $this;
    }
    /**
     * Get invoiceForm value
     * @return \StructType\RecordRef|null
     */
    public function getInvoiceForm()
    {
        return $this->invoiceForm;
    }
    /**
     * Set invoiceForm value
     * @param \StructType\RecordRef $invoiceForm
     * @return \StructType\BillingAccount
     */
    public function setInvoiceForm(\StructType\RecordRef $invoiceForm = null)
    {
        $this->invoiceForm = $invoiceForm;
        return $this;
    }
    /**
     * Get cashSaleForm value
     * @return \StructType\RecordRef|null
     */
    public function getCashSaleForm()
    {
        return $this->cashSaleForm;
    }
    /**
     * Set cashSaleForm value
     * @param \StructType\RecordRef $cashSaleForm
     * @return \StructType\BillingAccount
     */
    public function setCashSaleForm(\StructType\RecordRef $cashSaleForm = null)
    {
        $this->cashSaleForm = $cashSaleForm;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\BillingAccount
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\BillingAccount
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\BillingAccount
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
