<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssemblyComponentList StructType
 * @subpackage Structs
 */
class AssemblyComponentList extends AbstractStructBase
{
    /**
     * The component
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AssemblyComponent[]
     */
    public $component;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for AssemblyComponentList
     * @uses AssemblyComponentList::setComponent()
     * @uses AssemblyComponentList::setReplaceAll()
     * @param \StructType\AssemblyComponent[] $component
     * @param bool $replaceAll
     */
    public function __construct(array $component = array(), $replaceAll = false)
    {
        $this
            ->setComponent($component)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get component value
     * @return \StructType\AssemblyComponent[]|null
     */
    public function getComponent()
    {
        return $this->component;
    }
    /**
     * This method is responsible for validating the values passed to the setComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComponentForArrayConstraintsFromSetComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assemblyComponentListComponentItem) {
            // validation for constraint: itemType
            if (!$assemblyComponentListComponentItem instanceof \StructType\AssemblyComponent) {
                $invalidValues[] = is_object($assemblyComponentListComponentItem) ? get_class($assemblyComponentListComponentItem) : sprintf('%s(%s)', gettype($assemblyComponentListComponentItem), var_export($assemblyComponentListComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The component property can only contain items of type \StructType\AssemblyComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set component value
     * @throws \InvalidArgumentException
     * @param \StructType\AssemblyComponent[] $component
     * @return \StructType\AssemblyComponentList
     */
    public function setComponent(array $component = array())
    {
        // validation for constraint: array
        if ('' !== ($componentArrayErrorMessage = self::validateComponentForArrayConstraintsFromSetComponent($component))) {
            throw new \InvalidArgumentException($componentArrayErrorMessage, __LINE__);
        }
        $this->component = $component;
        return $this;
    }
    /**
     * Add item to component value
     * @throws \InvalidArgumentException
     * @param \StructType\AssemblyComponent $item
     * @return \StructType\AssemblyComponentList
     */
    public function addToComponent(\StructType\AssemblyComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssemblyComponent) {
            throw new \InvalidArgumentException(sprintf('The component property can only contain items of type \StructType\AssemblyComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->component[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\AssemblyComponentList
     */
    public function setReplaceAll($replaceAll = false)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
