<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssemblyComponent StructType
 * @subpackage Structs
 */
class AssemblyComponent extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The componentInventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $componentInventoryDetail;
    /**
     * The componentNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $componentNumbers;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lineNumber;
    /**
     * Constructor method for AssemblyComponent
     * @uses AssemblyComponent::setItem()
     * @uses AssemblyComponent::setQuantity()
     * @uses AssemblyComponent::setQuantityOnHand()
     * @uses AssemblyComponent::setComponentInventoryDetail()
     * @uses AssemblyComponent::setComponentNumbers()
     * @uses AssemblyComponent::setBinNumbers()
     * @uses AssemblyComponent::setLineNumber()
     * @param \StructType\RecordRef $item
     * @param float $quantity
     * @param float $quantityOnHand
     * @param \StructType\InventoryDetail $componentInventoryDetail
     * @param string $componentNumbers
     * @param string $binNumbers
     * @param int $lineNumber
     */
    public function __construct(\StructType\RecordRef $item = null, $quantity = null, $quantityOnHand = null, \StructType\InventoryDetail $componentInventoryDetail = null, $componentNumbers = null, $binNumbers = null, $lineNumber = null)
    {
        $this
            ->setItem($item)
            ->setQuantity($quantity)
            ->setQuantityOnHand($quantityOnHand)
            ->setComponentInventoryDetail($componentInventoryDetail)
            ->setComponentNumbers($componentNumbers)
            ->setBinNumbers($binNumbers)
            ->setLineNumber($lineNumber);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\AssemblyComponent
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\AssemblyComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\AssemblyComponent
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get componentInventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getComponentInventoryDetail()
    {
        return $this->componentInventoryDetail;
    }
    /**
     * Set componentInventoryDetail value
     * @param \StructType\InventoryDetail $componentInventoryDetail
     * @return \StructType\AssemblyComponent
     */
    public function setComponentInventoryDetail(\StructType\InventoryDetail $componentInventoryDetail = null)
    {
        $this->componentInventoryDetail = $componentInventoryDetail;
        return $this;
    }
    /**
     * Get componentNumbers value
     * @return string|null
     */
    public function getComponentNumbers()
    {
        return $this->componentNumbers;
    }
    /**
     * Set componentNumbers value
     * @param string $componentNumbers
     * @return \StructType\AssemblyComponent
     */
    public function setComponentNumbers($componentNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($componentNumbers) && !is_string($componentNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentNumbers, true), gettype($componentNumbers)), __LINE__);
        }
        $this->componentNumbers = $componentNumbers;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\AssemblyComponent
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param int $lineNumber
     * @return \StructType\AssemblyComponent
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
}
