<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingTransactionSearchRowBasic StructType
 * @subpackage Structs
 */
class AccountingTransactionSearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $account;
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $accountingBook;
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $accountType;
    /**
     * The altSalesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $altSalesAmount;
    /**
     * The altSalesNetAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $altSalesNetAmount;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $amount;
    /**
     * The baseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $baseCurrency;
    /**
     * The catchUpPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $catchUpPeriod;
    /**
     * The creditAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $creditAmount;
    /**
     * The customGL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $customGL;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $dateCreated;
    /**
     * The debitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $debitAmount;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $deferRevRec;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $exchangeRate;
    /**
     * The fxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $fxAmount;
    /**
     * The grossAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $grossAmount;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastModifiedDate;
    /**
     * The multiSubsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $multiSubsidiary;
    /**
     * The netAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $netAmount;
    /**
     * The posting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $posting;
    /**
     * The quantityRevCommitted
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityRevCommitted;
    /**
     * The recognizedRevenue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $recognizedRevenue;
    /**
     * The revCommitStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $revCommitStatus;
    /**
     * The revenueStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $revenueStatus;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $revRecEndDate;
    /**
     * The revRecOnRevCommitment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $revRecOnRevCommitment;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $revRecStartDate;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The tranIsVsoeBundle
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $tranIsVsoeBundle;
    /**
     * The vsoeAllocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $vsoeAllocation;
    /**
     * Constructor method for AccountingTransactionSearchRowBasic
     * @uses AccountingTransactionSearchRowBasic::setAccount()
     * @uses AccountingTransactionSearchRowBasic::setAccountingBook()
     * @uses AccountingTransactionSearchRowBasic::setAccountType()
     * @uses AccountingTransactionSearchRowBasic::setAltSalesAmount()
     * @uses AccountingTransactionSearchRowBasic::setAltSalesNetAmount()
     * @uses AccountingTransactionSearchRowBasic::setAmount()
     * @uses AccountingTransactionSearchRowBasic::setBaseCurrency()
     * @uses AccountingTransactionSearchRowBasic::setCatchUpPeriod()
     * @uses AccountingTransactionSearchRowBasic::setCreditAmount()
     * @uses AccountingTransactionSearchRowBasic::setCustomGL()
     * @uses AccountingTransactionSearchRowBasic::setDateCreated()
     * @uses AccountingTransactionSearchRowBasic::setDebitAmount()
     * @uses AccountingTransactionSearchRowBasic::setDeferRevRec()
     * @uses AccountingTransactionSearchRowBasic::setExchangeRate()
     * @uses AccountingTransactionSearchRowBasic::setFxAmount()
     * @uses AccountingTransactionSearchRowBasic::setGrossAmount()
     * @uses AccountingTransactionSearchRowBasic::setInternalId()
     * @uses AccountingTransactionSearchRowBasic::setLastModifiedDate()
     * @uses AccountingTransactionSearchRowBasic::setMultiSubsidiary()
     * @uses AccountingTransactionSearchRowBasic::setNetAmount()
     * @uses AccountingTransactionSearchRowBasic::setPosting()
     * @uses AccountingTransactionSearchRowBasic::setQuantityRevCommitted()
     * @uses AccountingTransactionSearchRowBasic::setRecognizedRevenue()
     * @uses AccountingTransactionSearchRowBasic::setRevCommitStatus()
     * @uses AccountingTransactionSearchRowBasic::setRevenueStatus()
     * @uses AccountingTransactionSearchRowBasic::setRevRecEndDate()
     * @uses AccountingTransactionSearchRowBasic::setRevRecOnRevCommitment()
     * @uses AccountingTransactionSearchRowBasic::setRevRecStartDate()
     * @uses AccountingTransactionSearchRowBasic::setSubsidiary()
     * @uses AccountingTransactionSearchRowBasic::setTranIsVsoeBundle()
     * @uses AccountingTransactionSearchRowBasic::setVsoeAllocation()
     * @param \StructType\SearchColumnSelectField[] $account
     * @param \StructType\SearchColumnSelectField[] $accountingBook
     * @param \StructType\SearchColumnStringField[] $accountType
     * @param \StructType\SearchColumnDoubleField[] $altSalesAmount
     * @param \StructType\SearchColumnDoubleField[] $altSalesNetAmount
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @param \StructType\SearchColumnStringField[] $baseCurrency
     * @param \StructType\SearchColumnStringField[] $catchUpPeriod
     * @param \StructType\SearchColumnDoubleField[] $creditAmount
     * @param \StructType\SearchColumnBooleanField[] $customGL
     * @param \StructType\SearchColumnDateField[] $dateCreated
     * @param \StructType\SearchColumnDoubleField[] $debitAmount
     * @param \StructType\SearchColumnBooleanField[] $deferRevRec
     * @param \StructType\SearchColumnDoubleField[] $exchangeRate
     * @param \StructType\SearchColumnDoubleField[] $fxAmount
     * @param \StructType\SearchColumnDoubleField[] $grossAmount
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @param \StructType\SearchColumnBooleanField[] $multiSubsidiary
     * @param \StructType\SearchColumnDoubleField[] $netAmount
     * @param \StructType\SearchColumnBooleanField[] $posting
     * @param \StructType\SearchColumnDoubleField[] $quantityRevCommitted
     * @param \StructType\SearchColumnDoubleField[] $recognizedRevenue
     * @param \StructType\SearchColumnEnumSelectField[] $revCommitStatus
     * @param \StructType\SearchColumnEnumSelectField[] $revenueStatus
     * @param \StructType\SearchColumnDateField[] $revRecEndDate
     * @param \StructType\SearchColumnBooleanField[] $revRecOnRevCommitment
     * @param \StructType\SearchColumnDateField[] $revRecStartDate
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnBooleanField[] $tranIsVsoeBundle
     * @param \StructType\SearchColumnDoubleField[] $vsoeAllocation
     */
    public function __construct(array $account = array(), array $accountingBook = array(), array $accountType = array(), array $altSalesAmount = array(), array $altSalesNetAmount = array(), array $amount = array(), array $baseCurrency = array(), array $catchUpPeriod = array(), array $creditAmount = array(), array $customGL = array(), array $dateCreated = array(), array $debitAmount = array(), array $deferRevRec = array(), array $exchangeRate = array(), array $fxAmount = array(), array $grossAmount = array(), array $internalId = array(), array $lastModifiedDate = array(), array $multiSubsidiary = array(), array $netAmount = array(), array $posting = array(), array $quantityRevCommitted = array(), array $recognizedRevenue = array(), array $revCommitStatus = array(), array $revenueStatus = array(), array $revRecEndDate = array(), array $revRecOnRevCommitment = array(), array $revRecStartDate = array(), array $subsidiary = array(), array $tranIsVsoeBundle = array(), array $vsoeAllocation = array())
    {
        $this
            ->setAccount($account)
            ->setAccountingBook($accountingBook)
            ->setAccountType($accountType)
            ->setAltSalesAmount($altSalesAmount)
            ->setAltSalesNetAmount($altSalesNetAmount)
            ->setAmount($amount)
            ->setBaseCurrency($baseCurrency)
            ->setCatchUpPeriod($catchUpPeriod)
            ->setCreditAmount($creditAmount)
            ->setCustomGL($customGL)
            ->setDateCreated($dateCreated)
            ->setDebitAmount($debitAmount)
            ->setDeferRevRec($deferRevRec)
            ->setExchangeRate($exchangeRate)
            ->setFxAmount($fxAmount)
            ->setGrossAmount($grossAmount)
            ->setInternalId($internalId)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMultiSubsidiary($multiSubsidiary)
            ->setNetAmount($netAmount)
            ->setPosting($posting)
            ->setQuantityRevCommitted($quantityRevCommitted)
            ->setRecognizedRevenue($recognizedRevenue)
            ->setRevCommitStatus($revCommitStatus)
            ->setRevenueStatus($revenueStatus)
            ->setRevRecEndDate($revRecEndDate)
            ->setRevRecOnRevCommitment($revRecOnRevCommitment)
            ->setRevRecStartDate($revRecStartDate)
            ->setSubsidiary($subsidiary)
            ->setTranIsVsoeBundle($tranIsVsoeBundle)
            ->setVsoeAllocation($vsoeAllocation);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicAccountItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicAccountItem) ? get_class($accountingTransactionSearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicAccountItem), var_export($accountingTransactionSearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $account
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get accountingBook value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountingBook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountingBook method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountingBookForArrayConstraintsFromSetAccountingBook(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicAccountingBookItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicAccountingBookItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicAccountingBookItem) ? get_class($accountingTransactionSearchRowBasicAccountingBookItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicAccountingBookItem), var_export($accountingTransactionSearchRowBasicAccountingBookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountingBook property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountingBook value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $accountingBook
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setAccountingBook(array $accountingBook = array())
    {
        // validation for constraint: array
        if ('' !== ($accountingBookArrayErrorMessage = self::validateAccountingBookForArrayConstraintsFromSetAccountingBook($accountingBook))) {
            throw new \InvalidArgumentException($accountingBookArrayErrorMessage, __LINE__);
        }
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Add item to accountingBook value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToAccountingBook(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The accountingBook property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountingBook[] = $item;
        return $this;
    }
    /**
     * Get accountType value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountTypeForArrayConstraintsFromSetAccountType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicAccountTypeItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicAccountTypeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicAccountTypeItem) ? get_class($accountingTransactionSearchRowBasicAccountTypeItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicAccountTypeItem), var_export($accountingTransactionSearchRowBasicAccountTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $accountType
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setAccountType(array $accountType = array())
    {
        // validation for constraint: array
        if ('' !== ($accountTypeArrayErrorMessage = self::validateAccountTypeForArrayConstraintsFromSetAccountType($accountType))) {
            throw new \InvalidArgumentException($accountTypeArrayErrorMessage, __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Add item to accountType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToAccountType(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The accountType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountType[] = $item;
        return $this;
    }
    /**
     * Get altSalesAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAltSalesAmount()
    {
        return $this->altSalesAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setAltSalesAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAltSalesAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAltSalesAmountForArrayConstraintsFromSetAltSalesAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicAltSalesAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicAltSalesAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicAltSalesAmountItem) ? get_class($accountingTransactionSearchRowBasicAltSalesAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicAltSalesAmountItem), var_export($accountingTransactionSearchRowBasicAltSalesAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The altSalesAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set altSalesAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $altSalesAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setAltSalesAmount(array $altSalesAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($altSalesAmountArrayErrorMessage = self::validateAltSalesAmountForArrayConstraintsFromSetAltSalesAmount($altSalesAmount))) {
            throw new \InvalidArgumentException($altSalesAmountArrayErrorMessage, __LINE__);
        }
        $this->altSalesAmount = $altSalesAmount;
        return $this;
    }
    /**
     * Add item to altSalesAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToAltSalesAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The altSalesAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->altSalesAmount[] = $item;
        return $this;
    }
    /**
     * Get altSalesNetAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAltSalesNetAmount()
    {
        return $this->altSalesNetAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setAltSalesNetAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAltSalesNetAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAltSalesNetAmountForArrayConstraintsFromSetAltSalesNetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicAltSalesNetAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicAltSalesNetAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicAltSalesNetAmountItem) ? get_class($accountingTransactionSearchRowBasicAltSalesNetAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicAltSalesNetAmountItem), var_export($accountingTransactionSearchRowBasicAltSalesNetAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The altSalesNetAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set altSalesNetAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $altSalesNetAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setAltSalesNetAmount(array $altSalesNetAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($altSalesNetAmountArrayErrorMessage = self::validateAltSalesNetAmountForArrayConstraintsFromSetAltSalesNetAmount($altSalesNetAmount))) {
            throw new \InvalidArgumentException($altSalesNetAmountArrayErrorMessage, __LINE__);
        }
        $this->altSalesNetAmount = $altSalesNetAmount;
        return $this;
    }
    /**
     * Add item to altSalesNetAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToAltSalesNetAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The altSalesNetAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->altSalesNetAmount[] = $item;
        return $this;
    }
    /**
     * Get amount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * This method is responsible for validating the values passed to the setAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountForArrayConstraintsFromSetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicAmountItem) ? get_class($accountingTransactionSearchRowBasicAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicAmountItem), var_export($accountingTransactionSearchRowBasicAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $amount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setAmount(array $amount = array())
    {
        // validation for constraint: array
        if ('' !== ($amountArrayErrorMessage = self::validateAmountForArrayConstraintsFromSetAmount($amount))) {
            throw new \InvalidArgumentException($amountArrayErrorMessage, __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Add item to amount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The amount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->amount[] = $item;
        return $this;
    }
    /**
     * Get baseCurrency value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getBaseCurrency()
    {
        return $this->baseCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseCurrencyForArrayConstraintsFromSetBaseCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicBaseCurrencyItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicBaseCurrencyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicBaseCurrencyItem) ? get_class($accountingTransactionSearchRowBasicBaseCurrencyItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicBaseCurrencyItem), var_export($accountingTransactionSearchRowBasicBaseCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The baseCurrency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set baseCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $baseCurrency
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setBaseCurrency(array $baseCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($baseCurrencyArrayErrorMessage = self::validateBaseCurrencyForArrayConstraintsFromSetBaseCurrency($baseCurrency))) {
            throw new \InvalidArgumentException($baseCurrencyArrayErrorMessage, __LINE__);
        }
        $this->baseCurrency = $baseCurrency;
        return $this;
    }
    /**
     * Add item to baseCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToBaseCurrency(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The baseCurrency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->baseCurrency[] = $item;
        return $this;
    }
    /**
     * Get catchUpPeriod value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCatchUpPeriod()
    {
        return $this->catchUpPeriod;
    }
    /**
     * This method is responsible for validating the values passed to the setCatchUpPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatchUpPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatchUpPeriodForArrayConstraintsFromSetCatchUpPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicCatchUpPeriodItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicCatchUpPeriodItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicCatchUpPeriodItem) ? get_class($accountingTransactionSearchRowBasicCatchUpPeriodItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicCatchUpPeriodItem), var_export($accountingTransactionSearchRowBasicCatchUpPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The catchUpPeriod property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set catchUpPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $catchUpPeriod
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setCatchUpPeriod(array $catchUpPeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($catchUpPeriodArrayErrorMessage = self::validateCatchUpPeriodForArrayConstraintsFromSetCatchUpPeriod($catchUpPeriod))) {
            throw new \InvalidArgumentException($catchUpPeriodArrayErrorMessage, __LINE__);
        }
        $this->catchUpPeriod = $catchUpPeriod;
        return $this;
    }
    /**
     * Add item to catchUpPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToCatchUpPeriod(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The catchUpPeriod property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->catchUpPeriod[] = $item;
        return $this;
    }
    /**
     * Get creditAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCreditAmount()
    {
        return $this->creditAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditAmountForArrayConstraintsFromSetCreditAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicCreditAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicCreditAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicCreditAmountItem) ? get_class($accountingTransactionSearchRowBasicCreditAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicCreditAmountItem), var_export($accountingTransactionSearchRowBasicCreditAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The creditAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set creditAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $creditAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setCreditAmount(array $creditAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($creditAmountArrayErrorMessage = self::validateCreditAmountForArrayConstraintsFromSetCreditAmount($creditAmount))) {
            throw new \InvalidArgumentException($creditAmountArrayErrorMessage, __LINE__);
        }
        $this->creditAmount = $creditAmount;
        return $this;
    }
    /**
     * Add item to creditAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToCreditAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The creditAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->creditAmount[] = $item;
        return $this;
    }
    /**
     * Get customGL value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getCustomGL()
    {
        return $this->customGL;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomGL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomGL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomGLForArrayConstraintsFromSetCustomGL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicCustomGLItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicCustomGLItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicCustomGLItem) ? get_class($accountingTransactionSearchRowBasicCustomGLItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicCustomGLItem), var_export($accountingTransactionSearchRowBasicCustomGLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customGL property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customGL value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $customGL
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setCustomGL(array $customGL = array())
    {
        // validation for constraint: array
        if ('' !== ($customGLArrayErrorMessage = self::validateCustomGLForArrayConstraintsFromSetCustomGL($customGL))) {
            throw new \InvalidArgumentException($customGLArrayErrorMessage, __LINE__);
        }
        $this->customGL = $customGL;
        return $this;
    }
    /**
     * Add item to customGL value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToCustomGL(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The customGL property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customGL[] = $item;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * This method is responsible for validating the values passed to the setDateCreated method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateCreated method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateCreatedForArrayConstraintsFromSetDateCreated(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicDateCreatedItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicDateCreatedItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicDateCreatedItem) ? get_class($accountingTransactionSearchRowBasicDateCreatedItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicDateCreatedItem), var_export($accountingTransactionSearchRowBasicDateCreatedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateCreated property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $dateCreated
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setDateCreated(array $dateCreated = array())
    {
        // validation for constraint: array
        if ('' !== ($dateCreatedArrayErrorMessage = self::validateDateCreatedForArrayConstraintsFromSetDateCreated($dateCreated))) {
            throw new \InvalidArgumentException($dateCreatedArrayErrorMessage, __LINE__);
        }
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Add item to dateCreated value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToDateCreated(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The dateCreated property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateCreated[] = $item;
        return $this;
    }
    /**
     * Get debitAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getDebitAmount()
    {
        return $this->debitAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setDebitAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDebitAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDebitAmountForArrayConstraintsFromSetDebitAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicDebitAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicDebitAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicDebitAmountItem) ? get_class($accountingTransactionSearchRowBasicDebitAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicDebitAmountItem), var_export($accountingTransactionSearchRowBasicDebitAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The debitAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set debitAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $debitAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setDebitAmount(array $debitAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($debitAmountArrayErrorMessage = self::validateDebitAmountForArrayConstraintsFromSetDebitAmount($debitAmount))) {
            throw new \InvalidArgumentException($debitAmountArrayErrorMessage, __LINE__);
        }
        $this->debitAmount = $debitAmount;
        return $this;
    }
    /**
     * Add item to debitAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToDebitAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The debitAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->debitAmount[] = $item;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * This method is responsible for validating the values passed to the setDeferRevRec method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeferRevRec method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeferRevRecForArrayConstraintsFromSetDeferRevRec(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicDeferRevRecItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicDeferRevRecItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicDeferRevRecItem) ? get_class($accountingTransactionSearchRowBasicDeferRevRecItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicDeferRevRecItem), var_export($accountingTransactionSearchRowBasicDeferRevRecItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The deferRevRec property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set deferRevRec value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $deferRevRec
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setDeferRevRec(array $deferRevRec = array())
    {
        // validation for constraint: array
        if ('' !== ($deferRevRecArrayErrorMessage = self::validateDeferRevRecForArrayConstraintsFromSetDeferRevRec($deferRevRec))) {
            throw new \InvalidArgumentException($deferRevRecArrayErrorMessage, __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Add item to deferRevRec value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToDeferRevRec(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The deferRevRec property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->deferRevRec[] = $item;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * This method is responsible for validating the values passed to the setExchangeRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExchangeRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExchangeRateForArrayConstraintsFromSetExchangeRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicExchangeRateItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicExchangeRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicExchangeRateItem) ? get_class($accountingTransactionSearchRowBasicExchangeRateItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicExchangeRateItem), var_export($accountingTransactionSearchRowBasicExchangeRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The exchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set exchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $exchangeRate
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setExchangeRate(array $exchangeRate = array())
    {
        // validation for constraint: array
        if ('' !== ($exchangeRateArrayErrorMessage = self::validateExchangeRateForArrayConstraintsFromSetExchangeRate($exchangeRate))) {
            throw new \InvalidArgumentException($exchangeRateArrayErrorMessage, __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Add item to exchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToExchangeRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The exchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->exchangeRate[] = $item;
        return $this;
    }
    /**
     * Get fxAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getFxAmount()
    {
        return $this->fxAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setFxAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFxAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFxAmountForArrayConstraintsFromSetFxAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicFxAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicFxAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicFxAmountItem) ? get_class($accountingTransactionSearchRowBasicFxAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicFxAmountItem), var_export($accountingTransactionSearchRowBasicFxAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fxAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $fxAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setFxAmount(array $fxAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($fxAmountArrayErrorMessage = self::validateFxAmountForArrayConstraintsFromSetFxAmount($fxAmount))) {
            throw new \InvalidArgumentException($fxAmountArrayErrorMessage, __LINE__);
        }
        $this->fxAmount = $fxAmount;
        return $this;
    }
    /**
     * Add item to fxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToFxAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The fxAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fxAmount[] = $item;
        return $this;
    }
    /**
     * Get grossAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getGrossAmount()
    {
        return $this->grossAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setGrossAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrossAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGrossAmountForArrayConstraintsFromSetGrossAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicGrossAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicGrossAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicGrossAmountItem) ? get_class($accountingTransactionSearchRowBasicGrossAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicGrossAmountItem), var_export($accountingTransactionSearchRowBasicGrossAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The grossAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set grossAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $grossAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setGrossAmount(array $grossAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($grossAmountArrayErrorMessage = self::validateGrossAmountForArrayConstraintsFromSetGrossAmount($grossAmount))) {
            throw new \InvalidArgumentException($grossAmountArrayErrorMessage, __LINE__);
        }
        $this->grossAmount = $grossAmount;
        return $this;
    }
    /**
     * Add item to grossAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToGrossAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The grossAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->grossAmount[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicInternalIdItem) ? get_class($accountingTransactionSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicInternalIdItem), var_export($accountingTransactionSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastModifiedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastModifiedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicLastModifiedDateItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicLastModifiedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicLastModifiedDateItem) ? get_class($accountingTransactionSearchRowBasicLastModifiedDateItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicLastModifiedDateItem), var_export($accountingTransactionSearchRowBasicLastModifiedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setLastModifiedDate(array $lastModifiedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastModifiedDateArrayErrorMessage = self::validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate($lastModifiedDate))) {
            throw new \InvalidArgumentException($lastModifiedDateArrayErrorMessage, __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Add item to lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToLastModifiedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastModifiedDate[] = $item;
        return $this;
    }
    /**
     * Get multiSubsidiary value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getMultiSubsidiary()
    {
        return $this->multiSubsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiSubsidiaryForArrayConstraintsFromSetMultiSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicMultiSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicMultiSubsidiaryItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicMultiSubsidiaryItem) ? get_class($accountingTransactionSearchRowBasicMultiSubsidiaryItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicMultiSubsidiaryItem), var_export($accountingTransactionSearchRowBasicMultiSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The multiSubsidiary property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set multiSubsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $multiSubsidiary
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setMultiSubsidiary(array $multiSubsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($multiSubsidiaryArrayErrorMessage = self::validateMultiSubsidiaryForArrayConstraintsFromSetMultiSubsidiary($multiSubsidiary))) {
            throw new \InvalidArgumentException($multiSubsidiaryArrayErrorMessage, __LINE__);
        }
        $this->multiSubsidiary = $multiSubsidiary;
        return $this;
    }
    /**
     * Add item to multiSubsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToMultiSubsidiary(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The multiSubsidiary property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->multiSubsidiary[] = $item;
        return $this;
    }
    /**
     * Get netAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getNetAmount()
    {
        return $this->netAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setNetAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetAmountForArrayConstraintsFromSetNetAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicNetAmountItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicNetAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicNetAmountItem) ? get_class($accountingTransactionSearchRowBasicNetAmountItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicNetAmountItem), var_export($accountingTransactionSearchRowBasicNetAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The netAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set netAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $netAmount
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setNetAmount(array $netAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($netAmountArrayErrorMessage = self::validateNetAmountForArrayConstraintsFromSetNetAmount($netAmount))) {
            throw new \InvalidArgumentException($netAmountArrayErrorMessage, __LINE__);
        }
        $this->netAmount = $netAmount;
        return $this;
    }
    /**
     * Add item to netAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToNetAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The netAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->netAmount[] = $item;
        return $this;
    }
    /**
     * Get posting value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getPosting()
    {
        return $this->posting;
    }
    /**
     * This method is responsible for validating the values passed to the setPosting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostingForArrayConstraintsFromSetPosting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicPostingItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicPostingItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicPostingItem) ? get_class($accountingTransactionSearchRowBasicPostingItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicPostingItem), var_export($accountingTransactionSearchRowBasicPostingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The posting property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set posting value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $posting
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setPosting(array $posting = array())
    {
        // validation for constraint: array
        if ('' !== ($postingArrayErrorMessage = self::validatePostingForArrayConstraintsFromSetPosting($posting))) {
            throw new \InvalidArgumentException($postingArrayErrorMessage, __LINE__);
        }
        $this->posting = $posting;
        return $this;
    }
    /**
     * Add item to posting value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToPosting(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The posting property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->posting[] = $item;
        return $this;
    }
    /**
     * Get quantityRevCommitted value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityRevCommitted()
    {
        return $this->quantityRevCommitted;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityRevCommitted method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityRevCommitted method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityRevCommittedForArrayConstraintsFromSetQuantityRevCommitted(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicQuantityRevCommittedItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicQuantityRevCommittedItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicQuantityRevCommittedItem) ? get_class($accountingTransactionSearchRowBasicQuantityRevCommittedItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicQuantityRevCommittedItem), var_export($accountingTransactionSearchRowBasicQuantityRevCommittedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityRevCommitted property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityRevCommitted value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityRevCommitted
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setQuantityRevCommitted(array $quantityRevCommitted = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityRevCommittedArrayErrorMessage = self::validateQuantityRevCommittedForArrayConstraintsFromSetQuantityRevCommitted($quantityRevCommitted))) {
            throw new \InvalidArgumentException($quantityRevCommittedArrayErrorMessage, __LINE__);
        }
        $this->quantityRevCommitted = $quantityRevCommitted;
        return $this;
    }
    /**
     * Add item to quantityRevCommitted value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToQuantityRevCommitted(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityRevCommitted property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityRevCommitted[] = $item;
        return $this;
    }
    /**
     * Get recognizedRevenue value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getRecognizedRevenue()
    {
        return $this->recognizedRevenue;
    }
    /**
     * This method is responsible for validating the values passed to the setRecognizedRevenue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecognizedRevenue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecognizedRevenueForArrayConstraintsFromSetRecognizedRevenue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicRecognizedRevenueItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicRecognizedRevenueItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicRecognizedRevenueItem) ? get_class($accountingTransactionSearchRowBasicRecognizedRevenueItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicRecognizedRevenueItem), var_export($accountingTransactionSearchRowBasicRecognizedRevenueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recognizedRevenue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recognizedRevenue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $recognizedRevenue
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setRecognizedRevenue(array $recognizedRevenue = array())
    {
        // validation for constraint: array
        if ('' !== ($recognizedRevenueArrayErrorMessage = self::validateRecognizedRevenueForArrayConstraintsFromSetRecognizedRevenue($recognizedRevenue))) {
            throw new \InvalidArgumentException($recognizedRevenueArrayErrorMessage, __LINE__);
        }
        $this->recognizedRevenue = $recognizedRevenue;
        return $this;
    }
    /**
     * Add item to recognizedRevenue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToRecognizedRevenue(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The recognizedRevenue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recognizedRevenue[] = $item;
        return $this;
    }
    /**
     * Get revCommitStatus value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getRevCommitStatus()
    {
        return $this->revCommitStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setRevCommitStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevCommitStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevCommitStatusForArrayConstraintsFromSetRevCommitStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicRevCommitStatusItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicRevCommitStatusItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicRevCommitStatusItem) ? get_class($accountingTransactionSearchRowBasicRevCommitStatusItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicRevCommitStatusItem), var_export($accountingTransactionSearchRowBasicRevCommitStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The revCommitStatus property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set revCommitStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $revCommitStatus
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setRevCommitStatus(array $revCommitStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($revCommitStatusArrayErrorMessage = self::validateRevCommitStatusForArrayConstraintsFromSetRevCommitStatus($revCommitStatus))) {
            throw new \InvalidArgumentException($revCommitStatusArrayErrorMessage, __LINE__);
        }
        $this->revCommitStatus = $revCommitStatus;
        return $this;
    }
    /**
     * Add item to revCommitStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToRevCommitStatus(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The revCommitStatus property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->revCommitStatus[] = $item;
        return $this;
    }
    /**
     * Get revenueStatus value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getRevenueStatus()
    {
        return $this->revenueStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setRevenueStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevenueStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevenueStatusForArrayConstraintsFromSetRevenueStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicRevenueStatusItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicRevenueStatusItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicRevenueStatusItem) ? get_class($accountingTransactionSearchRowBasicRevenueStatusItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicRevenueStatusItem), var_export($accountingTransactionSearchRowBasicRevenueStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The revenueStatus property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set revenueStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $revenueStatus
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setRevenueStatus(array $revenueStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($revenueStatusArrayErrorMessage = self::validateRevenueStatusForArrayConstraintsFromSetRevenueStatus($revenueStatus))) {
            throw new \InvalidArgumentException($revenueStatusArrayErrorMessage, __LINE__);
        }
        $this->revenueStatus = $revenueStatus;
        return $this;
    }
    /**
     * Add item to revenueStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToRevenueStatus(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The revenueStatus property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->revenueStatus[] = $item;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * This method is responsible for validating the values passed to the setRevRecEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevRecEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevRecEndDateForArrayConstraintsFromSetRevRecEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicRevRecEndDateItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicRevRecEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicRevRecEndDateItem) ? get_class($accountingTransactionSearchRowBasicRevRecEndDateItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicRevRecEndDateItem), var_export($accountingTransactionSearchRowBasicRevRecEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The revRecEndDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set revRecEndDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $revRecEndDate
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setRevRecEndDate(array $revRecEndDate = array())
    {
        // validation for constraint: array
        if ('' !== ($revRecEndDateArrayErrorMessage = self::validateRevRecEndDateForArrayConstraintsFromSetRevRecEndDate($revRecEndDate))) {
            throw new \InvalidArgumentException($revRecEndDateArrayErrorMessage, __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Add item to revRecEndDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToRevRecEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The revRecEndDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->revRecEndDate[] = $item;
        return $this;
    }
    /**
     * Get revRecOnRevCommitment value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getRevRecOnRevCommitment()
    {
        return $this->revRecOnRevCommitment;
    }
    /**
     * This method is responsible for validating the values passed to the setRevRecOnRevCommitment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevRecOnRevCommitment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevRecOnRevCommitmentForArrayConstraintsFromSetRevRecOnRevCommitment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicRevRecOnRevCommitmentItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicRevRecOnRevCommitmentItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicRevRecOnRevCommitmentItem) ? get_class($accountingTransactionSearchRowBasicRevRecOnRevCommitmentItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicRevRecOnRevCommitmentItem), var_export($accountingTransactionSearchRowBasicRevRecOnRevCommitmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The revRecOnRevCommitment property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set revRecOnRevCommitment value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $revRecOnRevCommitment
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setRevRecOnRevCommitment(array $revRecOnRevCommitment = array())
    {
        // validation for constraint: array
        if ('' !== ($revRecOnRevCommitmentArrayErrorMessage = self::validateRevRecOnRevCommitmentForArrayConstraintsFromSetRevRecOnRevCommitment($revRecOnRevCommitment))) {
            throw new \InvalidArgumentException($revRecOnRevCommitmentArrayErrorMessage, __LINE__);
        }
        $this->revRecOnRevCommitment = $revRecOnRevCommitment;
        return $this;
    }
    /**
     * Add item to revRecOnRevCommitment value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToRevRecOnRevCommitment(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The revRecOnRevCommitment property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->revRecOnRevCommitment[] = $item;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * This method is responsible for validating the values passed to the setRevRecStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevRecStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevRecStartDateForArrayConstraintsFromSetRevRecStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicRevRecStartDateItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicRevRecStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicRevRecStartDateItem) ? get_class($accountingTransactionSearchRowBasicRevRecStartDateItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicRevRecStartDateItem), var_export($accountingTransactionSearchRowBasicRevRecStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The revRecStartDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set revRecStartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $revRecStartDate
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setRevRecStartDate(array $revRecStartDate = array())
    {
        // validation for constraint: array
        if ('' !== ($revRecStartDateArrayErrorMessage = self::validateRevRecStartDateForArrayConstraintsFromSetRevRecStartDate($revRecStartDate))) {
            throw new \InvalidArgumentException($revRecStartDateArrayErrorMessage, __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Add item to revRecStartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToRevRecStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The revRecStartDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->revRecStartDate[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicSubsidiaryItem) ? get_class($accountingTransactionSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicSubsidiaryItem), var_export($accountingTransactionSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get tranIsVsoeBundle value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getTranIsVsoeBundle()
    {
        return $this->tranIsVsoeBundle;
    }
    /**
     * This method is responsible for validating the values passed to the setTranIsVsoeBundle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranIsVsoeBundle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranIsVsoeBundleForArrayConstraintsFromSetTranIsVsoeBundle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicTranIsVsoeBundleItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicTranIsVsoeBundleItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicTranIsVsoeBundleItem) ? get_class($accountingTransactionSearchRowBasicTranIsVsoeBundleItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicTranIsVsoeBundleItem), var_export($accountingTransactionSearchRowBasicTranIsVsoeBundleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tranIsVsoeBundle property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tranIsVsoeBundle value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $tranIsVsoeBundle
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setTranIsVsoeBundle(array $tranIsVsoeBundle = array())
    {
        // validation for constraint: array
        if ('' !== ($tranIsVsoeBundleArrayErrorMessage = self::validateTranIsVsoeBundleForArrayConstraintsFromSetTranIsVsoeBundle($tranIsVsoeBundle))) {
            throw new \InvalidArgumentException($tranIsVsoeBundleArrayErrorMessage, __LINE__);
        }
        $this->tranIsVsoeBundle = $tranIsVsoeBundle;
        return $this;
    }
    /**
     * Add item to tranIsVsoeBundle value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToTranIsVsoeBundle(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The tranIsVsoeBundle property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tranIsVsoeBundle[] = $item;
        return $this;
    }
    /**
     * Get vsoeAllocation value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getVsoeAllocation()
    {
        return $this->vsoeAllocation;
    }
    /**
     * This method is responsible for validating the values passed to the setVsoeAllocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVsoeAllocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVsoeAllocationForArrayConstraintsFromSetVsoeAllocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingTransactionSearchRowBasicVsoeAllocationItem) {
            // validation for constraint: itemType
            if (!$accountingTransactionSearchRowBasicVsoeAllocationItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountingTransactionSearchRowBasicVsoeAllocationItem) ? get_class($accountingTransactionSearchRowBasicVsoeAllocationItem) : sprintf('%s(%s)', gettype($accountingTransactionSearchRowBasicVsoeAllocationItem), var_export($accountingTransactionSearchRowBasicVsoeAllocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vsoeAllocation property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vsoeAllocation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $vsoeAllocation
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function setVsoeAllocation(array $vsoeAllocation = array())
    {
        // validation for constraint: array
        if ('' !== ($vsoeAllocationArrayErrorMessage = self::validateVsoeAllocationForArrayConstraintsFromSetVsoeAllocation($vsoeAllocation))) {
            throw new \InvalidArgumentException($vsoeAllocationArrayErrorMessage, __LINE__);
        }
        $this->vsoeAllocation = $vsoeAllocation;
        return $this;
    }
    /**
     * Add item to vsoeAllocation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountingTransactionSearchRowBasic
     */
    public function addToVsoeAllocation(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The vsoeAllocation property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vsoeAllocation[] = $item;
        return $this;
    }
}
