<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountLocalizationsList StructType
 * @subpackage Structs
 */
class AccountLocalizationsList extends AbstractStructBase
{
    /**
     * The accountLocalizations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountLocalizations[]
     */
    public $accountLocalizations;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for AccountLocalizationsList
     * @uses AccountLocalizationsList::setAccountLocalizations()
     * @uses AccountLocalizationsList::setReplaceAll()
     * @param \StructType\AccountLocalizations[] $accountLocalizations
     * @param bool $replaceAll
     */
    public function __construct(array $accountLocalizations = array(), $replaceAll = true)
    {
        $this
            ->setAccountLocalizations($accountLocalizations)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get accountLocalizations value
     * @return \StructType\AccountLocalizations[]|null
     */
    public function getAccountLocalizations()
    {
        return $this->accountLocalizations;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountLocalizations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountLocalizations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountLocalizationsForArrayConstraintsFromSetAccountLocalizations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountLocalizationsListAccountLocalizationsItem) {
            // validation for constraint: itemType
            if (!$accountLocalizationsListAccountLocalizationsItem instanceof \StructType\AccountLocalizations) {
                $invalidValues[] = is_object($accountLocalizationsListAccountLocalizationsItem) ? get_class($accountLocalizationsListAccountLocalizationsItem) : sprintf('%s(%s)', gettype($accountLocalizationsListAccountLocalizationsItem), var_export($accountLocalizationsListAccountLocalizationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountLocalizations property can only contain items of type \StructType\AccountLocalizations, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountLocalizations value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountLocalizations[] $accountLocalizations
     * @return \StructType\AccountLocalizationsList
     */
    public function setAccountLocalizations(array $accountLocalizations = array())
    {
        // validation for constraint: array
        if ('' !== ($accountLocalizationsArrayErrorMessage = self::validateAccountLocalizationsForArrayConstraintsFromSetAccountLocalizations($accountLocalizations))) {
            throw new \InvalidArgumentException($accountLocalizationsArrayErrorMessage, __LINE__);
        }
        $this->accountLocalizations = $accountLocalizations;
        return $this;
    }
    /**
     * Add item to accountLocalizations value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountLocalizations $item
     * @return \StructType\AccountLocalizationsList
     */
    public function addToAccountLocalizations(\StructType\AccountLocalizations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountLocalizations) {
            throw new \InvalidArgumentException(sprintf('The accountLocalizations property can only contain items of type \StructType\AccountLocalizations, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountLocalizations[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\AccountLocalizationsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
