<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:Account
 * @subpackage Structs
 */
class Account extends Record
{
    /**
     * The acctType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acctType;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unit;
    /**
     * The acctNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acctNumber;
    /**
     * The acctName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acctName;
    /**
     * The legalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $legalName;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $exchangeRate;
    /**
     * The generalRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $generalRate;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The cashFlowRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cashFlowRate;
    /**
     * The billableExpensesAcct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billableExpensesAcct;
    /**
     * The deferralAcct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferralAcct;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The curDocNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $curDocNum;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The restrictToAccountingBookList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $restrictToAccountingBookList;
    /**
     * The inventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inventory;
    /**
     * The eliminate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eliminate;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The category1099misc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category1099misc;
    /**
     * The localizationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountLocalizationsList
     */
    public $localizationsList;
    /**
     * The openingBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $openingBalance;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The revalue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $revalue;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Account
     * @uses Account::setAcctType()
     * @uses Account::setUnitsType()
     * @uses Account::setUnit()
     * @uses Account::setAcctNumber()
     * @uses Account::setAcctName()
     * @uses Account::setLegalName()
     * @uses Account::setIncludeChildren()
     * @uses Account::setCurrency()
     * @uses Account::setExchangeRate()
     * @uses Account::setGeneralRate()
     * @uses Account::setParent()
     * @uses Account::setCashFlowRate()
     * @uses Account::setBillableExpensesAcct()
     * @uses Account::setDeferralAcct()
     * @uses Account::setDescription()
     * @uses Account::setCurDocNum()
     * @uses Account::setIsInactive()
     * @uses Account::setDepartment()
     * @uses Account::setClass()
     * @uses Account::setLocation()
     * @uses Account::setRestrictToAccountingBookList()
     * @uses Account::setInventory()
     * @uses Account::setEliminate()
     * @uses Account::setSubsidiaryList()
     * @uses Account::setCategory1099misc()
     * @uses Account::setLocalizationsList()
     * @uses Account::setOpeningBalance()
     * @uses Account::setTranDate()
     * @uses Account::setRevalue()
     * @uses Account::setCustomFieldList()
     * @uses Account::setInternalId()
     * @uses Account::setExternalId()
     * @param string $acctType
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $unit
     * @param string $acctNumber
     * @param string $acctName
     * @param string $legalName
     * @param bool $includeChildren
     * @param \StructType\RecordRef $currency
     * @param string $exchangeRate
     * @param string $generalRate
     * @param \StructType\RecordRef $parent
     * @param string $cashFlowRate
     * @param \StructType\RecordRef $billableExpensesAcct
     * @param \StructType\RecordRef $deferralAcct
     * @param string $description
     * @param int $curDocNum
     * @param bool $isInactive
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRefList $restrictToAccountingBookList
     * @param bool $inventory
     * @param bool $eliminate
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\RecordRef $category1099misc
     * @param \StructType\AccountLocalizationsList $localizationsList
     * @param float $openingBalance
     * @param string $tranDate
     * @param bool $revalue
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($acctType = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $unit = null, $acctNumber = null, $acctName = null, $legalName = null, $includeChildren = null, \StructType\RecordRef $currency = null, $exchangeRate = null, $generalRate = null, \StructType\RecordRef $parent = null, $cashFlowRate = null, \StructType\RecordRef $billableExpensesAcct = null, \StructType\RecordRef $deferralAcct = null, $description = null, $curDocNum = null, $isInactive = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRefList $restrictToAccountingBookList = null, $inventory = null, $eliminate = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\RecordRef $category1099misc = null, \StructType\AccountLocalizationsList $localizationsList = null, $openingBalance = null, $tranDate = null, $revalue = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setAcctType($acctType)
            ->setUnitsType($unitsType)
            ->setUnit($unit)
            ->setAcctNumber($acctNumber)
            ->setAcctName($acctName)
            ->setLegalName($legalName)
            ->setIncludeChildren($includeChildren)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setGeneralRate($generalRate)
            ->setParent($parent)
            ->setCashFlowRate($cashFlowRate)
            ->setBillableExpensesAcct($billableExpensesAcct)
            ->setDeferralAcct($deferralAcct)
            ->setDescription($description)
            ->setCurDocNum($curDocNum)
            ->setIsInactive($isInactive)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setRestrictToAccountingBookList($restrictToAccountingBookList)
            ->setInventory($inventory)
            ->setEliminate($eliminate)
            ->setSubsidiaryList($subsidiaryList)
            ->setCategory1099misc($category1099misc)
            ->setLocalizationsList($localizationsList)
            ->setOpeningBalance($openingBalance)
            ->setTranDate($tranDate)
            ->setRevalue($revalue)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get acctType value
     * @return string|null
     */
    public function getAcctType()
    {
        return $this->acctType;
    }
    /**
     * Set acctType value
     * @uses \EnumType\AccountType::valueIsValid()
     * @uses \EnumType\AccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acctType
     * @return \StructType\Account
     */
    public function setAcctType($acctType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountType::valueIsValid($acctType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountType', is_array($acctType) ? implode(', ', $acctType) : var_export($acctType, true), implode(', ', \EnumType\AccountType::getValidValues())), __LINE__);
        }
        $this->acctType = $acctType;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\Account
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\RecordRef|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param \StructType\RecordRef $unit
     * @return \StructType\Account
     */
    public function setUnit(\StructType\RecordRef $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get acctNumber value
     * @return string|null
     */
    public function getAcctNumber()
    {
        return $this->acctNumber;
    }
    /**
     * Set acctNumber value
     * @param string $acctNumber
     * @return \StructType\Account
     */
    public function setAcctNumber($acctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($acctNumber) && !is_string($acctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctNumber, true), gettype($acctNumber)), __LINE__);
        }
        $this->acctNumber = $acctNumber;
        return $this;
    }
    /**
     * Get acctName value
     * @return string|null
     */
    public function getAcctName()
    {
        return $this->acctName;
    }
    /**
     * Set acctName value
     * @param string $acctName
     * @return \StructType\Account
     */
    public function setAcctName($acctName = null)
    {
        // validation for constraint: string
        if (!is_null($acctName) && !is_string($acctName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctName, true), gettype($acctName)), __LINE__);
        }
        $this->acctName = $acctName;
        return $this;
    }
    /**
     * Get legalName value
     * @return string|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * Set legalName value
     * @param string $legalName
     * @return \StructType\Account
     */
    public function setLegalName($legalName = null)
    {
        // validation for constraint: string
        if (!is_null($legalName) && !is_string($legalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalName, true), gettype($legalName)), __LINE__);
        }
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\Account
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Account
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return string|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param string $exchangeRate
     * @return \StructType\Account
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRate) && !is_string($exchangeRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get generalRate value
     * @return string|null
     */
    public function getGeneralRate()
    {
        return $this->generalRate;
    }
    /**
     * Set generalRate value
     * @uses \EnumType\ConsolidatedRate::valueIsValid()
     * @uses \EnumType\ConsolidatedRate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generalRate
     * @return \StructType\Account
     */
    public function setGeneralRate($generalRate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConsolidatedRate::valueIsValid($generalRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConsolidatedRate', is_array($generalRate) ? implode(', ', $generalRate) : var_export($generalRate, true), implode(', ', \EnumType\ConsolidatedRate::getValidValues())), __LINE__);
        }
        $this->generalRate = $generalRate;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Account
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get cashFlowRate value
     * @return string|null
     */
    public function getCashFlowRate()
    {
        return $this->cashFlowRate;
    }
    /**
     * Set cashFlowRate value
     * @uses \EnumType\ConsolidatedRate::valueIsValid()
     * @uses \EnumType\ConsolidatedRate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cashFlowRate
     * @return \StructType\Account
     */
    public function setCashFlowRate($cashFlowRate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConsolidatedRate::valueIsValid($cashFlowRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConsolidatedRate', is_array($cashFlowRate) ? implode(', ', $cashFlowRate) : var_export($cashFlowRate, true), implode(', ', \EnumType\ConsolidatedRate::getValidValues())), __LINE__);
        }
        $this->cashFlowRate = $cashFlowRate;
        return $this;
    }
    /**
     * Get billableExpensesAcct value
     * @return \StructType\RecordRef|null
     */
    public function getBillableExpensesAcct()
    {
        return $this->billableExpensesAcct;
    }
    /**
     * Set billableExpensesAcct value
     * @param \StructType\RecordRef $billableExpensesAcct
     * @return \StructType\Account
     */
    public function setBillableExpensesAcct(\StructType\RecordRef $billableExpensesAcct = null)
    {
        $this->billableExpensesAcct = $billableExpensesAcct;
        return $this;
    }
    /**
     * Get deferralAcct value
     * @return \StructType\RecordRef|null
     */
    public function getDeferralAcct()
    {
        return $this->deferralAcct;
    }
    /**
     * Set deferralAcct value
     * @param \StructType\RecordRef $deferralAcct
     * @return \StructType\Account
     */
    public function setDeferralAcct(\StructType\RecordRef $deferralAcct = null)
    {
        $this->deferralAcct = $deferralAcct;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Account
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get curDocNum value
     * @return int|null
     */
    public function getCurDocNum()
    {
        return $this->curDocNum;
    }
    /**
     * Set curDocNum value
     * @param int $curDocNum
     * @return \StructType\Account
     */
    public function setCurDocNum($curDocNum = null)
    {
        // validation for constraint: int
        if (!is_null($curDocNum) && !(is_int($curDocNum) || ctype_digit($curDocNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($curDocNum, true), gettype($curDocNum)), __LINE__);
        }
        $this->curDocNum = $curDocNum;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Account
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Account
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Account
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Account
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get restrictToAccountingBookList value
     * @return \StructType\RecordRefList|null
     */
    public function getRestrictToAccountingBookList()
    {
        return $this->restrictToAccountingBookList;
    }
    /**
     * Set restrictToAccountingBookList value
     * @param \StructType\RecordRefList $restrictToAccountingBookList
     * @return \StructType\Account
     */
    public function setRestrictToAccountingBookList(\StructType\RecordRefList $restrictToAccountingBookList = null)
    {
        $this->restrictToAccountingBookList = $restrictToAccountingBookList;
        return $this;
    }
    /**
     * Get inventory value
     * @return bool|null
     */
    public function getInventory()
    {
        return $this->inventory;
    }
    /**
     * Set inventory value
     * @param bool $inventory
     * @return \StructType\Account
     */
    public function setInventory($inventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($inventory) && !is_bool($inventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inventory, true), gettype($inventory)), __LINE__);
        }
        $this->inventory = $inventory;
        return $this;
    }
    /**
     * Get eliminate value
     * @return bool|null
     */
    public function getEliminate()
    {
        return $this->eliminate;
    }
    /**
     * Set eliminate value
     * @param bool $eliminate
     * @return \StructType\Account
     */
    public function setEliminate($eliminate = null)
    {
        // validation for constraint: boolean
        if (!is_null($eliminate) && !is_bool($eliminate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eliminate, true), gettype($eliminate)), __LINE__);
        }
        $this->eliminate = $eliminate;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\Account
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get category1099misc value
     * @return \StructType\RecordRef|null
     */
    public function getCategory1099misc()
    {
        return $this->category1099misc;
    }
    /**
     * Set category1099misc value
     * @param \StructType\RecordRef $category1099misc
     * @return \StructType\Account
     */
    public function setCategory1099misc(\StructType\RecordRef $category1099misc = null)
    {
        $this->category1099misc = $category1099misc;
        return $this;
    }
    /**
     * Get localizationsList value
     * @return \StructType\AccountLocalizationsList|null
     */
    public function getLocalizationsList()
    {
        return $this->localizationsList;
    }
    /**
     * Set localizationsList value
     * @param \StructType\AccountLocalizationsList $localizationsList
     * @return \StructType\Account
     */
    public function setLocalizationsList(\StructType\AccountLocalizationsList $localizationsList = null)
    {
        $this->localizationsList = $localizationsList;
        return $this;
    }
    /**
     * Get openingBalance value
     * @return float|null
     */
    public function getOpeningBalance()
    {
        return $this->openingBalance;
    }
    /**
     * Set openingBalance value
     * @param float $openingBalance
     * @return \StructType\Account
     */
    public function setOpeningBalance($openingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($openingBalance) && !(is_float($openingBalance) || is_numeric($openingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openingBalance, true), gettype($openingBalance)), __LINE__);
        }
        $this->openingBalance = $openingBalance;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\Account
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get revalue value
     * @return bool|null
     */
    public function getRevalue()
    {
        return $this->revalue;
    }
    /**
     * Set revalue value
     * @param bool $revalue
     * @return \StructType\Account
     */
    public function setRevalue($revalue = null)
    {
        // validation for constraint: boolean
        if (!is_null($revalue) && !is_bool($revalue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($revalue, true), gettype($revalue)), __LINE__);
        }
        $this->revalue = $revalue;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Account
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Account
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Account
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
