<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Async ServiceType
 * @subpackage Services
 */
class Async extends AbstractSoapClientBase
{
    /**
     * Sets the Passport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Passport $passport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPassport(\StructType\Passport $passport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'passport', $passport, $mustUnderstand, $actor);
    }
    /**
     * Sets the TokenPassport SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenPassport $tokenPassport
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenPassport(\StructType\TokenPassport $tokenPassport, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'tokenPassport', $tokenPassport, $mustUnderstand, $actor);
    }
    /**
     * Sets the ApplicationInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApplicationInfo $applicationInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationInfo(\StructType\ApplicationInfo $applicationInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'applicationInfo', $applicationInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the PartnerInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartnerInfo $partnerInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPartnerInfo(\StructType\PartnerInfo $partnerInfo, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'partnerInfo', $partnerInfo, $mustUnderstand, $actor);
    }
    /**
     * Sets the Preferences SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Preferences $preferences
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPreferences(\StructType\Preferences $preferences, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'preferences', $preferences, $mustUnderstand, $actor);
    }
    /**
     * Sets the SearchPreferences SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SearchPreferences $searchPreferences
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSearchPreferences(\StructType\SearchPreferences $searchPreferences, $nameSpace = 'urn:messages_2020_1.platform.webservices.netsuite.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'searchPreferences', $searchPreferences, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named asyncAddList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncAddListRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncAddList(\StructType\AsyncAddListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncAddList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named asyncUpdateList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncUpdateListRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncUpdateList(\StructType\AsyncUpdateListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncUpdateList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named asyncUpsertList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncUpsertListRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncUpsertList(\StructType\AsyncUpsertListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncUpsertList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named asyncDeleteList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncDeleteListRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncDeleteList(\StructType\AsyncDeleteListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncDeleteList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named asyncGetList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncGetListRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncGetList(\StructType\AsyncGetListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncGetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named asyncInitializeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, preferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\Preferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncInitializeListRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncInitializeList(\StructType\AsyncInitializeListRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncInitializeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named asyncSearch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: passport, tokenPassport, applicationInfo, partnerInfo, searchPreferences
     * - SOAPHeaderNamespaces: urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com, urn:messages_2020_1.platform.webservices.netsuite.com
     * - SOAPHeaderTypes: \StructType\Passport, \StructType\TokenPassport, \StructType\ApplicationInfo, \StructType\PartnerInfo, \StructType\SearchPreferences
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AsyncSearchRequest $parameters
     * @return \StructType\AsyncStatusResponse|bool
     */
    public function asyncSearch(\StructType\AsyncSearchRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->asyncSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AsyncStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
