<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionStatus EnumType
 * @subpackage Enumerations
 */
class TransactionStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_billCancelled'
     * @return string '_billCancelled'
     */
    const VALUE_BILL_CANCELLED = '_billCancelled';
    /**
     * Constant for value '_billOpen'
     * @return string '_billOpen'
     */
    const VALUE_BILL_OPEN = '_billOpen';
    /**
     * Constant for value '_billPaidInFull'
     * @return string '_billPaidInFull'
     */
    const VALUE_BILL_PAID_IN_FULL = '_billPaidInFull';
    /**
     * Constant for value '_billPaymentApproved'
     * @return string '_billPaymentApproved'
     */
    const VALUE_BILL_PAYMENT_APPROVED = '_billPaymentApproved';
    /**
     * Constant for value '_billPaymentConfirmed'
     * @return string '_billPaymentConfirmed'
     */
    const VALUE_BILL_PAYMENT_CONFIRMED = '_billPaymentConfirmed';
    /**
     * Constant for value '_billPaymentDeclined'
     * @return string '_billPaymentDeclined'
     */
    const VALUE_BILL_PAYMENT_DECLINED = '_billPaymentDeclined';
    /**
     * Constant for value '_billPaymentInTransit'
     * @return string '_billPaymentInTransit'
     */
    const VALUE_BILL_PAYMENT_IN_TRANSIT = '_billPaymentInTransit';
    /**
     * Constant for value '_billPaymentOnlineBillPayPendingAccountingApproval'
     * @return string '_billPaymentOnlineBillPayPendingAccountingApproval'
     */
    const VALUE_BILL_PAYMENT_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL = '_billPaymentOnlineBillPayPendingAccountingApproval';
    /**
     * Constant for value '_billPaymentPendingApproval'
     * @return string '_billPaymentPendingApproval'
     */
    const VALUE_BILL_PAYMENT_PENDING_APPROVAL = '_billPaymentPendingApproval';
    /**
     * Constant for value '_billPaymentRejected'
     * @return string '_billPaymentRejected'
     */
    const VALUE_BILL_PAYMENT_REJECTED = '_billPaymentRejected';
    /**
     * Constant for value '_billPaymentVoided'
     * @return string '_billPaymentVoided'
     */
    const VALUE_BILL_PAYMENT_VOIDED = '_billPaymentVoided';
    /**
     * Constant for value '_billPendingApproval'
     * @return string '_billPendingApproval'
     */
    const VALUE_BILL_PENDING_APPROVAL = '_billPendingApproval';
    /**
     * Constant for value '_billRejected'
     * @return string '_billRejected'
     */
    const VALUE_BILL_REJECTED = '_billRejected';
    /**
     * Constant for value '_cashSaleDeposited'
     * @return string '_cashSaleDeposited'
     */
    const VALUE_CASH_SALE_DEPOSITED = '_cashSaleDeposited';
    /**
     * Constant for value '_cashSaleNotDeposited'
     * @return string '_cashSaleNotDeposited'
     */
    const VALUE_CASH_SALE_NOT_DEPOSITED = '_cashSaleNotDeposited';
    /**
     * Constant for value '_cashSaleUnapprovedPayment'
     * @return string '_cashSaleUnapprovedPayment'
     */
    const VALUE_CASH_SALE_UNAPPROVED_PAYMENT = '_cashSaleUnapprovedPayment';
    /**
     * Constant for value '_checkOnlineBillPayPendingAccountingApproval'
     * @return string '_checkOnlineBillPayPendingAccountingApproval'
     */
    const VALUE_CHECK_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL = '_checkOnlineBillPayPendingAccountingApproval';
    /**
     * Constant for value '_checkVoided'
     * @return string '_checkVoided'
     */
    const VALUE_CHECK_VOIDED = '_checkVoided';
    /**
     * Constant for value '_commissionOverpaid'
     * @return string '_commissionOverpaid'
     */
    const VALUE_COMMISSION_OVERPAID = '_commissionOverpaid';
    /**
     * Constant for value '_commissionPaidInFull'
     * @return string '_commissionPaidInFull'
     */
    const VALUE_COMMISSION_PAID_IN_FULL = '_commissionPaidInFull';
    /**
     * Constant for value '_commissionPendingAccountingApproval'
     * @return string '_commissionPendingAccountingApproval'
     */
    const VALUE_COMMISSION_PENDING_ACCOUNTING_APPROVAL = '_commissionPendingAccountingApproval';
    /**
     * Constant for value '_commissionPendingPayment'
     * @return string '_commissionPendingPayment'
     */
    const VALUE_COMMISSION_PENDING_PAYMENT = '_commissionPendingPayment';
    /**
     * Constant for value '_commissionRejectedByAccounting'
     * @return string '_commissionRejectedByAccounting'
     */
    const VALUE_COMMISSION_REJECTED_BY_ACCOUNTING = '_commissionRejectedByAccounting';
    /**
     * Constant for value '_creditMemoFullyApplied'
     * @return string '_creditMemoFullyApplied'
     */
    const VALUE_CREDIT_MEMO_FULLY_APPLIED = '_creditMemoFullyApplied';
    /**
     * Constant for value '_creditMemoOpen'
     * @return string '_creditMemoOpen'
     */
    const VALUE_CREDIT_MEMO_OPEN = '_creditMemoOpen';
    /**
     * Constant for value '_creditMemoVoided'
     * @return string '_creditMemoVoided'
     */
    const VALUE_CREDIT_MEMO_VOIDED = '_creditMemoVoided';
    /**
     * Constant for value '_customerDepositCancelled'
     * @return string '_customerDepositCancelled'
     */
    const VALUE_CUSTOMER_DEPOSIT_CANCELLED = '_customerDepositCancelled';
    /**
     * Constant for value '_customerDepositDeposited'
     * @return string '_customerDepositDeposited'
     */
    const VALUE_CUSTOMER_DEPOSIT_DEPOSITED = '_customerDepositDeposited';
    /**
     * Constant for value '_customerDepositFullyApplied'
     * @return string '_customerDepositFullyApplied'
     */
    const VALUE_CUSTOMER_DEPOSIT_FULLY_APPLIED = '_customerDepositFullyApplied';
    /**
     * Constant for value '_customerDepositNotDeposited'
     * @return string '_customerDepositNotDeposited'
     */
    const VALUE_CUSTOMER_DEPOSIT_NOT_DEPOSITED = '_customerDepositNotDeposited';
    /**
     * Constant for value '_customerDepositUnapprovedPayment'
     * @return string '_customerDepositUnapprovedPayment'
     */
    const VALUE_CUSTOMER_DEPOSIT_UNAPPROVED_PAYMENT = '_customerDepositUnapprovedPayment';
    /**
     * Constant for value '_customerRefundCancelled'
     * @return string '_customerRefundCancelled'
     */
    const VALUE_CUSTOMER_REFUND_CANCELLED = '_customerRefundCancelled';
    /**
     * Constant for value '_customerRefundVoided'
     * @return string '_customerRefundVoided'
     */
    const VALUE_CUSTOMER_REFUND_VOIDED = '_customerRefundVoided';
    /**
     * Constant for value '_estimateClosed'
     * @return string '_estimateClosed'
     */
    const VALUE_ESTIMATE_CLOSED = '_estimateClosed';
    /**
     * Constant for value '_estimateExpired'
     * @return string '_estimateExpired'
     */
    const VALUE_ESTIMATE_EXPIRED = '_estimateExpired';
    /**
     * Constant for value '_estimateOpen'
     * @return string '_estimateOpen'
     */
    const VALUE_ESTIMATE_OPEN = '_estimateOpen';
    /**
     * Constant for value '_estimateProcessed'
     * @return string '_estimateProcessed'
     */
    const VALUE_ESTIMATE_PROCESSED = '_estimateProcessed';
    /**
     * Constant for value '_estimateVoided'
     * @return string '_estimateVoided'
     */
    const VALUE_ESTIMATE_VOIDED = '_estimateVoided';
    /**
     * Constant for value '_expenseReportApprovedByAccounting'
     * @return string '_expenseReportApprovedByAccounting'
     */
    const VALUE_EXPENSE_REPORT_APPROVED_BY_ACCOUNTING = '_expenseReportApprovedByAccounting';
    /**
     * Constant for value '_expenseReportApprovedOverriddenByAccounting'
     * @return string '_expenseReportApprovedOverriddenByAccounting'
     */
    const VALUE_EXPENSE_REPORT_APPROVED_OVERRIDDEN_BY_ACCOUNTING = '_expenseReportApprovedOverriddenByAccounting';
    /**
     * Constant for value '_expenseReportInProgress'
     * @return string '_expenseReportInProgress'
     */
    const VALUE_EXPENSE_REPORT_IN_PROGRESS = '_expenseReportInProgress';
    /**
     * Constant for value '_expenseReportPaidInFull'
     * @return string '_expenseReportPaidInFull'
     */
    const VALUE_EXPENSE_REPORT_PAID_IN_FULL = '_expenseReportPaidInFull';
    /**
     * Constant for value '_expenseReportPaymentInTransit'
     * @return string '_expenseReportPaymentInTransit'
     */
    const VALUE_EXPENSE_REPORT_PAYMENT_IN_TRANSIT = '_expenseReportPaymentInTransit';
    /**
     * Constant for value '_expenseReportPendingAccountingApproval'
     * @return string '_expenseReportPendingAccountingApproval'
     */
    const VALUE_EXPENSE_REPORT_PENDING_ACCOUNTING_APPROVAL = '_expenseReportPendingAccountingApproval';
    /**
     * Constant for value '_expenseReportPendingSupervisorApproval'
     * @return string '_expenseReportPendingSupervisorApproval'
     */
    const VALUE_EXPENSE_REPORT_PENDING_SUPERVISOR_APPROVAL = '_expenseReportPendingSupervisorApproval';
    /**
     * Constant for value '_expenseReportRejectedByAccounting'
     * @return string '_expenseReportRejectedByAccounting'
     */
    const VALUE_EXPENSE_REPORT_REJECTED_BY_ACCOUNTING = '_expenseReportRejectedByAccounting';
    /**
     * Constant for value '_expenseReportRejectedBySupervisor'
     * @return string '_expenseReportRejectedBySupervisor'
     */
    const VALUE_EXPENSE_REPORT_REJECTED_BY_SUPERVISOR = '_expenseReportRejectedBySupervisor';
    /**
     * Constant for value '_expenseReportRejectedOverriddenByAccounting'
     * @return string '_expenseReportRejectedOverriddenByAccounting'
     */
    const VALUE_EXPENSE_REPORT_REJECTED_OVERRIDDEN_BY_ACCOUNTING = '_expenseReportRejectedOverriddenByAccounting';
    /**
     * Constant for value '_expenseReportVoided'
     * @return string '_expenseReportVoided'
     */
    const VALUE_EXPENSE_REPORT_VOIDED = '_expenseReportVoided';
    /**
     * Constant for value '_invoiceOpen'
     * @return string '_invoiceOpen'
     */
    const VALUE_INVOICE_OPEN = '_invoiceOpen';
    /**
     * Constant for value '_invoicePaidInFull'
     * @return string '_invoicePaidInFull'
     */
    const VALUE_INVOICE_PAID_IN_FULL = '_invoicePaidInFull';
    /**
     * Constant for value '_invoicePendingApproval'
     * @return string '_invoicePendingApproval'
     */
    const VALUE_INVOICE_PENDING_APPROVAL = '_invoicePendingApproval';
    /**
     * Constant for value '_invoiceRejected'
     * @return string '_invoiceRejected'
     */
    const VALUE_INVOICE_REJECTED = '_invoiceRejected';
    /**
     * Constant for value '_invoiceVoided'
     * @return string '_invoiceVoided'
     */
    const VALUE_INVOICE_VOIDED = '_invoiceVoided';
    /**
     * Constant for value '_itemFulfillmentPacked'
     * @return string '_itemFulfillmentPacked'
     */
    const VALUE_ITEM_FULFILLMENT_PACKED = '_itemFulfillmentPacked';
    /**
     * Constant for value '_itemFulfillmentPicked'
     * @return string '_itemFulfillmentPicked'
     */
    const VALUE_ITEM_FULFILLMENT_PICKED = '_itemFulfillmentPicked';
    /**
     * Constant for value '_itemFulfillmentShipped'
     * @return string '_itemFulfillmentShipped'
     */
    const VALUE_ITEM_FULFILLMENT_SHIPPED = '_itemFulfillmentShipped';
    /**
     * Constant for value '_journalApprovedForPosting'
     * @return string '_journalApprovedForPosting'
     */
    const VALUE_JOURNAL_APPROVED_FOR_POSTING = '_journalApprovedForPosting';
    /**
     * Constant for value '_journalPendingApproval'
     * @return string '_journalPendingApproval'
     */
    const VALUE_JOURNAL_PENDING_APPROVAL = '_journalPendingApproval';
    /**
     * Constant for value '_journalRejected'
     * @return string '_journalRejected'
     */
    const VALUE_JOURNAL_REJECTED = '_journalRejected';
    /**
     * Constant for value '_opportunityClosedLost'
     * @return string '_opportunityClosedLost'
     */
    const VALUE_OPPORTUNITY_CLOSED_LOST = '_opportunityClosedLost';
    /**
     * Constant for value '_opportunityClosedWon'
     * @return string '_opportunityClosedWon'
     */
    const VALUE_OPPORTUNITY_CLOSED_WON = '_opportunityClosedWon';
    /**
     * Constant for value '_opportunityInProgress'
     * @return string '_opportunityInProgress'
     */
    const VALUE_OPPORTUNITY_IN_PROGRESS = '_opportunityInProgress';
    /**
     * Constant for value '_opportunityIssuedEstimate'
     * @return string '_opportunityIssuedEstimate'
     */
    const VALUE_OPPORTUNITY_ISSUED_ESTIMATE = '_opportunityIssuedEstimate';
    /**
     * Constant for value '_paycheckCommitted'
     * @return string '_paycheckCommitted'
     */
    const VALUE_PAYCHECK_COMMITTED = '_paycheckCommitted';
    /**
     * Constant for value '_paycheckCreated'
     * @return string '_paycheckCreated'
     */
    const VALUE_PAYCHECK_CREATED = '_paycheckCreated';
    /**
     * Constant for value '_paycheckError'
     * @return string '_paycheckError'
     */
    const VALUE_PAYCHECK_ERROR = '_paycheckError';
    /**
     * Constant for value '_paycheckPendingCommitment'
     * @return string '_paycheckPendingCommitment'
     */
    const VALUE_PAYCHECK_PENDING_COMMITMENT = '_paycheckPendingCommitment';
    /**
     * Constant for value '_paycheckPendingTaxCalculation'
     * @return string '_paycheckPendingTaxCalculation'
     */
    const VALUE_PAYCHECK_PENDING_TAX_CALCULATION = '_paycheckPendingTaxCalculation';
    /**
     * Constant for value '_paycheckPreview'
     * @return string '_paycheckPreview'
     */
    const VALUE_PAYCHECK_PREVIEW = '_paycheckPreview';
    /**
     * Constant for value '_paycheckReversed'
     * @return string '_paycheckReversed'
     */
    const VALUE_PAYCHECK_REVERSED = '_paycheckReversed';
    /**
     * Constant for value '_paymentCancelled'
     * @return string '_paymentCancelled'
     */
    const VALUE_PAYMENT_CANCELLED = '_paymentCancelled';
    /**
     * Constant for value '_paymentDeposited'
     * @return string '_paymentDeposited'
     */
    const VALUE_PAYMENT_DEPOSITED = '_paymentDeposited';
    /**
     * Constant for value '_paymentNotDeposited'
     * @return string '_paymentNotDeposited'
     */
    const VALUE_PAYMENT_NOT_DEPOSITED = '_paymentNotDeposited';
    /**
     * Constant for value '_paymentUnapprovedPayment'
     * @return string '_paymentUnapprovedPayment'
     */
    const VALUE_PAYMENT_UNAPPROVED_PAYMENT = '_paymentUnapprovedPayment';
    /**
     * Constant for value '_payrollLiabilityCheckVoided'
     * @return string '_payrollLiabilityCheckVoided'
     */
    const VALUE_PAYROLL_LIABILITY_CHECK_VOIDED = '_payrollLiabilityCheckVoided';
    /**
     * Constant for value '_periodEndJournalApprovedForPosting'
     * @return string '_periodEndJournalApprovedForPosting'
     */
    const VALUE_PERIOD_END_JOURNAL_APPROVED_FOR_POSTING = '_periodEndJournalApprovedForPosting';
    /**
     * Constant for value '_periodEndJournalPendingApproval'
     * @return string '_periodEndJournalPendingApproval'
     */
    const VALUE_PERIOD_END_JOURNAL_PENDING_APPROVAL = '_periodEndJournalPendingApproval';
    /**
     * Constant for value '_periodEndJournalRejected'
     * @return string '_periodEndJournalRejected'
     */
    const VALUE_PERIOD_END_JOURNAL_REJECTED = '_periodEndJournalRejected';
    /**
     * Constant for value '_purchaseOrderClosed'
     * @return string '_purchaseOrderClosed'
     */
    const VALUE_PURCHASE_ORDER_CLOSED = '_purchaseOrderClosed';
    /**
     * Constant for value '_purchaseOrderFullyBilled'
     * @return string '_purchaseOrderFullyBilled'
     */
    const VALUE_PURCHASE_ORDER_FULLY_BILLED = '_purchaseOrderFullyBilled';
    /**
     * Constant for value '_purchaseOrderPartiallyReceived'
     * @return string '_purchaseOrderPartiallyReceived'
     */
    const VALUE_PURCHASE_ORDER_PARTIALLY_RECEIVED = '_purchaseOrderPartiallyReceived';
    /**
     * Constant for value '_purchaseOrderPendingBill'
     * @return string '_purchaseOrderPendingBill'
     */
    const VALUE_PURCHASE_ORDER_PENDING_BILL = '_purchaseOrderPendingBill';
    /**
     * Constant for value '_purchaseOrderPendingBillingPartiallyReceived'
     * @return string '_purchaseOrderPendingBillingPartiallyReceived'
     */
    const VALUE_PURCHASE_ORDER_PENDING_BILLING_PARTIALLY_RECEIVED = '_purchaseOrderPendingBillingPartiallyReceived';
    /**
     * Constant for value '_purchaseOrderPendingReceipt'
     * @return string '_purchaseOrderPendingReceipt'
     */
    const VALUE_PURCHASE_ORDER_PENDING_RECEIPT = '_purchaseOrderPendingReceipt';
    /**
     * Constant for value '_purchaseOrderPendingSupervisorApproval'
     * @return string '_purchaseOrderPendingSupervisorApproval'
     */
    const VALUE_PURCHASE_ORDER_PENDING_SUPERVISOR_APPROVAL = '_purchaseOrderPendingSupervisorApproval';
    /**
     * Constant for value '_purchaseOrderPlanned'
     * @return string '_purchaseOrderPlanned'
     */
    const VALUE_PURCHASE_ORDER_PLANNED = '_purchaseOrderPlanned';
    /**
     * Constant for value '_purchaseOrderRejectedBySupervisor'
     * @return string '_purchaseOrderRejectedBySupervisor'
     */
    const VALUE_PURCHASE_ORDER_REJECTED_BY_SUPERVISOR = '_purchaseOrderRejectedBySupervisor';
    /**
     * Constant for value '_requisitionCancelled'
     * @return string '_requisitionCancelled'
     */
    const VALUE_REQUISITION_CANCELLED = '_requisitionCancelled';
    /**
     * Constant for value '_requisitionClosed'
     * @return string '_requisitionClosed'
     */
    const VALUE_REQUISITION_CLOSED = '_requisitionClosed';
    /**
     * Constant for value '_requisitionFullyOrdered'
     * @return string '_requisitionFullyOrdered'
     */
    const VALUE_REQUISITION_FULLY_ORDERED = '_requisitionFullyOrdered';
    /**
     * Constant for value '_requisitionFullyReceived'
     * @return string '_requisitionFullyReceived'
     */
    const VALUE_REQUISITION_FULLY_RECEIVED = '_requisitionFullyReceived';
    /**
     * Constant for value '_requisitionPartiallyOrdered'
     * @return string '_requisitionPartiallyOrdered'
     */
    const VALUE_REQUISITION_PARTIALLY_ORDERED = '_requisitionPartiallyOrdered';
    /**
     * Constant for value '_requisitionPartiallyReceived'
     * @return string '_requisitionPartiallyReceived'
     */
    const VALUE_REQUISITION_PARTIALLY_RECEIVED = '_requisitionPartiallyReceived';
    /**
     * Constant for value '_requisitionPendingApproval'
     * @return string '_requisitionPendingApproval'
     */
    const VALUE_REQUISITION_PENDING_APPROVAL = '_requisitionPendingApproval';
    /**
     * Constant for value '_requisitionPendingOrder'
     * @return string '_requisitionPendingOrder'
     */
    const VALUE_REQUISITION_PENDING_ORDER = '_requisitionPendingOrder';
    /**
     * Constant for value '_requisitionRejected'
     * @return string '_requisitionRejected'
     */
    const VALUE_REQUISITION_REJECTED = '_requisitionRejected';
    /**
     * Constant for value '_returnAuthorizationCancelled'
     * @return string '_returnAuthorizationCancelled'
     */
    const VALUE_RETURN_AUTHORIZATION_CANCELLED = '_returnAuthorizationCancelled';
    /**
     * Constant for value '_returnAuthorizationClosed'
     * @return string '_returnAuthorizationClosed'
     */
    const VALUE_RETURN_AUTHORIZATION_CLOSED = '_returnAuthorizationClosed';
    /**
     * Constant for value '_returnAuthorizationPartiallyReceived'
     * @return string '_returnAuthorizationPartiallyReceived'
     */
    const VALUE_RETURN_AUTHORIZATION_PARTIALLY_RECEIVED = '_returnAuthorizationPartiallyReceived';
    /**
     * Constant for value '_returnAuthorizationPendingApproval'
     * @return string '_returnAuthorizationPendingApproval'
     */
    const VALUE_RETURN_AUTHORIZATION_PENDING_APPROVAL = '_returnAuthorizationPendingApproval';
    /**
     * Constant for value '_returnAuthorizationPendingReceipt'
     * @return string '_returnAuthorizationPendingReceipt'
     */
    const VALUE_RETURN_AUTHORIZATION_PENDING_RECEIPT = '_returnAuthorizationPendingReceipt';
    /**
     * Constant for value '_returnAuthorizationPendingRefund'
     * @return string '_returnAuthorizationPendingRefund'
     */
    const VALUE_RETURN_AUTHORIZATION_PENDING_REFUND = '_returnAuthorizationPendingRefund';
    /**
     * Constant for value '_returnAuthorizationPendingRefundPartiallyReceived'
     * @return string '_returnAuthorizationPendingRefundPartiallyReceived'
     */
    const VALUE_RETURN_AUTHORIZATION_PENDING_REFUND_PARTIALLY_RECEIVED = '_returnAuthorizationPendingRefundPartiallyReceived';
    /**
     * Constant for value '_returnAuthorizationRefunded'
     * @return string '_returnAuthorizationRefunded'
     */
    const VALUE_RETURN_AUTHORIZATION_REFUNDED = '_returnAuthorizationRefunded';
    /**
     * Constant for value '_salesOrderBilled'
     * @return string '_salesOrderBilled'
     */
    const VALUE_SALES_ORDER_BILLED = '_salesOrderBilled';
    /**
     * Constant for value '_salesOrderCancelled'
     * @return string '_salesOrderCancelled'
     */
    const VALUE_SALES_ORDER_CANCELLED = '_salesOrderCancelled';
    /**
     * Constant for value '_salesOrderClosed'
     * @return string '_salesOrderClosed'
     */
    const VALUE_SALES_ORDER_CLOSED = '_salesOrderClosed';
    /**
     * Constant for value '_salesOrderPartiallyFulfilled'
     * @return string '_salesOrderPartiallyFulfilled'
     */
    const VALUE_SALES_ORDER_PARTIALLY_FULFILLED = '_salesOrderPartiallyFulfilled';
    /**
     * Constant for value '_salesOrderPendingApproval'
     * @return string '_salesOrderPendingApproval'
     */
    const VALUE_SALES_ORDER_PENDING_APPROVAL = '_salesOrderPendingApproval';
    /**
     * Constant for value '_salesOrderPendingBilling'
     * @return string '_salesOrderPendingBilling'
     */
    const VALUE_SALES_ORDER_PENDING_BILLING = '_salesOrderPendingBilling';
    /**
     * Constant for value '_salesOrderPendingBillingPartiallyFulfilled'
     * @return string '_salesOrderPendingBillingPartiallyFulfilled'
     */
    const VALUE_SALES_ORDER_PENDING_BILLING_PARTIALLY_FULFILLED = '_salesOrderPendingBillingPartiallyFulfilled';
    /**
     * Constant for value '_salesOrderPendingFulfillment'
     * @return string '_salesOrderPendingFulfillment'
     */
    const VALUE_SALES_ORDER_PENDING_FULFILLMENT = '_salesOrderPendingFulfillment';
    /**
     * Constant for value '_salesTaxPaymentOnlineBillPayPendingAccountingApproval'
     * @return string '_salesTaxPaymentOnlineBillPayPendingAccountingApproval'
     */
    const VALUE_SALES_TAX_PAYMENT_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL = '_salesTaxPaymentOnlineBillPayPendingAccountingApproval';
    /**
     * Constant for value '_salesTaxPaymentVoided'
     * @return string '_salesTaxPaymentVoided'
     */
    const VALUE_SALES_TAX_PAYMENT_VOIDED = '_salesTaxPaymentVoided';
    /**
     * Constant for value '_statementChargeOpen'
     * @return string '_statementChargeOpen'
     */
    const VALUE_STATEMENT_CHARGE_OPEN = '_statementChargeOpen';
    /**
     * Constant for value '_statementChargePaidInFull'
     * @return string '_statementChargePaidInFull'
     */
    const VALUE_STATEMENT_CHARGE_PAID_IN_FULL = '_statementChargePaidInFull';
    /**
     * Constant for value '_taxLiabilityChequeVoided'
     * @return string '_taxLiabilityChequeVoided'
     */
    const VALUE_TAX_LIABILITY_CHEQUE_VOIDED = '_taxLiabilityChequeVoided';
    /**
     * Constant for value '_tegataPayableEndorsed'
     * @return string '_tegataPayableEndorsed'
     */
    const VALUE_TEGATA_PAYABLE_ENDORSED = '_tegataPayableEndorsed';
    /**
     * Constant for value '_tegataPayableIssued'
     * @return string '_tegataPayableIssued'
     */
    const VALUE_TEGATA_PAYABLE_ISSUED = '_tegataPayableIssued';
    /**
     * Constant for value '_tegataPayablePaid'
     * @return string '_tegataPayablePaid'
     */
    const VALUE_TEGATA_PAYABLE_PAID = '_tegataPayablePaid';
    /**
     * Constant for value '_tegataReceivablesCollected'
     * @return string '_tegataReceivablesCollected'
     */
    const VALUE_TEGATA_RECEIVABLES_COLLECTED = '_tegataReceivablesCollected';
    /**
     * Constant for value '_tegataReceivablesDiscounted'
     * @return string '_tegataReceivablesDiscounted'
     */
    const VALUE_TEGATA_RECEIVABLES_DISCOUNTED = '_tegataReceivablesDiscounted';
    /**
     * Constant for value '_tegataReceivablesEndorsed'
     * @return string '_tegataReceivablesEndorsed'
     */
    const VALUE_TEGATA_RECEIVABLES_ENDORSED = '_tegataReceivablesEndorsed';
    /**
     * Constant for value '_tegataReceivablesHolding'
     * @return string '_tegataReceivablesHolding'
     */
    const VALUE_TEGATA_RECEIVABLES_HOLDING = '_tegataReceivablesHolding';
    /**
     * Constant for value '_tegataReceivablesVoided'
     * @return string '_tegataReceivablesVoided'
     */
    const VALUE_TEGATA_RECEIVABLES_VOIDED = '_tegataReceivablesVoided';
    /**
     * Constant for value '_transferOrderClosed'
     * @return string '_transferOrderClosed'
     */
    const VALUE_TRANSFER_ORDER_CLOSED = '_transferOrderClosed';
    /**
     * Constant for value '_transferOrderPartiallyFulfilled'
     * @return string '_transferOrderPartiallyFulfilled'
     */
    const VALUE_TRANSFER_ORDER_PARTIALLY_FULFILLED = '_transferOrderPartiallyFulfilled';
    /**
     * Constant for value '_transferOrderPendingApproval'
     * @return string '_transferOrderPendingApproval'
     */
    const VALUE_TRANSFER_ORDER_PENDING_APPROVAL = '_transferOrderPendingApproval';
    /**
     * Constant for value '_transferOrderPendingFulfillment'
     * @return string '_transferOrderPendingFulfillment'
     */
    const VALUE_TRANSFER_ORDER_PENDING_FULFILLMENT = '_transferOrderPendingFulfillment';
    /**
     * Constant for value '_transferOrderPendingReceipt'
     * @return string '_transferOrderPendingReceipt'
     */
    const VALUE_TRANSFER_ORDER_PENDING_RECEIPT = '_transferOrderPendingReceipt';
    /**
     * Constant for value '_transferOrderPendingReceiptPartiallyFulfilled'
     * @return string '_transferOrderPendingReceiptPartiallyFulfilled'
     */
    const VALUE_TRANSFER_ORDER_PENDING_RECEIPT_PARTIALLY_FULFILLED = '_transferOrderPendingReceiptPartiallyFulfilled';
    /**
     * Constant for value '_transferOrderReceived'
     * @return string '_transferOrderReceived'
     */
    const VALUE_TRANSFER_ORDER_RECEIVED = '_transferOrderReceived';
    /**
     * Constant for value '_transferOrderRejected'
     * @return string '_transferOrderRejected'
     */
    const VALUE_TRANSFER_ORDER_REJECTED = '_transferOrderRejected';
    /**
     * Constant for value '_vendorReturnAuthorizationCancelled'
     * @return string '_vendorReturnAuthorizationCancelled'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_CANCELLED = '_vendorReturnAuthorizationCancelled';
    /**
     * Constant for value '_vendorReturnAuthorizationClosed'
     * @return string '_vendorReturnAuthorizationClosed'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_CLOSED = '_vendorReturnAuthorizationClosed';
    /**
     * Constant for value '_vendorReturnAuthorizationCredited'
     * @return string '_vendorReturnAuthorizationCredited'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_CREDITED = '_vendorReturnAuthorizationCredited';
    /**
     * Constant for value '_vendorReturnAuthorizationPartiallyReturned'
     * @return string '_vendorReturnAuthorizationPartiallyReturned'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_PARTIALLY_RETURNED = '_vendorReturnAuthorizationPartiallyReturned';
    /**
     * Constant for value '_vendorReturnAuthorizationPendingApproval'
     * @return string '_vendorReturnAuthorizationPendingApproval'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_APPROVAL = '_vendorReturnAuthorizationPendingApproval';
    /**
     * Constant for value '_vendorReturnAuthorizationPendingCredit'
     * @return string '_vendorReturnAuthorizationPendingCredit'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_CREDIT = '_vendorReturnAuthorizationPendingCredit';
    /**
     * Constant for value '_vendorReturnAuthorizationPendingCreditPartiallyReturned'
     * @return string '_vendorReturnAuthorizationPendingCreditPartiallyReturned'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_CREDIT_PARTIALLY_RETURNED = '_vendorReturnAuthorizationPendingCreditPartiallyReturned';
    /**
     * Constant for value '_vendorReturnAuthorizationPendingReturn'
     * @return string '_vendorReturnAuthorizationPendingReturn'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_RETURN = '_vendorReturnAuthorizationPendingReturn';
    /**
     * Constant for value '_workOrderBuilt'
     * @return string '_workOrderBuilt'
     */
    const VALUE_WORK_ORDER_BUILT = '_workOrderBuilt';
    /**
     * Constant for value '_workOrderCancelled'
     * @return string '_workOrderCancelled'
     */
    const VALUE_WORK_ORDER_CANCELLED = '_workOrderCancelled';
    /**
     * Constant for value '_workOrderClosed'
     * @return string '_workOrderClosed'
     */
    const VALUE_WORK_ORDER_CLOSED = '_workOrderClosed';
    /**
     * Constant for value '_workOrderPartiallyBuilt'
     * @return string '_workOrderPartiallyBuilt'
     */
    const VALUE_WORK_ORDER_PARTIALLY_BUILT = '_workOrderPartiallyBuilt';
    /**
     * Constant for value '_workOrderPendingBuild'
     * @return string '_workOrderPendingBuild'
     */
    const VALUE_WORK_ORDER_PENDING_BUILD = '_workOrderPendingBuild';
    /**
     * Constant for value '_workOrderPlanned'
     * @return string '_workOrderPlanned'
     */
    const VALUE_WORK_ORDER_PLANNED = '_workOrderPlanned';
    /**
     * Return allowed values
     * @uses self::VALUE_BILL_CANCELLED
     * @uses self::VALUE_BILL_OPEN
     * @uses self::VALUE_BILL_PAID_IN_FULL
     * @uses self::VALUE_BILL_PAYMENT_APPROVED
     * @uses self::VALUE_BILL_PAYMENT_CONFIRMED
     * @uses self::VALUE_BILL_PAYMENT_DECLINED
     * @uses self::VALUE_BILL_PAYMENT_IN_TRANSIT
     * @uses self::VALUE_BILL_PAYMENT_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL
     * @uses self::VALUE_BILL_PAYMENT_PENDING_APPROVAL
     * @uses self::VALUE_BILL_PAYMENT_REJECTED
     * @uses self::VALUE_BILL_PAYMENT_VOIDED
     * @uses self::VALUE_BILL_PENDING_APPROVAL
     * @uses self::VALUE_BILL_REJECTED
     * @uses self::VALUE_CASH_SALE_DEPOSITED
     * @uses self::VALUE_CASH_SALE_NOT_DEPOSITED
     * @uses self::VALUE_CASH_SALE_UNAPPROVED_PAYMENT
     * @uses self::VALUE_CHECK_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL
     * @uses self::VALUE_CHECK_VOIDED
     * @uses self::VALUE_COMMISSION_OVERPAID
     * @uses self::VALUE_COMMISSION_PAID_IN_FULL
     * @uses self::VALUE_COMMISSION_PENDING_ACCOUNTING_APPROVAL
     * @uses self::VALUE_COMMISSION_PENDING_PAYMENT
     * @uses self::VALUE_COMMISSION_REJECTED_BY_ACCOUNTING
     * @uses self::VALUE_CREDIT_MEMO_FULLY_APPLIED
     * @uses self::VALUE_CREDIT_MEMO_OPEN
     * @uses self::VALUE_CREDIT_MEMO_VOIDED
     * @uses self::VALUE_CUSTOMER_DEPOSIT_CANCELLED
     * @uses self::VALUE_CUSTOMER_DEPOSIT_DEPOSITED
     * @uses self::VALUE_CUSTOMER_DEPOSIT_FULLY_APPLIED
     * @uses self::VALUE_CUSTOMER_DEPOSIT_NOT_DEPOSITED
     * @uses self::VALUE_CUSTOMER_DEPOSIT_UNAPPROVED_PAYMENT
     * @uses self::VALUE_CUSTOMER_REFUND_CANCELLED
     * @uses self::VALUE_CUSTOMER_REFUND_VOIDED
     * @uses self::VALUE_ESTIMATE_CLOSED
     * @uses self::VALUE_ESTIMATE_EXPIRED
     * @uses self::VALUE_ESTIMATE_OPEN
     * @uses self::VALUE_ESTIMATE_PROCESSED
     * @uses self::VALUE_ESTIMATE_VOIDED
     * @uses self::VALUE_EXPENSE_REPORT_APPROVED_BY_ACCOUNTING
     * @uses self::VALUE_EXPENSE_REPORT_APPROVED_OVERRIDDEN_BY_ACCOUNTING
     * @uses self::VALUE_EXPENSE_REPORT_IN_PROGRESS
     * @uses self::VALUE_EXPENSE_REPORT_PAID_IN_FULL
     * @uses self::VALUE_EXPENSE_REPORT_PAYMENT_IN_TRANSIT
     * @uses self::VALUE_EXPENSE_REPORT_PENDING_ACCOUNTING_APPROVAL
     * @uses self::VALUE_EXPENSE_REPORT_PENDING_SUPERVISOR_APPROVAL
     * @uses self::VALUE_EXPENSE_REPORT_REJECTED_BY_ACCOUNTING
     * @uses self::VALUE_EXPENSE_REPORT_REJECTED_BY_SUPERVISOR
     * @uses self::VALUE_EXPENSE_REPORT_REJECTED_OVERRIDDEN_BY_ACCOUNTING
     * @uses self::VALUE_EXPENSE_REPORT_VOIDED
     * @uses self::VALUE_INVOICE_OPEN
     * @uses self::VALUE_INVOICE_PAID_IN_FULL
     * @uses self::VALUE_INVOICE_PENDING_APPROVAL
     * @uses self::VALUE_INVOICE_REJECTED
     * @uses self::VALUE_INVOICE_VOIDED
     * @uses self::VALUE_ITEM_FULFILLMENT_PACKED
     * @uses self::VALUE_ITEM_FULFILLMENT_PICKED
     * @uses self::VALUE_ITEM_FULFILLMENT_SHIPPED
     * @uses self::VALUE_JOURNAL_APPROVED_FOR_POSTING
     * @uses self::VALUE_JOURNAL_PENDING_APPROVAL
     * @uses self::VALUE_JOURNAL_REJECTED
     * @uses self::VALUE_OPPORTUNITY_CLOSED_LOST
     * @uses self::VALUE_OPPORTUNITY_CLOSED_WON
     * @uses self::VALUE_OPPORTUNITY_IN_PROGRESS
     * @uses self::VALUE_OPPORTUNITY_ISSUED_ESTIMATE
     * @uses self::VALUE_PAYCHECK_COMMITTED
     * @uses self::VALUE_PAYCHECK_CREATED
     * @uses self::VALUE_PAYCHECK_ERROR
     * @uses self::VALUE_PAYCHECK_PENDING_COMMITMENT
     * @uses self::VALUE_PAYCHECK_PENDING_TAX_CALCULATION
     * @uses self::VALUE_PAYCHECK_PREVIEW
     * @uses self::VALUE_PAYCHECK_REVERSED
     * @uses self::VALUE_PAYMENT_CANCELLED
     * @uses self::VALUE_PAYMENT_DEPOSITED
     * @uses self::VALUE_PAYMENT_NOT_DEPOSITED
     * @uses self::VALUE_PAYMENT_UNAPPROVED_PAYMENT
     * @uses self::VALUE_PAYROLL_LIABILITY_CHECK_VOIDED
     * @uses self::VALUE_PERIOD_END_JOURNAL_APPROVED_FOR_POSTING
     * @uses self::VALUE_PERIOD_END_JOURNAL_PENDING_APPROVAL
     * @uses self::VALUE_PERIOD_END_JOURNAL_REJECTED
     * @uses self::VALUE_PURCHASE_ORDER_CLOSED
     * @uses self::VALUE_PURCHASE_ORDER_FULLY_BILLED
     * @uses self::VALUE_PURCHASE_ORDER_PARTIALLY_RECEIVED
     * @uses self::VALUE_PURCHASE_ORDER_PENDING_BILL
     * @uses self::VALUE_PURCHASE_ORDER_PENDING_BILLING_PARTIALLY_RECEIVED
     * @uses self::VALUE_PURCHASE_ORDER_PENDING_RECEIPT
     * @uses self::VALUE_PURCHASE_ORDER_PENDING_SUPERVISOR_APPROVAL
     * @uses self::VALUE_PURCHASE_ORDER_PLANNED
     * @uses self::VALUE_PURCHASE_ORDER_REJECTED_BY_SUPERVISOR
     * @uses self::VALUE_REQUISITION_CANCELLED
     * @uses self::VALUE_REQUISITION_CLOSED
     * @uses self::VALUE_REQUISITION_FULLY_ORDERED
     * @uses self::VALUE_REQUISITION_FULLY_RECEIVED
     * @uses self::VALUE_REQUISITION_PARTIALLY_ORDERED
     * @uses self::VALUE_REQUISITION_PARTIALLY_RECEIVED
     * @uses self::VALUE_REQUISITION_PENDING_APPROVAL
     * @uses self::VALUE_REQUISITION_PENDING_ORDER
     * @uses self::VALUE_REQUISITION_REJECTED
     * @uses self::VALUE_RETURN_AUTHORIZATION_CANCELLED
     * @uses self::VALUE_RETURN_AUTHORIZATION_CLOSED
     * @uses self::VALUE_RETURN_AUTHORIZATION_PARTIALLY_RECEIVED
     * @uses self::VALUE_RETURN_AUTHORIZATION_PENDING_APPROVAL
     * @uses self::VALUE_RETURN_AUTHORIZATION_PENDING_RECEIPT
     * @uses self::VALUE_RETURN_AUTHORIZATION_PENDING_REFUND
     * @uses self::VALUE_RETURN_AUTHORIZATION_PENDING_REFUND_PARTIALLY_RECEIVED
     * @uses self::VALUE_RETURN_AUTHORIZATION_REFUNDED
     * @uses self::VALUE_SALES_ORDER_BILLED
     * @uses self::VALUE_SALES_ORDER_CANCELLED
     * @uses self::VALUE_SALES_ORDER_CLOSED
     * @uses self::VALUE_SALES_ORDER_PARTIALLY_FULFILLED
     * @uses self::VALUE_SALES_ORDER_PENDING_APPROVAL
     * @uses self::VALUE_SALES_ORDER_PENDING_BILLING
     * @uses self::VALUE_SALES_ORDER_PENDING_BILLING_PARTIALLY_FULFILLED
     * @uses self::VALUE_SALES_ORDER_PENDING_FULFILLMENT
     * @uses self::VALUE_SALES_TAX_PAYMENT_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL
     * @uses self::VALUE_SALES_TAX_PAYMENT_VOIDED
     * @uses self::VALUE_STATEMENT_CHARGE_OPEN
     * @uses self::VALUE_STATEMENT_CHARGE_PAID_IN_FULL
     * @uses self::VALUE_TAX_LIABILITY_CHEQUE_VOIDED
     * @uses self::VALUE_TEGATA_PAYABLE_ENDORSED
     * @uses self::VALUE_TEGATA_PAYABLE_ISSUED
     * @uses self::VALUE_TEGATA_PAYABLE_PAID
     * @uses self::VALUE_TEGATA_RECEIVABLES_COLLECTED
     * @uses self::VALUE_TEGATA_RECEIVABLES_DISCOUNTED
     * @uses self::VALUE_TEGATA_RECEIVABLES_ENDORSED
     * @uses self::VALUE_TEGATA_RECEIVABLES_HOLDING
     * @uses self::VALUE_TEGATA_RECEIVABLES_VOIDED
     * @uses self::VALUE_TRANSFER_ORDER_CLOSED
     * @uses self::VALUE_TRANSFER_ORDER_PARTIALLY_FULFILLED
     * @uses self::VALUE_TRANSFER_ORDER_PENDING_APPROVAL
     * @uses self::VALUE_TRANSFER_ORDER_PENDING_FULFILLMENT
     * @uses self::VALUE_TRANSFER_ORDER_PENDING_RECEIPT
     * @uses self::VALUE_TRANSFER_ORDER_PENDING_RECEIPT_PARTIALLY_FULFILLED
     * @uses self::VALUE_TRANSFER_ORDER_RECEIVED
     * @uses self::VALUE_TRANSFER_ORDER_REJECTED
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_CANCELLED
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_CLOSED
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_CREDITED
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_PARTIALLY_RETURNED
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_APPROVAL
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_CREDIT
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_CREDIT_PARTIALLY_RETURNED
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_RETURN
     * @uses self::VALUE_WORK_ORDER_BUILT
     * @uses self::VALUE_WORK_ORDER_CANCELLED
     * @uses self::VALUE_WORK_ORDER_CLOSED
     * @uses self::VALUE_WORK_ORDER_PARTIALLY_BUILT
     * @uses self::VALUE_WORK_ORDER_PENDING_BUILD
     * @uses self::VALUE_WORK_ORDER_PLANNED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BILL_CANCELLED,
            self::VALUE_BILL_OPEN,
            self::VALUE_BILL_PAID_IN_FULL,
            self::VALUE_BILL_PAYMENT_APPROVED,
            self::VALUE_BILL_PAYMENT_CONFIRMED,
            self::VALUE_BILL_PAYMENT_DECLINED,
            self::VALUE_BILL_PAYMENT_IN_TRANSIT,
            self::VALUE_BILL_PAYMENT_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL,
            self::VALUE_BILL_PAYMENT_PENDING_APPROVAL,
            self::VALUE_BILL_PAYMENT_REJECTED,
            self::VALUE_BILL_PAYMENT_VOIDED,
            self::VALUE_BILL_PENDING_APPROVAL,
            self::VALUE_BILL_REJECTED,
            self::VALUE_CASH_SALE_DEPOSITED,
            self::VALUE_CASH_SALE_NOT_DEPOSITED,
            self::VALUE_CASH_SALE_UNAPPROVED_PAYMENT,
            self::VALUE_CHECK_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL,
            self::VALUE_CHECK_VOIDED,
            self::VALUE_COMMISSION_OVERPAID,
            self::VALUE_COMMISSION_PAID_IN_FULL,
            self::VALUE_COMMISSION_PENDING_ACCOUNTING_APPROVAL,
            self::VALUE_COMMISSION_PENDING_PAYMENT,
            self::VALUE_COMMISSION_REJECTED_BY_ACCOUNTING,
            self::VALUE_CREDIT_MEMO_FULLY_APPLIED,
            self::VALUE_CREDIT_MEMO_OPEN,
            self::VALUE_CREDIT_MEMO_VOIDED,
            self::VALUE_CUSTOMER_DEPOSIT_CANCELLED,
            self::VALUE_CUSTOMER_DEPOSIT_DEPOSITED,
            self::VALUE_CUSTOMER_DEPOSIT_FULLY_APPLIED,
            self::VALUE_CUSTOMER_DEPOSIT_NOT_DEPOSITED,
            self::VALUE_CUSTOMER_DEPOSIT_UNAPPROVED_PAYMENT,
            self::VALUE_CUSTOMER_REFUND_CANCELLED,
            self::VALUE_CUSTOMER_REFUND_VOIDED,
            self::VALUE_ESTIMATE_CLOSED,
            self::VALUE_ESTIMATE_EXPIRED,
            self::VALUE_ESTIMATE_OPEN,
            self::VALUE_ESTIMATE_PROCESSED,
            self::VALUE_ESTIMATE_VOIDED,
            self::VALUE_EXPENSE_REPORT_APPROVED_BY_ACCOUNTING,
            self::VALUE_EXPENSE_REPORT_APPROVED_OVERRIDDEN_BY_ACCOUNTING,
            self::VALUE_EXPENSE_REPORT_IN_PROGRESS,
            self::VALUE_EXPENSE_REPORT_PAID_IN_FULL,
            self::VALUE_EXPENSE_REPORT_PAYMENT_IN_TRANSIT,
            self::VALUE_EXPENSE_REPORT_PENDING_ACCOUNTING_APPROVAL,
            self::VALUE_EXPENSE_REPORT_PENDING_SUPERVISOR_APPROVAL,
            self::VALUE_EXPENSE_REPORT_REJECTED_BY_ACCOUNTING,
            self::VALUE_EXPENSE_REPORT_REJECTED_BY_SUPERVISOR,
            self::VALUE_EXPENSE_REPORT_REJECTED_OVERRIDDEN_BY_ACCOUNTING,
            self::VALUE_EXPENSE_REPORT_VOIDED,
            self::VALUE_INVOICE_OPEN,
            self::VALUE_INVOICE_PAID_IN_FULL,
            self::VALUE_INVOICE_PENDING_APPROVAL,
            self::VALUE_INVOICE_REJECTED,
            self::VALUE_INVOICE_VOIDED,
            self::VALUE_ITEM_FULFILLMENT_PACKED,
            self::VALUE_ITEM_FULFILLMENT_PICKED,
            self::VALUE_ITEM_FULFILLMENT_SHIPPED,
            self::VALUE_JOURNAL_APPROVED_FOR_POSTING,
            self::VALUE_JOURNAL_PENDING_APPROVAL,
            self::VALUE_JOURNAL_REJECTED,
            self::VALUE_OPPORTUNITY_CLOSED_LOST,
            self::VALUE_OPPORTUNITY_CLOSED_WON,
            self::VALUE_OPPORTUNITY_IN_PROGRESS,
            self::VALUE_OPPORTUNITY_ISSUED_ESTIMATE,
            self::VALUE_PAYCHECK_COMMITTED,
            self::VALUE_PAYCHECK_CREATED,
            self::VALUE_PAYCHECK_ERROR,
            self::VALUE_PAYCHECK_PENDING_COMMITMENT,
            self::VALUE_PAYCHECK_PENDING_TAX_CALCULATION,
            self::VALUE_PAYCHECK_PREVIEW,
            self::VALUE_PAYCHECK_REVERSED,
            self::VALUE_PAYMENT_CANCELLED,
            self::VALUE_PAYMENT_DEPOSITED,
            self::VALUE_PAYMENT_NOT_DEPOSITED,
            self::VALUE_PAYMENT_UNAPPROVED_PAYMENT,
            self::VALUE_PAYROLL_LIABILITY_CHECK_VOIDED,
            self::VALUE_PERIOD_END_JOURNAL_APPROVED_FOR_POSTING,
            self::VALUE_PERIOD_END_JOURNAL_PENDING_APPROVAL,
            self::VALUE_PERIOD_END_JOURNAL_REJECTED,
            self::VALUE_PURCHASE_ORDER_CLOSED,
            self::VALUE_PURCHASE_ORDER_FULLY_BILLED,
            self::VALUE_PURCHASE_ORDER_PARTIALLY_RECEIVED,
            self::VALUE_PURCHASE_ORDER_PENDING_BILL,
            self::VALUE_PURCHASE_ORDER_PENDING_BILLING_PARTIALLY_RECEIVED,
            self::VALUE_PURCHASE_ORDER_PENDING_RECEIPT,
            self::VALUE_PURCHASE_ORDER_PENDING_SUPERVISOR_APPROVAL,
            self::VALUE_PURCHASE_ORDER_PLANNED,
            self::VALUE_PURCHASE_ORDER_REJECTED_BY_SUPERVISOR,
            self::VALUE_REQUISITION_CANCELLED,
            self::VALUE_REQUISITION_CLOSED,
            self::VALUE_REQUISITION_FULLY_ORDERED,
            self::VALUE_REQUISITION_FULLY_RECEIVED,
            self::VALUE_REQUISITION_PARTIALLY_ORDERED,
            self::VALUE_REQUISITION_PARTIALLY_RECEIVED,
            self::VALUE_REQUISITION_PENDING_APPROVAL,
            self::VALUE_REQUISITION_PENDING_ORDER,
            self::VALUE_REQUISITION_REJECTED,
            self::VALUE_RETURN_AUTHORIZATION_CANCELLED,
            self::VALUE_RETURN_AUTHORIZATION_CLOSED,
            self::VALUE_RETURN_AUTHORIZATION_PARTIALLY_RECEIVED,
            self::VALUE_RETURN_AUTHORIZATION_PENDING_APPROVAL,
            self::VALUE_RETURN_AUTHORIZATION_PENDING_RECEIPT,
            self::VALUE_RETURN_AUTHORIZATION_PENDING_REFUND,
            self::VALUE_RETURN_AUTHORIZATION_PENDING_REFUND_PARTIALLY_RECEIVED,
            self::VALUE_RETURN_AUTHORIZATION_REFUNDED,
            self::VALUE_SALES_ORDER_BILLED,
            self::VALUE_SALES_ORDER_CANCELLED,
            self::VALUE_SALES_ORDER_CLOSED,
            self::VALUE_SALES_ORDER_PARTIALLY_FULFILLED,
            self::VALUE_SALES_ORDER_PENDING_APPROVAL,
            self::VALUE_SALES_ORDER_PENDING_BILLING,
            self::VALUE_SALES_ORDER_PENDING_BILLING_PARTIALLY_FULFILLED,
            self::VALUE_SALES_ORDER_PENDING_FULFILLMENT,
            self::VALUE_SALES_TAX_PAYMENT_ONLINE_BILL_PAY_PENDING_ACCOUNTING_APPROVAL,
            self::VALUE_SALES_TAX_PAYMENT_VOIDED,
            self::VALUE_STATEMENT_CHARGE_OPEN,
            self::VALUE_STATEMENT_CHARGE_PAID_IN_FULL,
            self::VALUE_TAX_LIABILITY_CHEQUE_VOIDED,
            self::VALUE_TEGATA_PAYABLE_ENDORSED,
            self::VALUE_TEGATA_PAYABLE_ISSUED,
            self::VALUE_TEGATA_PAYABLE_PAID,
            self::VALUE_TEGATA_RECEIVABLES_COLLECTED,
            self::VALUE_TEGATA_RECEIVABLES_DISCOUNTED,
            self::VALUE_TEGATA_RECEIVABLES_ENDORSED,
            self::VALUE_TEGATA_RECEIVABLES_HOLDING,
            self::VALUE_TEGATA_RECEIVABLES_VOIDED,
            self::VALUE_TRANSFER_ORDER_CLOSED,
            self::VALUE_TRANSFER_ORDER_PARTIALLY_FULFILLED,
            self::VALUE_TRANSFER_ORDER_PENDING_APPROVAL,
            self::VALUE_TRANSFER_ORDER_PENDING_FULFILLMENT,
            self::VALUE_TRANSFER_ORDER_PENDING_RECEIPT,
            self::VALUE_TRANSFER_ORDER_PENDING_RECEIPT_PARTIALLY_FULFILLED,
            self::VALUE_TRANSFER_ORDER_RECEIVED,
            self::VALUE_TRANSFER_ORDER_REJECTED,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_CANCELLED,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_CLOSED,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_CREDITED,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_PARTIALLY_RETURNED,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_APPROVAL,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_CREDIT,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_CREDIT_PARTIALLY_RETURNED,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION_PENDING_RETURN,
            self::VALUE_WORK_ORDER_BUILT,
            self::VALUE_WORK_ORDER_CANCELLED,
            self::VALUE_WORK_ORDER_CLOSED,
            self::VALUE_WORK_ORDER_PARTIALLY_BUILT,
            self::VALUE_WORK_ORDER_PENDING_BUILD,
            self::VALUE_WORK_ORDER_PLANNED,
        );
    }
}
