<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionPaymentEventHoldReason EnumType
 * @subpackage Enumerations
 */
class TransactionPaymentEventHoldReason extends AbstractStructEnumBase
{
    /**
     * Constant for value '_amountExceedsMaximumAllowedAmount'
     * @return string '_amountExceedsMaximumAllowedAmount'
     */
    const VALUE_AMOUNT_EXCEEDS_MAXIMUM_ALLOWED_AMOUNT = '_amountExceedsMaximumAllowedAmount';
    /**
     * Constant for value '_authorizationDecline'
     * @return string '_authorizationDecline'
     */
    const VALUE_AUTHORIZATION_DECLINE = '_authorizationDecline';
    /**
     * Constant for value '_cardExpired'
     * @return string '_cardExpired'
     */
    const VALUE_CARD_EXPIRED = '_cardExpired';
    /**
     * Constant for value '_cardInvalid'
     * @return string '_cardInvalid'
     */
    const VALUE_CARD_INVALID = '_cardInvalid';
    /**
     * Constant for value '_confirmationOfTheOperationIsPending'
     * @return string '_confirmationOfTheOperationIsPending'
     */
    const VALUE_CONFIRMATION_OF_THE_OPERATION_IS_PENDING = '_confirmationOfTheOperationIsPending';
    /**
     * Constant for value '_externalFraudRejection'
     * @return string '_externalFraudRejection'
     */
    const VALUE_EXTERNAL_FRAUD_REJECTION = '_externalFraudRejection';
    /**
     * Constant for value '_externalFraudReview'
     * @return string '_externalFraudReview'
     */
    const VALUE_EXTERNAL_FRAUD_REVIEW = '_externalFraudReview';
    /**
     * Constant for value '_failedToPrimeDevice'
     * @return string '_failedToPrimeDevice'
     */
    const VALUE_FAILED_TO_PRIME_DEVICE = '_failedToPrimeDevice';
    /**
     * Constant for value '_fatalError'
     * @return string '_fatalError'
     */
    const VALUE_FATAL_ERROR = '_fatalError';
    /**
     * Constant for value '_forwardedToPayerAuthentication'
     * @return string '_forwardedToPayerAuthentication'
     */
    const VALUE_FORWARDED_TO_PAYER_AUTHENTICATION = '_forwardedToPayerAuthentication';
    /**
     * Constant for value '_forwardRequested'
     * @return string '_forwardRequested'
     */
    const VALUE_FORWARD_REQUESTED = '_forwardRequested';
    /**
     * Constant for value '_forwardToAuthenticateDevice'
     * @return string '_forwardToAuthenticateDevice'
     */
    const VALUE_FORWARD_TO_AUTHENTICATE_DEVICE = '_forwardToAuthenticateDevice';
    /**
     * Constant for value '_forwardToChallengeShopper'
     * @return string '_forwardToChallengeShopper'
     */
    const VALUE_FORWARD_TO_CHALLENGE_SHOPPER = '_forwardToChallengeShopper';
    /**
     * Constant for value '_gatewayAsynchronousNotification'
     * @return string '_gatewayAsynchronousNotification'
     */
    const VALUE_GATEWAY_ASYNCHRONOUS_NOTIFICATION = '_gatewayAsynchronousNotification';
    /**
     * Constant for value '_gatewayError'
     * @return string '_gatewayError'
     */
    const VALUE_GATEWAY_ERROR = '_gatewayError';
    /**
     * Constant for value '_generalHold'
     * @return string '_generalHold'
     */
    const VALUE_GENERAL_HOLD = '_generalHold';
    /**
     * Constant for value '_generalReject'
     * @return string '_generalReject'
     */
    const VALUE_GENERAL_REJECT = '_generalReject';
    /**
     * Constant for value '_notRequired'
     * @return string '_notRequired'
     */
    const VALUE_NOT_REQUIRED = '_notRequired';
    /**
     * Constant for value '_operationWasSuccessful'
     * @return string '_operationWasSuccessful'
     */
    const VALUE_OPERATION_WAS_SUCCESSFUL = '_operationWasSuccessful';
    /**
     * Constant for value '_operationWasTerminated'
     * @return string '_operationWasTerminated'
     */
    const VALUE_OPERATION_WAS_TERMINATED = '_operationWasTerminated';
    /**
     * Constant for value '_overridenBy'
     * @return string '_overridenBy'
     */
    const VALUE_OVERRIDEN_BY = '_overridenBy';
    /**
     * Constant for value '_partnerDecline'
     * @return string '_partnerDecline'
     */
    const VALUE_PARTNER_DECLINE = '_partnerDecline';
    /**
     * Constant for value '_paymentDeviceWasPrimed'
     * @return string '_paymentDeviceWasPrimed'
     */
    const VALUE_PAYMENT_DEVICE_WAS_PRIMED = '_paymentDeviceWasPrimed';
    /**
     * Constant for value '_paymentOperationWasCanceled'
     * @return string '_paymentOperationWasCanceled'
     */
    const VALUE_PAYMENT_OPERATION_WAS_CANCELED = '_paymentOperationWasCanceled';
    /**
     * Constant for value '_systemError'
     * @return string '_systemError'
     */
    const VALUE_SYSTEM_ERROR = '_systemError';
    /**
     * Constant for value '_verbalAuthorizationRequested'
     * @return string '_verbalAuthorizationRequested'
     */
    const VALUE_VERBAL_AUTHORIZATION_REQUESTED = '_verbalAuthorizationRequested';
    /**
     * Constant for value '_verificationRejection'
     * @return string '_verificationRejection'
     */
    const VALUE_VERIFICATION_REJECTION = '_verificationRejection';
    /**
     * Constant for value '_verificationRequired'
     * @return string '_verificationRequired'
     */
    const VALUE_VERIFICATION_REQUIRED = '_verificationRequired';
    /**
     * Return allowed values
     * @uses self::VALUE_AMOUNT_EXCEEDS_MAXIMUM_ALLOWED_AMOUNT
     * @uses self::VALUE_AUTHORIZATION_DECLINE
     * @uses self::VALUE_CARD_EXPIRED
     * @uses self::VALUE_CARD_INVALID
     * @uses self::VALUE_CONFIRMATION_OF_THE_OPERATION_IS_PENDING
     * @uses self::VALUE_EXTERNAL_FRAUD_REJECTION
     * @uses self::VALUE_EXTERNAL_FRAUD_REVIEW
     * @uses self::VALUE_FAILED_TO_PRIME_DEVICE
     * @uses self::VALUE_FATAL_ERROR
     * @uses self::VALUE_FORWARDED_TO_PAYER_AUTHENTICATION
     * @uses self::VALUE_FORWARD_REQUESTED
     * @uses self::VALUE_FORWARD_TO_AUTHENTICATE_DEVICE
     * @uses self::VALUE_FORWARD_TO_CHALLENGE_SHOPPER
     * @uses self::VALUE_GATEWAY_ASYNCHRONOUS_NOTIFICATION
     * @uses self::VALUE_GATEWAY_ERROR
     * @uses self::VALUE_GENERAL_HOLD
     * @uses self::VALUE_GENERAL_REJECT
     * @uses self::VALUE_NOT_REQUIRED
     * @uses self::VALUE_OPERATION_WAS_SUCCESSFUL
     * @uses self::VALUE_OPERATION_WAS_TERMINATED
     * @uses self::VALUE_OVERRIDEN_BY
     * @uses self::VALUE_PARTNER_DECLINE
     * @uses self::VALUE_PAYMENT_DEVICE_WAS_PRIMED
     * @uses self::VALUE_PAYMENT_OPERATION_WAS_CANCELED
     * @uses self::VALUE_SYSTEM_ERROR
     * @uses self::VALUE_VERBAL_AUTHORIZATION_REQUESTED
     * @uses self::VALUE_VERIFICATION_REJECTION
     * @uses self::VALUE_VERIFICATION_REQUIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AMOUNT_EXCEEDS_MAXIMUM_ALLOWED_AMOUNT,
            self::VALUE_AUTHORIZATION_DECLINE,
            self::VALUE_CARD_EXPIRED,
            self::VALUE_CARD_INVALID,
            self::VALUE_CONFIRMATION_OF_THE_OPERATION_IS_PENDING,
            self::VALUE_EXTERNAL_FRAUD_REJECTION,
            self::VALUE_EXTERNAL_FRAUD_REVIEW,
            self::VALUE_FAILED_TO_PRIME_DEVICE,
            self::VALUE_FATAL_ERROR,
            self::VALUE_FORWARDED_TO_PAYER_AUTHENTICATION,
            self::VALUE_FORWARD_REQUESTED,
            self::VALUE_FORWARD_TO_AUTHENTICATE_DEVICE,
            self::VALUE_FORWARD_TO_CHALLENGE_SHOPPER,
            self::VALUE_GATEWAY_ASYNCHRONOUS_NOTIFICATION,
            self::VALUE_GATEWAY_ERROR,
            self::VALUE_GENERAL_HOLD,
            self::VALUE_GENERAL_REJECT,
            self::VALUE_NOT_REQUIRED,
            self::VALUE_OPERATION_WAS_SUCCESSFUL,
            self::VALUE_OPERATION_WAS_TERMINATED,
            self::VALUE_OVERRIDEN_BY,
            self::VALUE_PARTNER_DECLINE,
            self::VALUE_PAYMENT_DEVICE_WAS_PRIMED,
            self::VALUE_PAYMENT_OPERATION_WAS_CANCELED,
            self::VALUE_SYSTEM_ERROR,
            self::VALUE_VERBAL_AUTHORIZATION_REQUESTED,
            self::VALUE_VERIFICATION_REJECTION,
            self::VALUE_VERIFICATION_REQUIRED,
        );
    }
}
