<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for LandedCostSource EnumType
 * @subpackage Enumerations
 */
class LandedCostSource extends AbstractStructEnumBase
{
    /**
     * Constant for value '_manual'
     * @return string '_manual'
     */
    const VALUE_MANUAL = '_manual';
    /**
     * Constant for value '_otherTransaction'
     * @return string '_otherTransaction'
     */
    const VALUE_OTHER_TRANSACTION = '_otherTransaction';
    /**
     * Constant for value '_otherTransactionExcludeTax'
     * @return string '_otherTransactionExcludeTax'
     */
    const VALUE_OTHER_TRANSACTION_EXCLUDE_TAX = '_otherTransactionExcludeTax';
    /**
     * Constant for value '_thisTransaction'
     * @return string '_thisTransaction'
     */
    const VALUE_THIS_TRANSACTION = '_thisTransaction';
    /**
     * Return allowed values
     * @uses self::VALUE_MANUAL
     * @uses self::VALUE_OTHER_TRANSACTION
     * @uses self::VALUE_OTHER_TRANSACTION_EXCLUDE_TAX
     * @uses self::VALUE_THIS_TRANSACTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MANUAL,
            self::VALUE_OTHER_TRANSACTION,
            self::VALUE_OTHER_TRANSACTION_EXCLUDE_TAX,
            self::VALUE_THIS_TRANSACTION,
        );
    }
}
