<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ItemOverheadType EnumType
 * @subpackage Enumerations
 */
class ItemOverheadType extends AbstractStructEnumBase
{
    /**
     * Constant for value '_amountBaseUnit'
     * @return string '_amountBaseUnit'
     */
    const VALUE_AMOUNT_BASE_UNIT = '_amountBaseUnit';
    /**
     * Constant for value '_percentOfMaterial'
     * @return string '_percentOfMaterial'
     */
    const VALUE_PERCENT_OF_MATERIAL = '_percentOfMaterial';
    /**
     * Constant for value '_percentOfTotal'
     * @return string '_percentOfTotal'
     */
    const VALUE_PERCENT_OF_TOTAL = '_percentOfTotal';
    /**
     * Return allowed values
     * @uses self::VALUE_AMOUNT_BASE_UNIT
     * @uses self::VALUE_PERCENT_OF_MATERIAL
     * @uses self::VALUE_PERCENT_OF_TOTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AMOUNT_BASE_UNIT,
            self::VALUE_PERCENT_OF_MATERIAL,
            self::VALUE_PERCENT_OF_TOTAL,
        );
    }
}
