<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InitializeType EnumType
 * @subpackage Enumerations
 */
class InitializeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'assemblyBuild'
     * @return string 'assemblyBuild'
     */
    const VALUE_ASSEMBLY_BUILD = 'assemblyBuild';
    /**
     * Constant for value 'assemblyUnbuild'
     * @return string 'assemblyUnbuild'
     */
    const VALUE_ASSEMBLY_UNBUILD = 'assemblyUnbuild';
    /**
     * Constant for value 'binWorksheet'
     * @return string 'binWorksheet'
     */
    const VALUE_BIN_WORKSHEET = 'binWorksheet';
    /**
     * Constant for value 'cashRefund'
     * @return string 'cashRefund'
     */
    const VALUE_CASH_REFUND = 'cashRefund';
    /**
     * Constant for value 'cashSale'
     * @return string 'cashSale'
     */
    const VALUE_CASH_SALE = 'cashSale';
    /**
     * Constant for value 'creditMemo'
     * @return string 'creditMemo'
     */
    const VALUE_CREDIT_MEMO = 'creditMemo';
    /**
     * Constant for value 'customerPayment'
     * @return string 'customerPayment'
     */
    const VALUE_CUSTOMER_PAYMENT = 'customerPayment';
    /**
     * Constant for value 'customerRefund'
     * @return string 'customerRefund'
     */
    const VALUE_CUSTOMER_REFUND = 'customerRefund';
    /**
     * Constant for value 'customPurchase'
     * @return string 'customPurchase'
     */
    const VALUE_CUSTOM_PURCHASE = 'customPurchase';
    /**
     * Constant for value 'customSale'
     * @return string 'customSale'
     */
    const VALUE_CUSTOM_SALE = 'customSale';
    /**
     * Constant for value 'depositApplication'
     * @return string 'depositApplication'
     */
    const VALUE_DEPOSIT_APPLICATION = 'depositApplication';
    /**
     * Constant for value 'estimate'
     * @return string 'estimate'
     */
    const VALUE_ESTIMATE = 'estimate';
    /**
     * Constant for value 'invoice'
     * @return string 'invoice'
     */
    const VALUE_INVOICE = 'invoice';
    /**
     * Constant for value 'itemFulfillment'
     * @return string 'itemFulfillment'
     */
    const VALUE_ITEM_FULFILLMENT = 'itemFulfillment';
    /**
     * Constant for value 'itemReceipt'
     * @return string 'itemReceipt'
     */
    const VALUE_ITEM_RECEIPT = 'itemReceipt';
    /**
     * Constant for value 'inventoryTransfer'
     * @return string 'inventoryTransfer'
     */
    const VALUE_INVENTORY_TRANSFER = 'inventoryTransfer';
    /**
     * Constant for value 'purchaseOrder'
     * @return string 'purchaseOrder'
     */
    const VALUE_PURCHASE_ORDER = 'purchaseOrder';
    /**
     * Constant for value 'returnAuthorization'
     * @return string 'returnAuthorization'
     */
    const VALUE_RETURN_AUTHORIZATION = 'returnAuthorization';
    /**
     * Constant for value 'salesOrder'
     * @return string 'salesOrder'
     */
    const VALUE_SALES_ORDER = 'salesOrder';
    /**
     * Constant for value 'vendorBill'
     * @return string 'vendorBill'
     */
    const VALUE_VENDOR_BILL = 'vendorBill';
    /**
     * Constant for value 'vendorCredit'
     * @return string 'vendorCredit'
     */
    const VALUE_VENDOR_CREDIT = 'vendorCredit';
    /**
     * Constant for value 'vendorReturnAuthorization'
     * @return string 'vendorReturnAuthorization'
     */
    const VALUE_VENDOR_RETURN_AUTHORIZATION = 'vendorReturnAuthorization';
    /**
     * Constant for value 'vendorPayment'
     * @return string 'vendorPayment'
     */
    const VALUE_VENDOR_PAYMENT = 'vendorPayment';
    /**
     * Constant for value 'workOrder'
     * @return string 'workOrder'
     */
    const VALUE_WORK_ORDER = 'workOrder';
    /**
     * Constant for value 'workOrderIssue'
     * @return string 'workOrderIssue'
     */
    const VALUE_WORK_ORDER_ISSUE = 'workOrderIssue';
    /**
     * Constant for value 'workOrderCompletion'
     * @return string 'workOrderCompletion'
     */
    const VALUE_WORK_ORDER_COMPLETION = 'workOrderCompletion';
    /**
     * Constant for value 'workOrderClose'
     * @return string 'workOrderClose'
     */
    const VALUE_WORK_ORDER_CLOSE = 'workOrderClose';
    /**
     * Return allowed values
     * @uses self::VALUE_ASSEMBLY_BUILD
     * @uses self::VALUE_ASSEMBLY_UNBUILD
     * @uses self::VALUE_BIN_WORKSHEET
     * @uses self::VALUE_CASH_REFUND
     * @uses self::VALUE_CASH_SALE
     * @uses self::VALUE_CREDIT_MEMO
     * @uses self::VALUE_CUSTOMER_PAYMENT
     * @uses self::VALUE_CUSTOMER_REFUND
     * @uses self::VALUE_CUSTOM_PURCHASE
     * @uses self::VALUE_CUSTOM_SALE
     * @uses self::VALUE_DEPOSIT_APPLICATION
     * @uses self::VALUE_ESTIMATE
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_ITEM_FULFILLMENT
     * @uses self::VALUE_ITEM_RECEIPT
     * @uses self::VALUE_INVENTORY_TRANSFER
     * @uses self::VALUE_PURCHASE_ORDER
     * @uses self::VALUE_RETURN_AUTHORIZATION
     * @uses self::VALUE_SALES_ORDER
     * @uses self::VALUE_VENDOR_BILL
     * @uses self::VALUE_VENDOR_CREDIT
     * @uses self::VALUE_VENDOR_RETURN_AUTHORIZATION
     * @uses self::VALUE_VENDOR_PAYMENT
     * @uses self::VALUE_WORK_ORDER
     * @uses self::VALUE_WORK_ORDER_ISSUE
     * @uses self::VALUE_WORK_ORDER_COMPLETION
     * @uses self::VALUE_WORK_ORDER_CLOSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ASSEMBLY_BUILD,
            self::VALUE_ASSEMBLY_UNBUILD,
            self::VALUE_BIN_WORKSHEET,
            self::VALUE_CASH_REFUND,
            self::VALUE_CASH_SALE,
            self::VALUE_CREDIT_MEMO,
            self::VALUE_CUSTOMER_PAYMENT,
            self::VALUE_CUSTOMER_REFUND,
            self::VALUE_CUSTOM_PURCHASE,
            self::VALUE_CUSTOM_SALE,
            self::VALUE_DEPOSIT_APPLICATION,
            self::VALUE_ESTIMATE,
            self::VALUE_INVOICE,
            self::VALUE_ITEM_FULFILLMENT,
            self::VALUE_ITEM_RECEIPT,
            self::VALUE_INVENTORY_TRANSFER,
            self::VALUE_PURCHASE_ORDER,
            self::VALUE_RETURN_AUTHORIZATION,
            self::VALUE_SALES_ORDER,
            self::VALUE_VENDOR_BILL,
            self::VALUE_VENDOR_CREDIT,
            self::VALUE_VENDOR_RETURN_AUTHORIZATION,
            self::VALUE_VENDOR_PAYMENT,
            self::VALUE_WORK_ORDER,
            self::VALUE_WORK_ORDER_ISSUE,
            self::VALUE_WORK_ORDER_COMPLETION,
            self::VALUE_WORK_ORDER_CLOSE,
        );
    }
}
