<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InboundShipmentShipmentStatus EnumType
 * @subpackage Enumerations
 */
class InboundShipmentShipmentStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_closed'
     * @return string '_closed'
     */
    const VALUE_CLOSED = '_closed';
    /**
     * Constant for value '_inTransit'
     * @return string '_inTransit'
     */
    const VALUE_IN_TRANSIT = '_inTransit';
    /**
     * Constant for value '_partiallyReceived'
     * @return string '_partiallyReceived'
     */
    const VALUE_PARTIALLY_RECEIVED = '_partiallyReceived';
    /**
     * Constant for value '_received'
     * @return string '_received'
     */
    const VALUE_RECEIVED = '_received';
    /**
     * Constant for value '_toBeShipped'
     * @return string '_toBeShipped'
     */
    const VALUE_TO_BE_SHIPPED = '_toBeShipped';
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_IN_TRANSIT
     * @uses self::VALUE_PARTIALLY_RECEIVED
     * @uses self::VALUE_RECEIVED
     * @uses self::VALUE_TO_BE_SHIPPED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED,
            self::VALUE_IN_TRANSIT,
            self::VALUE_PARTIALLY_RECEIVED,
            self::VALUE_RECEIVED,
            self::VALUE_TO_BE_SHIPPED,
        );
    }
}
