<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AccountType EnumType
 * @subpackage Enumerations
 */
class AccountType extends AbstractStructEnumBase
{
    /**
     * Constant for value '_accountsPayable'
     * @return string '_accountsPayable'
     */
    const VALUE_ACCOUNTS_PAYABLE = '_accountsPayable';
    /**
     * Constant for value '_accountsReceivable'
     * @return string '_accountsReceivable'
     */
    const VALUE_ACCOUNTS_RECEIVABLE = '_accountsReceivable';
    /**
     * Constant for value '_bank'
     * @return string '_bank'
     */
    const VALUE_BANK = '_bank';
    /**
     * Constant for value '_costOfGoodsSold'
     * @return string '_costOfGoodsSold'
     */
    const VALUE_COST_OF_GOODS_SOLD = '_costOfGoodsSold';
    /**
     * Constant for value '_creditCard'
     * @return string '_creditCard'
     */
    const VALUE_CREDIT_CARD = '_creditCard';
    /**
     * Constant for value '_deferredExpense'
     * @return string '_deferredExpense'
     */
    const VALUE_DEFERRED_EXPENSE = '_deferredExpense';
    /**
     * Constant for value '_deferredRevenue'
     * @return string '_deferredRevenue'
     */
    const VALUE_DEFERRED_REVENUE = '_deferredRevenue';
    /**
     * Constant for value '_equity'
     * @return string '_equity'
     */
    const VALUE_EQUITY = '_equity';
    /**
     * Constant for value '_expense'
     * @return string '_expense'
     */
    const VALUE_EXPENSE = '_expense';
    /**
     * Constant for value '_fixedAsset'
     * @return string '_fixedAsset'
     */
    const VALUE_FIXED_ASSET = '_fixedAsset';
    /**
     * Constant for value '_income'
     * @return string '_income'
     */
    const VALUE_INCOME = '_income';
    /**
     * Constant for value '_longTermLiability'
     * @return string '_longTermLiability'
     */
    const VALUE_LONG_TERM_LIABILITY = '_longTermLiability';
    /**
     * Constant for value '_nonPosting'
     * @return string '_nonPosting'
     */
    const VALUE_NON_POSTING = '_nonPosting';
    /**
     * Constant for value '_otherAsset'
     * @return string '_otherAsset'
     */
    const VALUE_OTHER_ASSET = '_otherAsset';
    /**
     * Constant for value '_otherCurrentAsset'
     * @return string '_otherCurrentAsset'
     */
    const VALUE_OTHER_CURRENT_ASSET = '_otherCurrentAsset';
    /**
     * Constant for value '_otherCurrentLiability'
     * @return string '_otherCurrentLiability'
     */
    const VALUE_OTHER_CURRENT_LIABILITY = '_otherCurrentLiability';
    /**
     * Constant for value '_otherExpense'
     * @return string '_otherExpense'
     */
    const VALUE_OTHER_EXPENSE = '_otherExpense';
    /**
     * Constant for value '_otherIncome'
     * @return string '_otherIncome'
     */
    const VALUE_OTHER_INCOME = '_otherIncome';
    /**
     * Constant for value '_statistical'
     * @return string '_statistical'
     */
    const VALUE_STATISTICAL = '_statistical';
    /**
     * Constant for value '_unbilledReceivable'
     * @return string '_unbilledReceivable'
     */
    const VALUE_UNBILLED_RECEIVABLE = '_unbilledReceivable';
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNTS_PAYABLE
     * @uses self::VALUE_ACCOUNTS_RECEIVABLE
     * @uses self::VALUE_BANK
     * @uses self::VALUE_COST_OF_GOODS_SOLD
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_DEFERRED_EXPENSE
     * @uses self::VALUE_DEFERRED_REVENUE
     * @uses self::VALUE_EQUITY
     * @uses self::VALUE_EXPENSE
     * @uses self::VALUE_FIXED_ASSET
     * @uses self::VALUE_INCOME
     * @uses self::VALUE_LONG_TERM_LIABILITY
     * @uses self::VALUE_NON_POSTING
     * @uses self::VALUE_OTHER_ASSET
     * @uses self::VALUE_OTHER_CURRENT_ASSET
     * @uses self::VALUE_OTHER_CURRENT_LIABILITY
     * @uses self::VALUE_OTHER_EXPENSE
     * @uses self::VALUE_OTHER_INCOME
     * @uses self::VALUE_STATISTICAL
     * @uses self::VALUE_UNBILLED_RECEIVABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNTS_PAYABLE,
            self::VALUE_ACCOUNTS_RECEIVABLE,
            self::VALUE_BANK,
            self::VALUE_COST_OF_GOODS_SOLD,
            self::VALUE_CREDIT_CARD,
            self::VALUE_DEFERRED_EXPENSE,
            self::VALUE_DEFERRED_REVENUE,
            self::VALUE_EQUITY,
            self::VALUE_EXPENSE,
            self::VALUE_FIXED_ASSET,
            self::VALUE_INCOME,
            self::VALUE_LONG_TERM_LIABILITY,
            self::VALUE_NON_POSTING,
            self::VALUE_OTHER_ASSET,
            self::VALUE_OTHER_CURRENT_ASSET,
            self::VALUE_OTHER_CURRENT_LIABILITY,
            self::VALUE_OTHER_EXPENSE,
            self::VALUE_OTHER_INCOME,
            self::VALUE_STATISTICAL,
            self::VALUE_UNBILLED_RECEIVABLE,
        );
    }
}
