<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEstadoObjecto StructType
 * @subpackage Structs
 */
class GetEstadoObjecto extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The NObjecto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NObjecto;
    /**
     * Constructor method for GetEstadoObjecto
     * @uses GetEstadoObjecto::setID()
     * @uses GetEstadoObjecto::setNObjecto()
     * @param string $iD
     * @param string $nObjecto
     */
    public function __construct($iD = null, $nObjecto = null)
    {
        $this
            ->setID($iD)
            ->setNObjecto($nObjecto);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \LGRAVE\StructType\GetEstadoObjecto
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get NObjecto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNObjecto()
    {
        return isset($this->NObjecto) ? $this->NObjecto : null;
    }
    /**
     * Set NObjecto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nObjecto
     * @return \LGRAVE\StructType\GetEstadoObjecto
     */
    public function setNObjecto($nObjecto = null)
    {
        // validation for constraint: string
        if (!is_null($nObjecto) && !is_string($nObjecto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nObjecto, true), gettype($nObjecto)), __LINE__);
        }
        if (is_null($nObjecto) || (is_array($nObjecto) && empty($nObjecto))) {
            unset($this->NObjecto);
        } else {
            $this->NObjecto = $nObjecto;
        }
        return $this;
    }
}
