<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obter ServiceType
 * @subpackage Services
 */
class Obter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ObterTodosPontosEntrega
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\ObterTodosPontosEntrega $parameters
     * @return \LGRAVE\StructType\ObterTodosPontosEntregaResponse|bool
     */
    public function ObterTodosPontosEntrega(\LGRAVE\StructType\ObterTodosPontosEntrega $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObterTodosPontosEntrega($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObterDadosPontosEntrega
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\ObterDadosPontosEntrega $parameters
     * @return \LGRAVE\StructType\ObterDadosPontosEntregaResponse|bool
     */
    public function ObterDadosPontosEntrega(\LGRAVE\StructType\ObterDadosPontosEntrega $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObterDadosPontosEntrega($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObterListaPontosEntrega
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\ObterListaPontosEntrega $parameters
     * @return \LGRAVE\StructType\ObterListaPontosEntregaResponse|bool
     */
    public function ObterListaPontosEntrega(\LGRAVE\StructType\ObterListaPontosEntrega $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObterListaPontosEntrega($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ObterListaPontosEntregaComDesignacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\ObterListaPontosEntregaComDesignacao $parameters
     * @return \LGRAVE\StructType\ObterListaPontosEntregaComDesignacaoResponse|bool
     */
    public function ObterListaPontosEntregaComDesignacao(\LGRAVE\StructType\ObterListaPontosEntregaComDesignacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObterListaPontosEntregaComDesignacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObterPontosEntregaInternacionais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\ObterPontosEntregaInternacionais $parameters
     * @return \LGRAVE\StructType\ObterPontosEntregaInternacionaisResponse|bool
     */
    public function ObterPontosEntregaInternacionais(\LGRAVE\StructType\ObterPontosEntregaInternacionais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObterPontosEntregaInternacionais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\ObterDadosPontosEntregaResponse|\LGRAVE\StructType\ObterListaPontosEntregaComDesignacaoResponse|\LGRAVE\StructType\ObterListaPontosEntregaResponse|\LGRAVE\StructType\ObterPontosEntregaInternacionaisResponse|\LGRAVE\StructType\ObterTodosPontosEntregaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
