<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PUDOExtensionOutput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PUDOExtensionOutput
 * @subpackage Structs
 */
class PUDOExtensionOutput extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityType;
    /**
     * The Erros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfstring
     */
    public $Erros;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PudoEntityDesignation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PudoEntityDesignation;
    /**
     * The StateOrProvince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateOrProvince;
    /**
     * The TipoLocalPudo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoLocalPudo;
    /**
     * Constructor method for PUDOExtensionOutput
     * @uses PUDOExtensionOutput::setAddress()
     * @uses PUDOExtensionOutput::setCode()
     * @uses PUDOExtensionOutput::setCountryCode()
     * @uses PUDOExtensionOutput::setDescription()
     * @uses PUDOExtensionOutput::setEntityType()
     * @uses PUDOExtensionOutput::setErros()
     * @uses PUDOExtensionOutput::setPostalCode()
     * @uses PUDOExtensionOutput::setPudoEntityDesignation()
     * @uses PUDOExtensionOutput::setStateOrProvince()
     * @uses PUDOExtensionOutput::setTipoLocalPudo()
     * @param string $address
     * @param string $code
     * @param string $countryCode
     * @param string $description
     * @param int $entityType
     * @param \LGRAVE\ArrayType\ArrayOfstring $erros
     * @param string $postalCode
     * @param string $pudoEntityDesignation
     * @param string $stateOrProvince
     * @param string $tipoLocalPudo
     */
    public function __construct($address = null, $code = null, $countryCode = null, $description = null, $entityType = null, \LGRAVE\ArrayType\ArrayOfstring $erros = null, $postalCode = null, $pudoEntityDesignation = null, $stateOrProvince = null, $tipoLocalPudo = null)
    {
        $this
            ->setAddress($address)
            ->setCode($code)
            ->setCountryCode($countryCode)
            ->setDescription($description)
            ->setEntityType($entityType)
            ->setErros($erros)
            ->setPostalCode($postalCode)
            ->setPudoEntityDesignation($pudoEntityDesignation)
            ->setStateOrProvince($stateOrProvince)
            ->setTipoLocalPudo($tipoLocalPudo);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * @return int|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @param int $entityType
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: int
        if (!is_null($entityType) && !(is_int($entityType) || ctype_digit($entityType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get Erros value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfstring|null
     */
    public function getErros()
    {
        return isset($this->Erros) ? $this->Erros : null;
    }
    /**
     * Set Erros value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfstring $erros
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setErros(\LGRAVE\ArrayType\ArrayOfstring $erros = null)
    {
        if (is_null($erros) || (is_array($erros) && empty($erros))) {
            unset($this->Erros);
        } else {
            $this->Erros = $erros;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get PudoEntityDesignation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPudoEntityDesignation()
    {
        return isset($this->PudoEntityDesignation) ? $this->PudoEntityDesignation : null;
    }
    /**
     * Set PudoEntityDesignation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pudoEntityDesignation
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setPudoEntityDesignation($pudoEntityDesignation = null)
    {
        // validation for constraint: string
        if (!is_null($pudoEntityDesignation) && !is_string($pudoEntityDesignation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pudoEntityDesignation, true), gettype($pudoEntityDesignation)), __LINE__);
        }
        if (is_null($pudoEntityDesignation) || (is_array($pudoEntityDesignation) && empty($pudoEntityDesignation))) {
            unset($this->PudoEntityDesignation);
        } else {
            $this->PudoEntityDesignation = $pudoEntityDesignation;
        }
        return $this;
    }
    /**
     * Get StateOrProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateOrProvince()
    {
        return isset($this->StateOrProvince) ? $this->StateOrProvince : null;
    }
    /**
     * Set StateOrProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateOrProvince
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setStateOrProvince($stateOrProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvince) && !is_string($stateOrProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvince, true), gettype($stateOrProvince)), __LINE__);
        }
        if (is_null($stateOrProvince) || (is_array($stateOrProvince) && empty($stateOrProvince))) {
            unset($this->StateOrProvince);
        } else {
            $this->StateOrProvince = $stateOrProvince;
        }
        return $this;
    }
    /**
     * Get TipoLocalPudo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoLocalPudo()
    {
        return isset($this->TipoLocalPudo) ? $this->TipoLocalPudo : null;
    }
    /**
     * Set TipoLocalPudo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoLocalPudo
     * @return \LGRAVE\StructType\PUDOExtensionOutput
     */
    public function setTipoLocalPudo($tipoLocalPudo = null)
    {
        // validation for constraint: string
        if (!is_null($tipoLocalPudo) && !is_string($tipoLocalPudo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoLocalPudo, true), gettype($tipoLocalPudo)), __LINE__);
        }
        if (is_null($tipoLocalPudo) || (is_array($tipoLocalPudo) && empty($tipoLocalPudo))) {
            unset($this->TipoLocalPudo);
        } else {
            $this->TipoLocalPudo = $tipoLocalPudo;
        }
        return $this;
    }
}
