<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObterDadosPontosEntrega StructType
 * @subpackage Structs
 */
class ObterDadosPontosEntrega extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The parametros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parametros;
    /**
     * Constructor method for ObterDadosPontosEntrega
     * @uses ObterDadosPontosEntrega::setID()
     * @uses ObterDadosPontosEntrega::setParametros()
     * @param string $iD
     * @param string $parametros
     */
    public function __construct($iD = null, $parametros = null)
    {
        $this
            ->setID($iD)
            ->setParametros($parametros);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \LGRAVE\StructType\ObterDadosPontosEntrega
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get parametros value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParametros()
    {
        return isset($this->parametros) ? $this->parametros : null;
    }
    /**
     * Set parametros value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parametros
     * @return \LGRAVE\StructType\ObterDadosPontosEntrega
     */
    public function setParametros($parametros = null)
    {
        // validation for constraint: string
        if (!is_null($parametros) && !is_string($parametros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parametros, true), gettype($parametros)), __LINE__);
        }
        if (is_null($parametros) || (is_array($parametros) && empty($parametros))) {
            unset($this->parametros);
        } else {
            $this->parametros = $parametros;
        }
        return $this;
    }
}
