<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCurrrencyList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetCurrrencyList $parameters
     * @return \LGRAVE\StructType\GetCurrrencyListResponse|bool
     */
    public function GetCurrrencyList(\LGRAVE\StructType\GetCurrrencyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrrencyList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPudoType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetPudoType $parameters
     * @return \LGRAVE\StructType\GetPudoTypeResponse|bool
     */
    public function GetPudoType(\LGRAVE\StructType\GetPudoType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPudoType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductCodesByPrefix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetProductCodesByPrefix $parameters
     * @return \LGRAVE\StructType\GetProductCodesByPrefixResponse|bool
     */
    public function GetProductCodesByPrefix(\LGRAVE\StructType\GetProductCodesByPrefix $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductCodesByPrefix($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\GetCurrrencyListResponse|\LGRAVE\StructType\GetProductCodesByPrefixResponse|\LGRAVE\StructType\GetPudoTypeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
