<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://cttexpressows.qa.ctt.pt/CTTEWSPool/ReferenciasWS.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://cttexpressows.qa.ctt.pt/CTTEWSPool/ReferenciasWS.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LGRAVE\ClassMap::get(),
);
/**
 * Samples for Obter ServiceType
 */
$obter = new \LGRAVE\ServiceType\Obter($options);
/**
 * Sample call for ObterTodosPontosEntrega operation/method
 */
if ($obter->ObterTodosPontosEntrega(new \LGRAVE\StructType\ObterTodosPontosEntrega()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for ObterDadosPontosEntrega operation/method
 */
if ($obter->ObterDadosPontosEntrega(new \LGRAVE\StructType\ObterDadosPontosEntrega()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for ObterListaPontosEntrega operation/method
 */
if ($obter->ObterListaPontosEntrega(new \LGRAVE\StructType\ObterListaPontosEntrega()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for ObterListaPontosEntregaComDesignacao operation/method
 */
if ($obter->ObterListaPontosEntregaComDesignacao(new \LGRAVE\StructType\ObterListaPontosEntregaComDesignacao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for ObterPontosEntregaInternacionais operation/method
 */
if ($obter->ObterPontosEntregaInternacionais(new \LGRAVE\StructType\ObterPontosEntregaInternacionais()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \LGRAVE\ServiceType\Get($options);
/**
 * Sample call for GetCurrrencyList operation/method
 */
if ($get->GetCurrrencyList(new \LGRAVE\StructType\GetCurrrencyList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPudoType operation/method
 */
if ($get->GetPudoType(new \LGRAVE\StructType\GetPudoType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductCodesByPrefix operation/method
 */
if ($get->GetProductCodesByPrefix(new \LGRAVE\StructType\GetProductCodesByPrefix()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
