<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewOfferPickUpInput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NewOfferPickUpInput
 * @subpackage Structs
 */
class NewOfferPickUpInput extends AbstractStructBase
{
    /**
     * The AuthenticationID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AuthenticationID;
    /**
     * The PickUpData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\StructType\PickUpData
     */
    public $PickUpData;
    /**
     * Constructor method for NewOfferPickUpInput
     * @uses NewOfferPickUpInput::setAuthenticationID()
     * @uses NewOfferPickUpInput::setPickUpData()
     * @param string $authenticationID
     * @param \LGRAVE\StructType\PickUpData $pickUpData
     */
    public function __construct($authenticationID = null, \LGRAVE\StructType\PickUpData $pickUpData = null)
    {
        $this
            ->setAuthenticationID($authenticationID)
            ->setPickUpData($pickUpData);
    }
    /**
     * Get AuthenticationID value
     * @return string|null
     */
    public function getAuthenticationID()
    {
        return $this->AuthenticationID;
    }
    /**
     * Set AuthenticationID value
     * @param string $authenticationID
     * @return \LGRAVE\StructType\NewOfferPickUpInput
     */
    public function setAuthenticationID($authenticationID = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationID) && !is_string($authenticationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationID, true), gettype($authenticationID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($authenticationID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $authenticationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($authenticationID, true)), __LINE__);
        }
        $this->AuthenticationID = $authenticationID;
        return $this;
    }
    /**
     * Get PickUpData value
     * @return \LGRAVE\StructType\PickUpData|null
     */
    public function getPickUpData()
    {
        return $this->PickUpData;
    }
    /**
     * Set PickUpData value
     * @param \LGRAVE\StructType\PickUpData $pickUpData
     * @return \LGRAVE\StructType\NewOfferPickUpInput
     */
    public function setPickUpData(\LGRAVE\StructType\PickUpData $pickUpData = null)
    {
        $this->PickUpData = $pickUpData;
        return $this;
    }
}
