<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewOfferPickUpByPreAvisoOutput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NewOfferPickUpByPreAvisoOutput
 * @subpackage Structs
 */
class NewOfferPickUpByPreAvisoOutput extends AbstractStructBase
{
    /**
     * The DocumentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfDocumentData
     */
    public $DocumentList;
    /**
     * The ErrorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfErrorData
     */
    public $ErrorList;
    /**
     * The NewPickUpDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewPickUpDate;
    /**
     * The PickUpID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickUpID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for NewOfferPickUpByPreAvisoOutput
     * @uses NewOfferPickUpByPreAvisoOutput::setDocumentList()
     * @uses NewOfferPickUpByPreAvisoOutput::setErrorList()
     * @uses NewOfferPickUpByPreAvisoOutput::setNewPickUpDate()
     * @uses NewOfferPickUpByPreAvisoOutput::setPickUpID()
     * @uses NewOfferPickUpByPreAvisoOutput::setStatus()
     * @param \LGRAVE\ArrayType\ArrayOfDocumentData $documentList
     * @param \LGRAVE\ArrayType\ArrayOfErrorData $errorList
     * @param string $newPickUpDate
     * @param string $pickUpID
     * @param string $status
     */
    public function __construct(\LGRAVE\ArrayType\ArrayOfDocumentData $documentList = null, \LGRAVE\ArrayType\ArrayOfErrorData $errorList = null, $newPickUpDate = null, $pickUpID = null, $status = null)
    {
        $this
            ->setDocumentList($documentList)
            ->setErrorList($errorList)
            ->setNewPickUpDate($newPickUpDate)
            ->setPickUpID($pickUpID)
            ->setStatus($status);
    }
    /**
     * Get DocumentList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfDocumentData|null
     */
    public function getDocumentList()
    {
        return isset($this->DocumentList) ? $this->DocumentList : null;
    }
    /**
     * Set DocumentList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfDocumentData $documentList
     * @return \LGRAVE\StructType\NewOfferPickUpByPreAvisoOutput
     */
    public function setDocumentList(\LGRAVE\ArrayType\ArrayOfDocumentData $documentList = null)
    {
        if (is_null($documentList) || (is_array($documentList) && empty($documentList))) {
            unset($this->DocumentList);
        } else {
            $this->DocumentList = $documentList;
        }
        return $this;
    }
    /**
     * Get ErrorList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfErrorData|null
     */
    public function getErrorList()
    {
        return isset($this->ErrorList) ? $this->ErrorList : null;
    }
    /**
     * Set ErrorList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfErrorData $errorList
     * @return \LGRAVE\StructType\NewOfferPickUpByPreAvisoOutput
     */
    public function setErrorList(\LGRAVE\ArrayType\ArrayOfErrorData $errorList = null)
    {
        if (is_null($errorList) || (is_array($errorList) && empty($errorList))) {
            unset($this->ErrorList);
        } else {
            $this->ErrorList = $errorList;
        }
        return $this;
    }
    /**
     * Get NewPickUpDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPickUpDate()
    {
        return isset($this->NewPickUpDate) ? $this->NewPickUpDate : null;
    }
    /**
     * Set NewPickUpDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPickUpDate
     * @return \LGRAVE\StructType\NewOfferPickUpByPreAvisoOutput
     */
    public function setNewPickUpDate($newPickUpDate = null)
    {
        // validation for constraint: string
        if (!is_null($newPickUpDate) && !is_string($newPickUpDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPickUpDate, true), gettype($newPickUpDate)), __LINE__);
        }
        if (is_null($newPickUpDate) || (is_array($newPickUpDate) && empty($newPickUpDate))) {
            unset($this->NewPickUpDate);
        } else {
            $this->NewPickUpDate = $newPickUpDate;
        }
        return $this;
    }
    /**
     * Get PickUpID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickUpID()
    {
        return isset($this->PickUpID) ? $this->PickUpID : null;
    }
    /**
     * Set PickUpID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickUpID
     * @return \LGRAVE\StructType\NewOfferPickUpByPreAvisoOutput
     */
    public function setPickUpID($pickUpID = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpID) && !is_string($pickUpID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpID, true), gettype($pickUpID)), __LINE__);
        }
        if (is_null($pickUpID) || (is_array($pickUpID) && empty($pickUpID))) {
            unset($this->PickUpID);
        } else {
            $this->PickUpID = $pickUpID;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \LGRAVE\EnumType\StatusValues::valueIsValid()
     * @uses \LGRAVE\EnumType\StatusValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \LGRAVE\StructType\NewOfferPickUpByPreAvisoOutput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\LGRAVE\EnumType\StatusValues::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LGRAVE\EnumType\StatusValues', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \LGRAVE\EnumType\StatusValues::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
