<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://cttexpressows.qa.ctt.pt/CTTEWSPool/RecolhasWS.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://cttexpressows.qa.ctt.pt/CTTEWSPool/RecolhasWS.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LGRAVE\ClassMap::get(),
);
/**
 * Samples for Marcar ServiceType
 */
$marcar = new \LGRAVE\ServiceType\Marcar($options);
/**
 * Sample call for MarcarRecolha operation/method
 */
if ($marcar->MarcarRecolha(new \LGRAVE\StructType\MarcarRecolha()) !== false) {
    print_r($marcar->getResult());
} else {
    print_r($marcar->getLastError());
}
/**
 * Samples for Pesquisa ServiceType
 */
$pesquisa = new \LGRAVE\ServiceType\Pesquisa($options);
/**
 * Sample call for PesquisaRecolhas operation/method
 */
if ($pesquisa->PesquisaRecolhas(new \LGRAVE\StructType\PesquisaRecolhas()) !== false) {
    print_r($pesquisa->getResult());
} else {
    print_r($pesquisa->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \LGRAVE\ServiceType\Get($options);
/**
 * Sample call for GetRecolha operation/method
 */
if ($get->GetRecolha(new \LGRAVE\StructType\GetRecolha()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProdutosRecolha operation/method
 */
if ($get->GetProdutosRecolha(new \LGRAVE\StructType\GetProdutosRecolha()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEstadosRecolha operation/method
 */
if ($get->GetEstadosRecolha(new \LGRAVE\StructType\GetEstadosRecolha()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAreaInfluencia operation/method
 */
if ($get->GetAreaInfluencia(new \LGRAVE\StructType\GetAreaInfluencia()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZonaTaxacao operation/method
 */
if ($get->GetZonaTaxacao(new \LGRAVE\StructType\GetZonaTaxacao()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for New ServiceType
 */
$new = new \LGRAVE\ServiceType\_New($options);
/**
 * Sample call for NewOfferPickUp operation/method
 */
if ($new->NewOfferPickUp(new \LGRAVE\StructType\NewOfferPickUp()) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Sample call for NewOfferPickUpByPreAviso operation/method
 */
if ($new->NewOfferPickUpByPreAviso(new \LGRAVE\StructType\NewOfferPickUpByPreAviso()) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Samples for Complete ServiceType
 */
$complete = new \LGRAVE\ServiceType\Complete($options);
/**
 * Sample call for CompletePickUp operation/method
 */
if ($complete->CompletePickUp(new \LGRAVE\StructType\CompletePickUp()) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
