<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeWindowData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TimeWindowData
 * @subpackage Structs
 */
class TimeWindowData extends AbstractStructBase
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The TimeWindow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeWindow;
    /**
     * Constructor method for TimeWindowData
     * @uses TimeWindowData::setDeliveryDate()
     * @uses TimeWindowData::setTimeWindow()
     * @param string $deliveryDate
     * @param string $timeWindow
     */
    public function __construct($deliveryDate = null, $timeWindow = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setTimeWindow($timeWindow);
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \LGRAVE\StructType\TimeWindowData
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get TimeWindow value
     * @return string|null
     */
    public function getTimeWindow()
    {
        return $this->TimeWindow;
    }
    /**
     * Set TimeWindow value
     * @uses \LGRAVE\EnumType\TimeWindowValues::valueIsValid()
     * @uses \LGRAVE\EnumType\TimeWindowValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeWindow
     * @return \LGRAVE\StructType\TimeWindowData
     */
    public function setTimeWindow($timeWindow = null)
    {
        // validation for constraint: enumeration
        if (!\LGRAVE\EnumType\TimeWindowValues::valueIsValid($timeWindow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LGRAVE\EnumType\TimeWindowValues', is_array($timeWindow) ? implode(', ', $timeWindow) : var_export($timeWindow, true), implode(', ', \LGRAVE\EnumType\TimeWindowValues::getValidValues())), __LINE__);
        }
        $this->TimeWindow = $timeWindow;
        return $this;
    }
}
