<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentToPickUp StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentToPickUp
 * @subpackage Structs
 */
class ShipmentToPickUp extends AbstractStructBase
{
    /**
     * The ObjectNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ObjectNumber;
    /**
     * The ShipmentNumber
     * @var int
     */
    public $ShipmentNumber;
    /**
     * Constructor method for ShipmentToPickUp
     * @uses ShipmentToPickUp::setObjectNumber()
     * @uses ShipmentToPickUp::setShipmentNumber()
     * @param string $objectNumber
     * @param int $shipmentNumber
     */
    public function __construct($objectNumber = null, $shipmentNumber = null)
    {
        $this
            ->setObjectNumber($objectNumber)
            ->setShipmentNumber($shipmentNumber);
    }
    /**
     * Get ObjectNumber value
     * @return string|null
     */
    public function getObjectNumber()
    {
        return $this->ObjectNumber;
    }
    /**
     * Set ObjectNumber value
     * @param string $objectNumber
     * @return \LGRAVE\StructType\ShipmentToPickUp
     */
    public function setObjectNumber($objectNumber = null)
    {
        // validation for constraint: string
        if (!is_null($objectNumber) && !is_string($objectNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectNumber, true), gettype($objectNumber)), __LINE__);
        }
        $this->ObjectNumber = $objectNumber;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return int|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param int $shipmentNumber
     * @return \LGRAVE\StructType\ShipmentToPickUp
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentNumber) && !(is_int($shipmentNumber) || ctype_digit($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
}
