<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentCTT StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentCTT
 * @subpackage Structs
 */
class ShipmentCTT extends AbstractStructBase
{
    /**
     * The DeliveryAgregation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\StructType\DeliveryAggregationInf
     */
    public $DeliveryAgregation;
    /**
     * The ExtData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtData;
    /**
     * The HasSenderInformation
     * @var bool
     */
    public $HasSenderInformation;
    /**
     * The PIPAuthorization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfPIPAuthorizationData
     */
    public $PIPAuthorization;
    /**
     * The ReceiverData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\StructType\AddressData
     */
    public $ReceiverData;
    /**
     * The SenderData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\StructType\AddressData
     */
    public $SenderData;
    /**
     * The ShipmentData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\StructType\ShipmentData
     */
    public $ShipmentData;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * Constructor method for ShipmentCTT
     * @uses ShipmentCTT::setDeliveryAgregation()
     * @uses ShipmentCTT::setExtData()
     * @uses ShipmentCTT::setHasSenderInformation()
     * @uses ShipmentCTT::setPIPAuthorization()
     * @uses ShipmentCTT::setReceiverData()
     * @uses ShipmentCTT::setSenderData()
     * @uses ShipmentCTT::setShipmentData()
     * @uses ShipmentCTT::setSpecialServices()
     * @param \LGRAVE\StructType\DeliveryAggregationInf $deliveryAgregation
     * @param string $extData
     * @param bool $hasSenderInformation
     * @param \LGRAVE\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization
     * @param \LGRAVE\StructType\AddressData $receiverData
     * @param \LGRAVE\StructType\AddressData $senderData
     * @param \LGRAVE\StructType\ShipmentData $shipmentData
     * @param \LGRAVE\ArrayType\ArrayOfSpecialService $specialServices
     */
    public function __construct(\LGRAVE\StructType\DeliveryAggregationInf $deliveryAgregation = null, $extData = null, $hasSenderInformation = null, \LGRAVE\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization = null, \LGRAVE\StructType\AddressData $receiverData = null, \LGRAVE\StructType\AddressData $senderData = null, \LGRAVE\StructType\ShipmentData $shipmentData = null, \LGRAVE\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this
            ->setDeliveryAgregation($deliveryAgregation)
            ->setExtData($extData)
            ->setHasSenderInformation($hasSenderInformation)
            ->setPIPAuthorization($pIPAuthorization)
            ->setReceiverData($receiverData)
            ->setSenderData($senderData)
            ->setShipmentData($shipmentData)
            ->setSpecialServices($specialServices);
    }
    /**
     * Get DeliveryAgregation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\StructType\DeliveryAggregationInf|null
     */
    public function getDeliveryAgregation()
    {
        return isset($this->DeliveryAgregation) ? $this->DeliveryAgregation : null;
    }
    /**
     * Set DeliveryAgregation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\StructType\DeliveryAggregationInf $deliveryAgregation
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setDeliveryAgregation(\LGRAVE\StructType\DeliveryAggregationInf $deliveryAgregation = null)
    {
        if (is_null($deliveryAgregation) || (is_array($deliveryAgregation) && empty($deliveryAgregation))) {
            unset($this->DeliveryAgregation);
        } else {
            $this->DeliveryAgregation = $deliveryAgregation;
        }
        return $this;
    }
    /**
     * Get ExtData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtData()
    {
        return isset($this->ExtData) ? $this->ExtData : null;
    }
    /**
     * Set ExtData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extData
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setExtData($extData = null)
    {
        // validation for constraint: string
        if (!is_null($extData) && !is_string($extData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extData, true), gettype($extData)), __LINE__);
        }
        if (is_null($extData) || (is_array($extData) && empty($extData))) {
            unset($this->ExtData);
        } else {
            $this->ExtData = $extData;
        }
        return $this;
    }
    /**
     * Get HasSenderInformation value
     * @return bool|null
     */
    public function getHasSenderInformation()
    {
        return $this->HasSenderInformation;
    }
    /**
     * Set HasSenderInformation value
     * @param bool $hasSenderInformation
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setHasSenderInformation($hasSenderInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSenderInformation) && !is_bool($hasSenderInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSenderInformation, true), gettype($hasSenderInformation)), __LINE__);
        }
        $this->HasSenderInformation = $hasSenderInformation;
        return $this;
    }
    /**
     * Get PIPAuthorization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfPIPAuthorizationData|null
     */
    public function getPIPAuthorization()
    {
        return isset($this->PIPAuthorization) ? $this->PIPAuthorization : null;
    }
    /**
     * Set PIPAuthorization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setPIPAuthorization(\LGRAVE\ArrayType\ArrayOfPIPAuthorizationData $pIPAuthorization = null)
    {
        if (is_null($pIPAuthorization) || (is_array($pIPAuthorization) && empty($pIPAuthorization))) {
            unset($this->PIPAuthorization);
        } else {
            $this->PIPAuthorization = $pIPAuthorization;
        }
        return $this;
    }
    /**
     * Get ReceiverData value
     * @return \LGRAVE\StructType\AddressData|null
     */
    public function getReceiverData()
    {
        return $this->ReceiverData;
    }
    /**
     * Set ReceiverData value
     * @param \LGRAVE\StructType\AddressData $receiverData
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setReceiverData(\LGRAVE\StructType\AddressData $receiverData = null)
    {
        $this->ReceiverData = $receiverData;
        return $this;
    }
    /**
     * Get SenderData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\StructType\AddressData|null
     */
    public function getSenderData()
    {
        return isset($this->SenderData) ? $this->SenderData : null;
    }
    /**
     * Set SenderData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\StructType\AddressData $senderData
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setSenderData(\LGRAVE\StructType\AddressData $senderData = null)
    {
        if (is_null($senderData) || (is_array($senderData) && empty($senderData))) {
            unset($this->SenderData);
        } else {
            $this->SenderData = $senderData;
        }
        return $this;
    }
    /**
     * Get ShipmentData value
     * @return \LGRAVE\StructType\ShipmentData|null
     */
    public function getShipmentData()
    {
        return $this->ShipmentData;
    }
    /**
     * Set ShipmentData value
     * @param \LGRAVE\StructType\ShipmentData $shipmentData
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setShipmentData(\LGRAVE\StructType\ShipmentData $shipmentData = null)
    {
        $this->ShipmentData = $shipmentData;
        return $this;
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfSpecialService $specialServices
     * @return \LGRAVE\StructType\ShipmentCTT
     */
    public function setSpecialServices(\LGRAVE\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
}
