<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultipleHomeDeliveryData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MultipleHomeDeliveryData
 * @subpackage Structs
 */
class MultipleHomeDeliveryData extends AbstractStructBase
{
    /**
     * The AttemptsNumber
     * @var int
     */
    public $AttemptsNumber;
    /**
     * The InNonDeliveryCase
     * @var string
     */
    public $InNonDeliveryCase;
    /**
     * The SecondDeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\StructType\AddressData
     */
    public $SecondDeliveryAddress;
    /**
     * The SecondDeliveryPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\StructType\DeliveryPointData
     */
    public $SecondDeliveryPoint;
    /**
     * Constructor method for MultipleHomeDeliveryData
     * @uses MultipleHomeDeliveryData::setAttemptsNumber()
     * @uses MultipleHomeDeliveryData::setInNonDeliveryCase()
     * @uses MultipleHomeDeliveryData::setSecondDeliveryAddress()
     * @uses MultipleHomeDeliveryData::setSecondDeliveryPoint()
     * @param int $attemptsNumber
     * @param string $inNonDeliveryCase
     * @param \LGRAVE\StructType\AddressData $secondDeliveryAddress
     * @param \LGRAVE\StructType\DeliveryPointData $secondDeliveryPoint
     */
    public function __construct($attemptsNumber = null, $inNonDeliveryCase = null, \LGRAVE\StructType\AddressData $secondDeliveryAddress = null, \LGRAVE\StructType\DeliveryPointData $secondDeliveryPoint = null)
    {
        $this
            ->setAttemptsNumber($attemptsNumber)
            ->setInNonDeliveryCase($inNonDeliveryCase)
            ->setSecondDeliveryAddress($secondDeliveryAddress)
            ->setSecondDeliveryPoint($secondDeliveryPoint);
    }
    /**
     * Get AttemptsNumber value
     * @return int|null
     */
    public function getAttemptsNumber()
    {
        return $this->AttemptsNumber;
    }
    /**
     * Set AttemptsNumber value
     * @param int $attemptsNumber
     * @return \LGRAVE\StructType\MultipleHomeDeliveryData
     */
    public function setAttemptsNumber($attemptsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($attemptsNumber) && !(is_int($attemptsNumber) || ctype_digit($attemptsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attemptsNumber, true), gettype($attemptsNumber)), __LINE__);
        }
        $this->AttemptsNumber = $attemptsNumber;
        return $this;
    }
    /**
     * Get InNonDeliveryCase value
     * @return string|null
     */
    public function getInNonDeliveryCase()
    {
        return $this->InNonDeliveryCase;
    }
    /**
     * Set InNonDeliveryCase value
     * @uses \LGRAVE\EnumType\InNonDeliveryCaseTypeValues::valueIsValid()
     * @uses \LGRAVE\EnumType\InNonDeliveryCaseTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inNonDeliveryCase
     * @return \LGRAVE\StructType\MultipleHomeDeliveryData
     */
    public function setInNonDeliveryCase($inNonDeliveryCase = null)
    {
        // validation for constraint: enumeration
        if (!\LGRAVE\EnumType\InNonDeliveryCaseTypeValues::valueIsValid($inNonDeliveryCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LGRAVE\EnumType\InNonDeliveryCaseTypeValues', is_array($inNonDeliveryCase) ? implode(', ', $inNonDeliveryCase) : var_export($inNonDeliveryCase, true), implode(', ', \LGRAVE\EnumType\InNonDeliveryCaseTypeValues::getValidValues())), __LINE__);
        }
        $this->InNonDeliveryCase = $inNonDeliveryCase;
        return $this;
    }
    /**
     * Get SecondDeliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\StructType\AddressData|null
     */
    public function getSecondDeliveryAddress()
    {
        return isset($this->SecondDeliveryAddress) ? $this->SecondDeliveryAddress : null;
    }
    /**
     * Set SecondDeliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\StructType\AddressData $secondDeliveryAddress
     * @return \LGRAVE\StructType\MultipleHomeDeliveryData
     */
    public function setSecondDeliveryAddress(\LGRAVE\StructType\AddressData $secondDeliveryAddress = null)
    {
        if (is_null($secondDeliveryAddress) || (is_array($secondDeliveryAddress) && empty($secondDeliveryAddress))) {
            unset($this->SecondDeliveryAddress);
        } else {
            $this->SecondDeliveryAddress = $secondDeliveryAddress;
        }
        return $this;
    }
    /**
     * Get SecondDeliveryPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\StructType\DeliveryPointData|null
     */
    public function getSecondDeliveryPoint()
    {
        return isset($this->SecondDeliveryPoint) ? $this->SecondDeliveryPoint : null;
    }
    /**
     * Set SecondDeliveryPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\StructType\DeliveryPointData $secondDeliveryPoint
     * @return \LGRAVE\StructType\MultipleHomeDeliveryData
     */
    public function setSecondDeliveryPoint(\LGRAVE\StructType\DeliveryPointData $secondDeliveryPoint = null)
    {
        if (is_null($secondDeliveryPoint) || (is_array($secondDeliveryPoint) && empty($secondDeliveryPoint))) {
            unset($this->SecondDeliveryPoint);
        } else {
            $this->SecondDeliveryPoint = $secondDeliveryPoint;
        }
        return $this;
    }
}
