<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryNote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryNote
 * @subpackage Structs
 */
class DeliveryNote extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ClientId;
    /**
     * The ContractId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContractId;
    /**
     * The DistributionChannelId
     * @var int
     */
    public $DistributionChannelId;
    /**
     * The ExtData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtData;
    /**
     * The ShipmentCTT
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfShipmentCTT
     */
    public $ShipmentCTT;
    /**
     * The SubProductId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SubProductId;
    /**
     * Constructor method for DeliveryNote
     * @uses DeliveryNote::setClientId()
     * @uses DeliveryNote::setContractId()
     * @uses DeliveryNote::setDistributionChannelId()
     * @uses DeliveryNote::setExtData()
     * @uses DeliveryNote::setShipmentCTT()
     * @uses DeliveryNote::setSubProductId()
     * @param string $clientId
     * @param string $contractId
     * @param int $distributionChannelId
     * @param string $extData
     * @param \LGRAVE\ArrayType\ArrayOfShipmentCTT $shipmentCTT
     * @param string $subProductId
     */
    public function __construct($clientId = null, $contractId = null, $distributionChannelId = null, $extData = null, \LGRAVE\ArrayType\ArrayOfShipmentCTT $shipmentCTT = null, $subProductId = null)
    {
        $this
            ->setClientId($clientId)
            ->setContractId($contractId)
            ->setDistributionChannelId($distributionChannelId)
            ->setExtData($extData)
            ->setShipmentCTT($shipmentCTT)
            ->setSubProductId($subProductId);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \LGRAVE\StructType\DeliveryNote
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get ContractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->ContractId;
    }
    /**
     * Set ContractId value
     * @param string $contractId
     * @return \LGRAVE\StructType\DeliveryNote
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractId, true), gettype($contractId)), __LINE__);
        }
        $this->ContractId = $contractId;
        return $this;
    }
    /**
     * Get DistributionChannelId value
     * @return int|null
     */
    public function getDistributionChannelId()
    {
        return $this->DistributionChannelId;
    }
    /**
     * Set DistributionChannelId value
     * @param int $distributionChannelId
     * @return \LGRAVE\StructType\DeliveryNote
     */
    public function setDistributionChannelId($distributionChannelId = null)
    {
        // validation for constraint: int
        if (!is_null($distributionChannelId) && !(is_int($distributionChannelId) || ctype_digit($distributionChannelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distributionChannelId, true), gettype($distributionChannelId)), __LINE__);
        }
        $this->DistributionChannelId = $distributionChannelId;
        return $this;
    }
    /**
     * Get ExtData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtData()
    {
        return isset($this->ExtData) ? $this->ExtData : null;
    }
    /**
     * Set ExtData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extData
     * @return \LGRAVE\StructType\DeliveryNote
     */
    public function setExtData($extData = null)
    {
        // validation for constraint: string
        if (!is_null($extData) && !is_string($extData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extData, true), gettype($extData)), __LINE__);
        }
        if (is_null($extData) || (is_array($extData) && empty($extData))) {
            unset($this->ExtData);
        } else {
            $this->ExtData = $extData;
        }
        return $this;
    }
    /**
     * Get ShipmentCTT value
     * @return \LGRAVE\ArrayType\ArrayOfShipmentCTT|null
     */
    public function getShipmentCTT()
    {
        return $this->ShipmentCTT;
    }
    /**
     * Set ShipmentCTT value
     * @param \LGRAVE\ArrayType\ArrayOfShipmentCTT $shipmentCTT
     * @return \LGRAVE\StructType\DeliveryNote
     */
    public function setShipmentCTT(\LGRAVE\ArrayType\ArrayOfShipmentCTT $shipmentCTT = null)
    {
        $this->ShipmentCTT = $shipmentCTT;
        return $this;
    }
    /**
     * Get SubProductId value
     * @return string|null
     */
    public function getSubProductId()
    {
        return $this->SubProductId;
    }
    /**
     * Set SubProductId value
     * @param string $subProductId
     * @return \LGRAVE\StructType\DeliveryNote
     */
    public function setSubProductId($subProductId = null)
    {
        // validation for constraint: string
        if (!is_null($subProductId) && !is_string($subProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subProductId, true), gettype($subProductId)), __LINE__);
        }
        $this->SubProductId = $subProductId;
        return $this;
    }
}
