<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletePickUpOutput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CompletePickUpOutput
 * @subpackage Structs
 */
class CompletePickUpOutput extends AbstractStructBase
{
    /**
     * The ErrorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfErrorData
     */
    public $ErrorList;
    /**
     * The NewPickUpDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewPickUpDate;
    /**
     * The PickUpID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickUpID;
    /**
     * The ShipmentToPickUp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfShipmentToPickUp
     */
    public $ShipmentToPickUp;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for CompletePickUpOutput
     * @uses CompletePickUpOutput::setErrorList()
     * @uses CompletePickUpOutput::setNewPickUpDate()
     * @uses CompletePickUpOutput::setPickUpID()
     * @uses CompletePickUpOutput::setShipmentToPickUp()
     * @uses CompletePickUpOutput::setStatus()
     * @param \LGRAVE\ArrayType\ArrayOfErrorData $errorList
     * @param string $newPickUpDate
     * @param string $pickUpID
     * @param \LGRAVE\ArrayType\ArrayOfShipmentToPickUp $shipmentToPickUp
     * @param string $status
     */
    public function __construct(\LGRAVE\ArrayType\ArrayOfErrorData $errorList = null, $newPickUpDate = null, $pickUpID = null, \LGRAVE\ArrayType\ArrayOfShipmentToPickUp $shipmentToPickUp = null, $status = null)
    {
        $this
            ->setErrorList($errorList)
            ->setNewPickUpDate($newPickUpDate)
            ->setPickUpID($pickUpID)
            ->setShipmentToPickUp($shipmentToPickUp)
            ->setStatus($status);
    }
    /**
     * Get ErrorList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfErrorData|null
     */
    public function getErrorList()
    {
        return isset($this->ErrorList) ? $this->ErrorList : null;
    }
    /**
     * Set ErrorList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfErrorData $errorList
     * @return \LGRAVE\StructType\CompletePickUpOutput
     */
    public function setErrorList(\LGRAVE\ArrayType\ArrayOfErrorData $errorList = null)
    {
        if (is_null($errorList) || (is_array($errorList) && empty($errorList))) {
            unset($this->ErrorList);
        } else {
            $this->ErrorList = $errorList;
        }
        return $this;
    }
    /**
     * Get NewPickUpDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPickUpDate()
    {
        return isset($this->NewPickUpDate) ? $this->NewPickUpDate : null;
    }
    /**
     * Set NewPickUpDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPickUpDate
     * @return \LGRAVE\StructType\CompletePickUpOutput
     */
    public function setNewPickUpDate($newPickUpDate = null)
    {
        // validation for constraint: string
        if (!is_null($newPickUpDate) && !is_string($newPickUpDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPickUpDate, true), gettype($newPickUpDate)), __LINE__);
        }
        if (is_null($newPickUpDate) || (is_array($newPickUpDate) && empty($newPickUpDate))) {
            unset($this->NewPickUpDate);
        } else {
            $this->NewPickUpDate = $newPickUpDate;
        }
        return $this;
    }
    /**
     * Get PickUpID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickUpID()
    {
        return isset($this->PickUpID) ? $this->PickUpID : null;
    }
    /**
     * Set PickUpID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickUpID
     * @return \LGRAVE\StructType\CompletePickUpOutput
     */
    public function setPickUpID($pickUpID = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpID) && !is_string($pickUpID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpID, true), gettype($pickUpID)), __LINE__);
        }
        if (is_null($pickUpID) || (is_array($pickUpID) && empty($pickUpID))) {
            unset($this->PickUpID);
        } else {
            $this->PickUpID = $pickUpID;
        }
        return $this;
    }
    /**
     * Get ShipmentToPickUp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfShipmentToPickUp|null
     */
    public function getShipmentToPickUp()
    {
        return isset($this->ShipmentToPickUp) ? $this->ShipmentToPickUp : null;
    }
    /**
     * Set ShipmentToPickUp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfShipmentToPickUp $shipmentToPickUp
     * @return \LGRAVE\StructType\CompletePickUpOutput
     */
    public function setShipmentToPickUp(\LGRAVE\ArrayType\ArrayOfShipmentToPickUp $shipmentToPickUp = null)
    {
        if (is_null($shipmentToPickUp) || (is_array($shipmentToPickUp) && empty($shipmentToPickUp))) {
            unset($this->ShipmentToPickUp);
        } else {
            $this->ShipmentToPickUp = $shipmentToPickUp;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \LGRAVE\EnumType\StatusValues::valueIsValid()
     * @uses \LGRAVE\EnumType\StatusValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \LGRAVE\StructType\CompletePickUpOutput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\LGRAVE\EnumType\StatusValues::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LGRAVE\EnumType\StatusValues', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \LGRAVE\EnumType\StatusValues::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
