<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletePickUpInput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CompletePickUpInput
 * @subpackage Structs
 */
class CompletePickUpInput extends AbstractStructBase
{
    /**
     * The AuthenticationID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AuthenticationID;
    /**
     * The DeliveryNotes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfDeliveryNote
     */
    public $DeliveryNotes;
    /**
     * The PickUpModel
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\StructType\PickUpModel
     */
    public $PickUpModel;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserID;
    /**
     * Constructor method for CompletePickUpInput
     * @uses CompletePickUpInput::setAuthenticationID()
     * @uses CompletePickUpInput::setDeliveryNotes()
     * @uses CompletePickUpInput::setPickUpModel()
     * @uses CompletePickUpInput::setRequestID()
     * @uses CompletePickUpInput::setUserID()
     * @param string $authenticationID
     * @param \LGRAVE\ArrayType\ArrayOfDeliveryNote $deliveryNotes
     * @param \LGRAVE\StructType\PickUpModel $pickUpModel
     * @param string $requestID
     * @param string $userID
     */
    public function __construct($authenticationID = null, \LGRAVE\ArrayType\ArrayOfDeliveryNote $deliveryNotes = null, \LGRAVE\StructType\PickUpModel $pickUpModel = null, $requestID = null, $userID = null)
    {
        $this
            ->setAuthenticationID($authenticationID)
            ->setDeliveryNotes($deliveryNotes)
            ->setPickUpModel($pickUpModel)
            ->setRequestID($requestID)
            ->setUserID($userID);
    }
    /**
     * Get AuthenticationID value
     * @return string|null
     */
    public function getAuthenticationID()
    {
        return $this->AuthenticationID;
    }
    /**
     * Set AuthenticationID value
     * @param string $authenticationID
     * @return \LGRAVE\StructType\CompletePickUpInput
     */
    public function setAuthenticationID($authenticationID = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationID) && !is_string($authenticationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationID, true), gettype($authenticationID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($authenticationID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $authenticationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($authenticationID, true)), __LINE__);
        }
        $this->AuthenticationID = $authenticationID;
        return $this;
    }
    /**
     * Get DeliveryNotes value
     * @return \LGRAVE\ArrayType\ArrayOfDeliveryNote|null
     */
    public function getDeliveryNotes()
    {
        return $this->DeliveryNotes;
    }
    /**
     * Set DeliveryNotes value
     * @param \LGRAVE\ArrayType\ArrayOfDeliveryNote $deliveryNotes
     * @return \LGRAVE\StructType\CompletePickUpInput
     */
    public function setDeliveryNotes(\LGRAVE\ArrayType\ArrayOfDeliveryNote $deliveryNotes = null)
    {
        $this->DeliveryNotes = $deliveryNotes;
        return $this;
    }
    /**
     * Get PickUpModel value
     * @return \LGRAVE\StructType\PickUpModel|null
     */
    public function getPickUpModel()
    {
        return $this->PickUpModel;
    }
    /**
     * Set PickUpModel value
     * @param \LGRAVE\StructType\PickUpModel $pickUpModel
     * @return \LGRAVE\StructType\CompletePickUpInput
     */
    public function setPickUpModel(\LGRAVE\StructType\PickUpModel $pickUpModel = null)
    {
        $this->PickUpModel = $pickUpModel;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \LGRAVE\StructType\CompletePickUpInput
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestID, true)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \LGRAVE\StructType\CompletePickUpInput
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userID, true)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
}
