<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientData
 * @subpackage Structs
 */
class ClientData extends AbstractStructBase
{
    /**
     * The ClientID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ClientID;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The ContractID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContractID;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The RequestedBy
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RequestedBy;
    /**
     * Constructor method for ClientData
     * @uses ClientData::setClientID()
     * @uses ClientData::setContactName()
     * @uses ClientData::setContractID()
     * @uses ClientData::setEmail()
     * @uses ClientData::setPhone()
     * @uses ClientData::setRequestedBy()
     * @param string $clientID
     * @param string $contactName
     * @param string $contractID
     * @param string $email
     * @param string $phone
     * @param string $requestedBy
     */
    public function __construct($clientID = null, $contactName = null, $contractID = null, $email = null, $phone = null, $requestedBy = null)
    {
        $this
            ->setClientID($clientID)
            ->setContactName($contactName)
            ->setContractID($contractID)
            ->setEmail($email)
            ->setPhone($phone)
            ->setRequestedBy($requestedBy);
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \LGRAVE\StructType\ClientData
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \LGRAVE\StructType\ClientData
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ContractID value
     * @return string|null
     */
    public function getContractID()
    {
        return $this->ContractID;
    }
    /**
     * Set ContractID value
     * @param string $contractID
     * @return \LGRAVE\StructType\ClientData
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: string
        if (!is_null($contractID) && !is_string($contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractID, true), gettype($contractID)), __LINE__);
        }
        $this->ContractID = $contractID;
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \LGRAVE\StructType\ClientData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \LGRAVE\StructType\ClientData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get RequestedBy value
     * @return string|null
     */
    public function getRequestedBy()
    {
        return $this->RequestedBy;
    }
    /**
     * Set RequestedBy value
     * @param string $requestedBy
     * @return \LGRAVE\StructType\ClientData
     */
    public function setRequestedBy($requestedBy = null)
    {
        // validation for constraint: string
        if (!is_null($requestedBy) && !is_string($requestedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedBy, true), gettype($requestedBy)), __LINE__);
        }
        $this->RequestedBy = $requestedBy;
        return $this;
    }
}
