<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Complete ServiceType
 * @subpackage Services
 */
class Complete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CompletePickUp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\CompletePickUp $parameters
     * @return \LGRAVE\StructType\CompletePickUpResponse|bool
     */
    public function CompletePickUp(\LGRAVE\StructType\CompletePickUp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CompletePickUp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\CompletePickUpResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
