<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickUpData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PickUpData
 * @subpackage Structs
 */
class PickUpData extends AbstractStructBase
{
    /**
     * The BiggerObjectHeight
     * @var int
     */
    public $BiggerObjectHeight;
    /**
     * The BiggerObjectLenght
     * @var int
     */
    public $BiggerObjectLenght;
    /**
     * The BiggerObjectWidth
     * @var int
     */
    public $BiggerObjectWidth;
    /**
     * The ClientData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\StructType\ClientData
     */
    public $ClientData;
    /**
     * The ClientRef
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ClientRef;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The DestinationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfPickUpData_Destinations
     */
    public $DestinationList;
    /**
     * The HasRedeShopping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasRedeShopping;
    /**
     * The HeavierObjectWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HeavierObjectWeight;
    /**
     * The Observations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observations;
    /**
     * The PickUpPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickUpPeriod;
    /**
     * The PickupAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \LGRAVE\StructType\PickUpAddressData
     */
    public $PickupAddress;
    /**
     * The ShipmentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfstring
     */
    public $ShipmentList;
    /**
     * The TotalObjects
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalObjects;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalWeight;
    /**
     * The TransportDocument
     * @var string
     */
    public $TransportDocument;
    /**
     * Constructor method for PickUpData
     * @uses PickUpData::setBiggerObjectHeight()
     * @uses PickUpData::setBiggerObjectLenght()
     * @uses PickUpData::setBiggerObjectWidth()
     * @uses PickUpData::setClientData()
     * @uses PickUpData::setClientRef()
     * @uses PickUpData::setDate()
     * @uses PickUpData::setDestinationList()
     * @uses PickUpData::setHasRedeShopping()
     * @uses PickUpData::setHeavierObjectWeight()
     * @uses PickUpData::setObservations()
     * @uses PickUpData::setPickUpPeriod()
     * @uses PickUpData::setPickupAddress()
     * @uses PickUpData::setShipmentList()
     * @uses PickUpData::setTotalObjects()
     * @uses PickUpData::setTotalWeight()
     * @uses PickUpData::setTransportDocument()
     * @param int $biggerObjectHeight
     * @param int $biggerObjectLenght
     * @param int $biggerObjectWidth
     * @param \LGRAVE\StructType\ClientData $clientData
     * @param string $clientRef
     * @param string $date
     * @param \LGRAVE\ArrayType\ArrayOfPickUpData_Destinations $destinationList
     * @param bool $hasRedeShopping
     * @param int $heavierObjectWeight
     * @param string $observations
     * @param string $pickUpPeriod
     * @param \LGRAVE\StructType\PickUpAddressData $pickupAddress
     * @param \LGRAVE\ArrayType\ArrayOfstring $shipmentList
     * @param int $totalObjects
     * @param int $totalWeight
     * @param string $transportDocument
     */
    public function __construct($biggerObjectHeight = null, $biggerObjectLenght = null, $biggerObjectWidth = null, \LGRAVE\StructType\ClientData $clientData = null, $clientRef = null, $date = null, \LGRAVE\ArrayType\ArrayOfPickUpData_Destinations $destinationList = null, $hasRedeShopping = null, $heavierObjectWeight = null, $observations = null, $pickUpPeriod = null, \LGRAVE\StructType\PickUpAddressData $pickupAddress = null, \LGRAVE\ArrayType\ArrayOfstring $shipmentList = null, $totalObjects = null, $totalWeight = null, $transportDocument = null)
    {
        $this
            ->setBiggerObjectHeight($biggerObjectHeight)
            ->setBiggerObjectLenght($biggerObjectLenght)
            ->setBiggerObjectWidth($biggerObjectWidth)
            ->setClientData($clientData)
            ->setClientRef($clientRef)
            ->setDate($date)
            ->setDestinationList($destinationList)
            ->setHasRedeShopping($hasRedeShopping)
            ->setHeavierObjectWeight($heavierObjectWeight)
            ->setObservations($observations)
            ->setPickUpPeriod($pickUpPeriod)
            ->setPickupAddress($pickupAddress)
            ->setShipmentList($shipmentList)
            ->setTotalObjects($totalObjects)
            ->setTotalWeight($totalWeight)
            ->setTransportDocument($transportDocument);
    }
    /**
     * Get BiggerObjectHeight value
     * @return int|null
     */
    public function getBiggerObjectHeight()
    {
        return $this->BiggerObjectHeight;
    }
    /**
     * Set BiggerObjectHeight value
     * @param int $biggerObjectHeight
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setBiggerObjectHeight($biggerObjectHeight = null)
    {
        // validation for constraint: int
        if (!is_null($biggerObjectHeight) && !(is_int($biggerObjectHeight) || ctype_digit($biggerObjectHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($biggerObjectHeight, true), gettype($biggerObjectHeight)), __LINE__);
        }
        $this->BiggerObjectHeight = $biggerObjectHeight;
        return $this;
    }
    /**
     * Get BiggerObjectLenght value
     * @return int|null
     */
    public function getBiggerObjectLenght()
    {
        return $this->BiggerObjectLenght;
    }
    /**
     * Set BiggerObjectLenght value
     * @param int $biggerObjectLenght
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setBiggerObjectLenght($biggerObjectLenght = null)
    {
        // validation for constraint: int
        if (!is_null($biggerObjectLenght) && !(is_int($biggerObjectLenght) || ctype_digit($biggerObjectLenght))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($biggerObjectLenght, true), gettype($biggerObjectLenght)), __LINE__);
        }
        $this->BiggerObjectLenght = $biggerObjectLenght;
        return $this;
    }
    /**
     * Get BiggerObjectWidth value
     * @return int|null
     */
    public function getBiggerObjectWidth()
    {
        return $this->BiggerObjectWidth;
    }
    /**
     * Set BiggerObjectWidth value
     * @param int $biggerObjectWidth
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setBiggerObjectWidth($biggerObjectWidth = null)
    {
        // validation for constraint: int
        if (!is_null($biggerObjectWidth) && !(is_int($biggerObjectWidth) || ctype_digit($biggerObjectWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($biggerObjectWidth, true), gettype($biggerObjectWidth)), __LINE__);
        }
        $this->BiggerObjectWidth = $biggerObjectWidth;
        return $this;
    }
    /**
     * Get ClientData value
     * @return \LGRAVE\StructType\ClientData|null
     */
    public function getClientData()
    {
        return $this->ClientData;
    }
    /**
     * Set ClientData value
     * @param \LGRAVE\StructType\ClientData $clientData
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setClientData(\LGRAVE\StructType\ClientData $clientData = null)
    {
        $this->ClientData = $clientData;
        return $this;
    }
    /**
     * Get ClientRef value
     * @return string|null
     */
    public function getClientRef()
    {
        return $this->ClientRef;
    }
    /**
     * Set ClientRef value
     * @param string $clientRef
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setClientRef($clientRef = null)
    {
        // validation for constraint: string
        if (!is_null($clientRef) && !is_string($clientRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRef, true), gettype($clientRef)), __LINE__);
        }
        $this->ClientRef = $clientRef;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get DestinationList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfPickUpData_Destinations|null
     */
    public function getDestinationList()
    {
        return isset($this->DestinationList) ? $this->DestinationList : null;
    }
    /**
     * Set DestinationList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfPickUpData_Destinations $destinationList
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setDestinationList(\LGRAVE\ArrayType\ArrayOfPickUpData_Destinations $destinationList = null)
    {
        if (is_null($destinationList) || (is_array($destinationList) && empty($destinationList))) {
            unset($this->DestinationList);
        } else {
            $this->DestinationList = $destinationList;
        }
        return $this;
    }
    /**
     * Get HasRedeShopping value
     * @return bool|null
     */
    public function getHasRedeShopping()
    {
        return $this->HasRedeShopping;
    }
    /**
     * Set HasRedeShopping value
     * @param bool $hasRedeShopping
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setHasRedeShopping($hasRedeShopping = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasRedeShopping) && !is_bool($hasRedeShopping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasRedeShopping, true), gettype($hasRedeShopping)), __LINE__);
        }
        $this->HasRedeShopping = $hasRedeShopping;
        return $this;
    }
    /**
     * Get HeavierObjectWeight value
     * @return int|null
     */
    public function getHeavierObjectWeight()
    {
        return $this->HeavierObjectWeight;
    }
    /**
     * Set HeavierObjectWeight value
     * @param int $heavierObjectWeight
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setHeavierObjectWeight($heavierObjectWeight = null)
    {
        // validation for constraint: int
        if (!is_null($heavierObjectWeight) && !(is_int($heavierObjectWeight) || ctype_digit($heavierObjectWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heavierObjectWeight, true), gettype($heavierObjectWeight)), __LINE__);
        }
        $this->HeavierObjectWeight = $heavierObjectWeight;
        return $this;
    }
    /**
     * Get Observations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservations()
    {
        return isset($this->Observations) ? $this->Observations : null;
    }
    /**
     * Set Observations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observations
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setObservations($observations = null)
    {
        // validation for constraint: string
        if (!is_null($observations) && !is_string($observations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observations, true), gettype($observations)), __LINE__);
        }
        if (is_null($observations) || (is_array($observations) && empty($observations))) {
            unset($this->Observations);
        } else {
            $this->Observations = $observations;
        }
        return $this;
    }
    /**
     * Get PickUpPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickUpPeriod()
    {
        return isset($this->PickUpPeriod) ? $this->PickUpPeriod : null;
    }
    /**
     * Set PickUpPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickUpPeriod
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setPickUpPeriod($pickUpPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpPeriod) && !is_string($pickUpPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpPeriod, true), gettype($pickUpPeriod)), __LINE__);
        }
        if (is_null($pickUpPeriod) || (is_array($pickUpPeriod) && empty($pickUpPeriod))) {
            unset($this->PickUpPeriod);
        } else {
            $this->PickUpPeriod = $pickUpPeriod;
        }
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return \LGRAVE\StructType\PickUpAddressData|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \LGRAVE\StructType\PickUpAddressData $pickupAddress
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setPickupAddress(\LGRAVE\StructType\PickUpAddressData $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get ShipmentList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfstring|null
     */
    public function getShipmentList()
    {
        return isset($this->ShipmentList) ? $this->ShipmentList : null;
    }
    /**
     * Set ShipmentList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfstring $shipmentList
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setShipmentList(\LGRAVE\ArrayType\ArrayOfstring $shipmentList = null)
    {
        if (is_null($shipmentList) || (is_array($shipmentList) && empty($shipmentList))) {
            unset($this->ShipmentList);
        } else {
            $this->ShipmentList = $shipmentList;
        }
        return $this;
    }
    /**
     * Get TotalObjects value
     * @return int|null
     */
    public function getTotalObjects()
    {
        return $this->TotalObjects;
    }
    /**
     * Set TotalObjects value
     * @param int $totalObjects
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setTotalObjects($totalObjects = null)
    {
        // validation for constraint: int
        if (!is_null($totalObjects) && !(is_int($totalObjects) || ctype_digit($totalObjects))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalObjects, true), gettype($totalObjects)), __LINE__);
        }
        $this->TotalObjects = $totalObjects;
        return $this;
    }
    /**
     * Get TotalWeight value
     * @return int|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param int $totalWeight
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setTotalWeight($totalWeight = null)
    {
        // validation for constraint: int
        if (!is_null($totalWeight) && !(is_int($totalWeight) || ctype_digit($totalWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalWeight, true), gettype($totalWeight)), __LINE__);
        }
        $this->TotalWeight = $totalWeight;
        return $this;
    }
    /**
     * Get TransportDocument value
     * @return string|null
     */
    public function getTransportDocument()
    {
        return $this->TransportDocument;
    }
    /**
     * Set TransportDocument value
     * @param string $transportDocument
     * @return \LGRAVE\StructType\PickUpData
     */
    public function setTransportDocument($transportDocument = null)
    {
        // validation for constraint: string
        if (!is_null($transportDocument) && !is_string($transportDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportDocument, true), gettype($transportDocument)), __LINE__);
        }
        $this->TransportDocument = $transportDocument;
        return $this;
    }
}
