<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickUpAddressData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PickUpAddressData
 * @subpackage Structs
 */
class PickUpAddressData extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The CP3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CP3;
    /**
     * The CP4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CP4;
    /**
     * The CPInt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPInt;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contact;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Door
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Door;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Floor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Floor;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * Constructor method for PickUpAddressData
     * @uses PickUpAddressData::setAddress()
     * @uses PickUpAddressData::setCP3()
     * @uses PickUpAddressData::setCP4()
     * @uses PickUpAddressData::setCPInt()
     * @uses PickUpAddressData::setCity()
     * @uses PickUpAddressData::setContact()
     * @uses PickUpAddressData::setCountry()
     * @uses PickUpAddressData::setDoor()
     * @uses PickUpAddressData::setEmail()
     * @uses PickUpAddressData::setFloor()
     * @uses PickUpAddressData::setMobilePhone()
     * @uses PickUpAddressData::setName()
     * @uses PickUpAddressData::setPhone()
     * @param string $address
     * @param string $cP3
     * @param string $cP4
     * @param string $cPInt
     * @param string $city
     * @param string $contact
     * @param string $country
     * @param string $door
     * @param string $email
     * @param string $floor
     * @param string $mobilePhone
     * @param string $name
     * @param string $phone
     */
    public function __construct($address = null, $cP3 = null, $cP4 = null, $cPInt = null, $city = null, $contact = null, $country = null, $door = null, $email = null, $floor = null, $mobilePhone = null, $name = null, $phone = null)
    {
        $this
            ->setAddress($address)
            ->setCP3($cP3)
            ->setCP4($cP4)
            ->setCPInt($cPInt)
            ->setCity($city)
            ->setContact($contact)
            ->setCountry($country)
            ->setDoor($door)
            ->setEmail($email)
            ->setFloor($floor)
            ->setMobilePhone($mobilePhone)
            ->setName($name)
            ->setPhone($phone);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CP3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCP3()
    {
        return isset($this->CP3) ? $this->CP3 : null;
    }
    /**
     * Set CP3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cP3
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setCP3($cP3 = null)
    {
        // validation for constraint: string
        if (!is_null($cP3) && !is_string($cP3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cP3, true), gettype($cP3)), __LINE__);
        }
        if (is_null($cP3) || (is_array($cP3) && empty($cP3))) {
            unset($this->CP3);
        } else {
            $this->CP3 = $cP3;
        }
        return $this;
    }
    /**
     * Get CP4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCP4()
    {
        return isset($this->CP4) ? $this->CP4 : null;
    }
    /**
     * Set CP4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cP4
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setCP4($cP4 = null)
    {
        // validation for constraint: string
        if (!is_null($cP4) && !is_string($cP4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cP4, true), gettype($cP4)), __LINE__);
        }
        if (is_null($cP4) || (is_array($cP4) && empty($cP4))) {
            unset($this->CP4);
        } else {
            $this->CP4 = $cP4;
        }
        return $this;
    }
    /**
     * Get CPInt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPInt()
    {
        return isset($this->CPInt) ? $this->CPInt : null;
    }
    /**
     * Set CPInt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPInt
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setCPInt($cPInt = null)
    {
        // validation for constraint: string
        if (!is_null($cPInt) && !is_string($cPInt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPInt, true), gettype($cPInt)), __LINE__);
        }
        if (is_null($cPInt) || (is_array($cPInt) && empty($cPInt))) {
            unset($this->CPInt);
        } else {
            $this->CPInt = $cPInt;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contact
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Door value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoor()
    {
        return isset($this->Door) ? $this->Door : null;
    }
    /**
     * Set Door value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $door
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setDoor($door = null)
    {
        // validation for constraint: string
        if (!is_null($door) && !is_string($door)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($door, true), gettype($door)), __LINE__);
        }
        if (is_null($door) || (is_array($door) && empty($door))) {
            unset($this->Door);
        } else {
            $this->Door = $door;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Floor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFloor()
    {
        return isset($this->Floor) ? $this->Floor : null;
    }
    /**
     * Set Floor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $floor
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        if (is_null($floor) || (is_array($floor) && empty($floor))) {
            unset($this->Floor);
        } else {
            $this->Floor = $floor;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \LGRAVE\StructType\PickUpAddressData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
}
