<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PesquisaRecolhas StructType
 * @subpackage Structs
 */
class PesquisaRecolhas extends AbstractStructBase
{
    /**
     * The NumCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumCliente;
    /**
     * The NumContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumContrato;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The dtInicio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtInicio;
    /**
     * The dtFim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtFim;
    /**
     * The Estado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The NumRecolha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumRecolha;
    /**
     * Constructor method for PesquisaRecolhas
     * @uses PesquisaRecolhas::setNumCliente()
     * @uses PesquisaRecolhas::setNumContrato()
     * @uses PesquisaRecolhas::setID()
     * @uses PesquisaRecolhas::setDtInicio()
     * @uses PesquisaRecolhas::setDtFim()
     * @uses PesquisaRecolhas::setEstado()
     * @uses PesquisaRecolhas::setNumRecolha()
     * @param string $numCliente
     * @param string $numContrato
     * @param string $iD
     * @param string $dtInicio
     * @param string $dtFim
     * @param string $estado
     * @param string $numRecolha
     */
    public function __construct($numCliente = null, $numContrato = null, $iD = null, $dtInicio = null, $dtFim = null, $estado = null, $numRecolha = null)
    {
        $this
            ->setNumCliente($numCliente)
            ->setNumContrato($numContrato)
            ->setID($iD)
            ->setDtInicio($dtInicio)
            ->setDtFim($dtFim)
            ->setEstado($estado)
            ->setNumRecolha($numRecolha);
    }
    /**
     * Get NumCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumCliente()
    {
        return isset($this->NumCliente) ? $this->NumCliente : null;
    }
    /**
     * Set NumCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numCliente
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setNumCliente($numCliente = null)
    {
        // validation for constraint: string
        if (!is_null($numCliente) && !is_string($numCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numCliente, true), gettype($numCliente)), __LINE__);
        }
        if (is_null($numCliente) || (is_array($numCliente) && empty($numCliente))) {
            unset($this->NumCliente);
        } else {
            $this->NumCliente = $numCliente;
        }
        return $this;
    }
    /**
     * Get NumContrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumContrato()
    {
        return isset($this->NumContrato) ? $this->NumContrato : null;
    }
    /**
     * Set NumContrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numContrato
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setNumContrato($numContrato = null)
    {
        // validation for constraint: string
        if (!is_null($numContrato) && !is_string($numContrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numContrato, true), gettype($numContrato)), __LINE__);
        }
        if (is_null($numContrato) || (is_array($numContrato) && empty($numContrato))) {
            unset($this->NumContrato);
        } else {
            $this->NumContrato = $numContrato;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get dtInicio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtInicio()
    {
        return isset($this->dtInicio) ? $this->dtInicio : null;
    }
    /**
     * Set dtInicio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dtInicio
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setDtInicio($dtInicio = null)
    {
        // validation for constraint: string
        if (!is_null($dtInicio) && !is_string($dtInicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtInicio, true), gettype($dtInicio)), __LINE__);
        }
        if (is_null($dtInicio) || (is_array($dtInicio) && empty($dtInicio))) {
            unset($this->dtInicio);
        } else {
            $this->dtInicio = $dtInicio;
        }
        return $this;
    }
    /**
     * Get dtFim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtFim()
    {
        return isset($this->dtFim) ? $this->dtFim : null;
    }
    /**
     * Set dtFim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dtFim
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setDtFim($dtFim = null)
    {
        // validation for constraint: string
        if (!is_null($dtFim) && !is_string($dtFim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtFim, true), gettype($dtFim)), __LINE__);
        }
        if (is_null($dtFim) || (is_array($dtFim) && empty($dtFim))) {
            unset($this->dtFim);
        } else {
            $this->dtFim = $dtFim;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get NumRecolha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumRecolha()
    {
        return isset($this->NumRecolha) ? $this->NumRecolha : null;
    }
    /**
     * Set NumRecolha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numRecolha
     * @return \LGRAVE\StructType\PesquisaRecolhas
     */
    public function setNumRecolha($numRecolha = null)
    {
        // validation for constraint: string
        if (!is_null($numRecolha) && !is_string($numRecolha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numRecolha, true), gettype($numRecolha)), __LINE__);
        }
        if (is_null($numRecolha) || (is_array($numRecolha) && empty($numRecolha))) {
            unset($this->NumRecolha);
        } else {
            $this->NumRecolha = $numRecolha;
        }
        return $this;
    }
}
