<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarcarRecolha StructType
 * @subpackage Structs
 */
class MarcarRecolha extends AbstractStructBase
{
    /**
     * The NumCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumCliente;
    /**
     * The NumContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumContrato;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The recolhaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\StructType\DadosRecolhaBE
     */
    public $recolhaData;
    /**
     * Constructor method for MarcarRecolha
     * @uses MarcarRecolha::setNumCliente()
     * @uses MarcarRecolha::setNumContrato()
     * @uses MarcarRecolha::setID()
     * @uses MarcarRecolha::setRecolhaData()
     * @param string $numCliente
     * @param string $numContrato
     * @param string $iD
     * @param \LGRAVE\StructType\DadosRecolhaBE $recolhaData
     */
    public function __construct($numCliente = null, $numContrato = null, $iD = null, \LGRAVE\StructType\DadosRecolhaBE $recolhaData = null)
    {
        $this
            ->setNumCliente($numCliente)
            ->setNumContrato($numContrato)
            ->setID($iD)
            ->setRecolhaData($recolhaData);
    }
    /**
     * Get NumCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumCliente()
    {
        return isset($this->NumCliente) ? $this->NumCliente : null;
    }
    /**
     * Set NumCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numCliente
     * @return \LGRAVE\StructType\MarcarRecolha
     */
    public function setNumCliente($numCliente = null)
    {
        // validation for constraint: string
        if (!is_null($numCliente) && !is_string($numCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numCliente, true), gettype($numCliente)), __LINE__);
        }
        if (is_null($numCliente) || (is_array($numCliente) && empty($numCliente))) {
            unset($this->NumCliente);
        } else {
            $this->NumCliente = $numCliente;
        }
        return $this;
    }
    /**
     * Get NumContrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumContrato()
    {
        return isset($this->NumContrato) ? $this->NumContrato : null;
    }
    /**
     * Set NumContrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numContrato
     * @return \LGRAVE\StructType\MarcarRecolha
     */
    public function setNumContrato($numContrato = null)
    {
        // validation for constraint: string
        if (!is_null($numContrato) && !is_string($numContrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numContrato, true), gettype($numContrato)), __LINE__);
        }
        if (is_null($numContrato) || (is_array($numContrato) && empty($numContrato))) {
            unset($this->NumContrato);
        } else {
            $this->NumContrato = $numContrato;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \LGRAVE\StructType\MarcarRecolha
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get recolhaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\StructType\DadosRecolhaBE|null
     */
    public function getRecolhaData()
    {
        return isset($this->recolhaData) ? $this->recolhaData : null;
    }
    /**
     * Set recolhaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\StructType\DadosRecolhaBE $recolhaData
     * @return \LGRAVE\StructType\MarcarRecolha
     */
    public function setRecolhaData(\LGRAVE\StructType\DadosRecolhaBE $recolhaData = null)
    {
        if (is_null($recolhaData) || (is_array($recolhaData) && empty($recolhaData))) {
            unset($this->recolhaData);
        } else {
            $this->recolhaData = $recolhaData;
        }
        return $this;
    }
}
