<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DDA StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DDA
 * @subpackage Structs
 */
class DDA extends AbstractStructBase
{
    /**
     * The ShipperInstructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperInstructions;
    /**
     * Constructor method for DDA
     * @uses DDA::setShipperInstructions()
     * @param string $shipperInstructions
     */
    public function __construct($shipperInstructions = null)
    {
        $this
            ->setShipperInstructions($shipperInstructions);
    }
    /**
     * Get ShipperInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperInstructions()
    {
        return isset($this->ShipperInstructions) ? $this->ShipperInstructions : null;
    }
    /**
     * Set ShipperInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperInstructions
     * @return \LGRAVE\StructType\DDA
     */
    public function setShipperInstructions($shipperInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($shipperInstructions) && !is_string($shipperInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperInstructions, true), gettype($shipperInstructions)), __LINE__);
        }
        if (is_null($shipperInstructions) || (is_array($shipperInstructions) && empty($shipperInstructions))) {
            unset($this->ShipperInstructions);
        } else {
            $this->ShipperInstructions = $shipperInstructions;
        }
        return $this;
    }
}
