<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsItemsData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomsItemsData
 * @subpackage Structs
 */
class CustomsItemsData extends AbstractStructBase
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Detail;
    /**
     * The HarmonizedCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $HarmonizedCode;
    /**
     * The ItemNumber
     * @var int
     */
    public $ItemNumber;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginCountry;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Value
     * @var float
     */
    public $Value;
    /**
     * The Weight
     * @var float
     */
    public $Weight;
    /**
     * Constructor method for CustomsItemsData
     * @uses CustomsItemsData::setCurrency()
     * @uses CustomsItemsData::setDetail()
     * @uses CustomsItemsData::setHarmonizedCode()
     * @uses CustomsItemsData::setItemNumber()
     * @uses CustomsItemsData::setOriginCountry()
     * @uses CustomsItemsData::setQuantity()
     * @uses CustomsItemsData::setValue()
     * @uses CustomsItemsData::setWeight()
     * @param string $currency
     * @param string $detail
     * @param string $harmonizedCode
     * @param int $itemNumber
     * @param string $originCountry
     * @param int $quantity
     * @param float $value
     * @param float $weight
     */
    public function __construct($currency = null, $detail = null, $harmonizedCode = null, $itemNumber = null, $originCountry = null, $quantity = null, $value = null, $weight = null)
    {
        $this
            ->setCurrency($currency)
            ->setDetail($detail)
            ->setHarmonizedCode($harmonizedCode)
            ->setItemNumber($itemNumber)
            ->setOriginCountry($originCountry)
            ->setQuantity($quantity)
            ->setValue($value)
            ->setWeight($weight);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param string $detail
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Get HarmonizedCode value
     * @return string|null
     */
    public function getHarmonizedCode()
    {
        return $this->HarmonizedCode;
    }
    /**
     * Set HarmonizedCode value
     * @param string $harmonizedCode
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setHarmonizedCode($harmonizedCode = null)
    {
        // validation for constraint: string
        if (!is_null($harmonizedCode) && !is_string($harmonizedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($harmonizedCode, true), gettype($harmonizedCode)), __LINE__);
        }
        $this->HarmonizedCode = $harmonizedCode;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !(is_int($itemNumber) || ctype_digit($itemNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return string|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param string $originCountry
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setOriginCountry($originCountry = null)
    {
        // validation for constraint: string
        if (!is_null($originCountry) && !is_string($originCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountry, true), gettype($originCountry)), __LINE__);
        }
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \LGRAVE\StructType\CustomsItemsData
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
