<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetRecolha
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetRecolha $parameters
     * @return \LGRAVE\StructType\GetRecolhaResponse|bool
     */
    public function GetRecolha(\LGRAVE\StructType\GetRecolha $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecolha($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProdutosRecolha
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetProdutosRecolha $parameters
     * @return \LGRAVE\StructType\GetProdutosRecolhaResponse|bool
     */
    public function GetProdutosRecolha(\LGRAVE\StructType\GetProdutosRecolha $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProdutosRecolha($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEstadosRecolha
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetEstadosRecolha $parameters
     * @return \LGRAVE\StructType\GetEstadosRecolhaResponse|bool
     */
    public function GetEstadosRecolha(\LGRAVE\StructType\GetEstadosRecolha $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEstadosRecolha($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAreaInfluencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetAreaInfluencia $parameters
     * @return \LGRAVE\StructType\GetAreaInfluenciaResponse|bool
     */
    public function GetAreaInfluencia(\LGRAVE\StructType\GetAreaInfluencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAreaInfluencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetZonaTaxacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\GetZonaTaxacao $parameters
     * @return \LGRAVE\StructType\GetZonaTaxacaoResponse|bool
     */
    public function GetZonaTaxacao(\LGRAVE\StructType\GetZonaTaxacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZonaTaxacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\GetAreaInfluenciaResponse|\LGRAVE\StructType\GetEstadosRecolhaResponse|\LGRAVE\StructType\GetProdutosRecolhaResponse|\LGRAVE\StructType\GetRecolhaResponse|\LGRAVE\StructType\GetZonaTaxacaoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
