<?php

namespace LGRAVE;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'DDA' => '\\LGRAVE\\StructType\\DDA',
            'DeliveryPointData' => '\\LGRAVE\\StructType\\DeliveryPointData',
            'MultipleHomeDeliveryData' => '\\LGRAVE\\StructType\\MultipleHomeDeliveryData',
            'ReturnAuthorizationData' => '\\LGRAVE\\StructType\\ReturnAuthorizationData',
            'TimeWindowData' => '\\LGRAVE\\StructType\\TimeWindowData',
            'DeliveryNote' => '\\LGRAVE\\StructType\\DeliveryNote',
            'ArrayOfShipmentCTT' => '\\LGRAVE\\ArrayType\\ArrayOfShipmentCTT',
            'ShipmentCTT' => '\\LGRAVE\\StructType\\ShipmentCTT',
            'DeliveryAggregationInf' => '\\LGRAVE\\StructType\\DeliveryAggregationInf',
            'ArrayOfPIPAuthorizationData' => '\\LGRAVE\\ArrayType\\ArrayOfPIPAuthorizationData',
            'PIPAuthorizationData' => '\\LGRAVE\\StructType\\PIPAuthorizationData',
            'AddressData' => '\\LGRAVE\\StructType\\AddressData',
            'ShipmentData' => '\\LGRAVE\\StructType\\ShipmentData',
            'CargoData' => '\\LGRAVE\\StructType\\CargoData',
            'CustomsData' => '\\LGRAVE\\StructType\\CustomsData',
            'ArrayOfCustomsItemsData' => '\\LGRAVE\\ArrayType\\ArrayOfCustomsItemsData',
            'CustomsItemsData' => '\\LGRAVE\\StructType\\CustomsItemsData',
            'ArrayOfSpecialService' => '\\LGRAVE\\ArrayType\\ArrayOfSpecialService',
            'SpecialService' => '\\LGRAVE\\StructType\\SpecialService',
            'CompleteShipmentInput' => '\\LGRAVE\\StructType\\CompleteShipmentInput',
            'CompleteShipmentOutput' => '\\LGRAVE\\StructType\\CompleteShipmentOutput',
            'ArrayOfErrorData' => '\\LGRAVE\\ArrayType\\ArrayOfErrorData',
            'ErrorData' => '\\LGRAVE\\StructType\\ErrorData',
            'ArrayOfShipmentDataOutput' => '\\LGRAVE\\ArrayType\\ArrayOfShipmentDataOutput',
            'ShipmentDataOutput' => '\\LGRAVE\\StructType\\ShipmentDataOutput',
            'ArrayOfDocumentData' => '\\LGRAVE\\ArrayType\\ArrayOfDocumentData',
            'DocumentData' => '\\LGRAVE\\StructType\\DocumentData',
            'ArrayOfLabelData' => '\\LGRAVE\\ArrayType\\ArrayOfLabelData',
            'LabelData' => '\\LGRAVE\\StructType\\LabelData',
            'CreateShipmentInput' => '\\LGRAVE\\StructType\\CreateShipmentInput',
            'CreateShipmentOutput' => '\\LGRAVE\\StructType\\CreateShipmentOutput',
            'CloseShipmentInput' => '\\LGRAVE\\StructType\\CloseShipmentInput',
            'ArrayOfShipment2Close' => '\\LGRAVE\\ArrayType\\ArrayOfShipment2Close',
            'Shipment2Close' => '\\LGRAVE\\StructType\\Shipment2Close',
            'CloseShipmentOutput' => '\\LGRAVE\\StructType\\CloseShipmentOutput',
            'CompleteShipment' => '\\LGRAVE\\StructType\\CompleteShipment',
            'CompleteShipmentResponse' => '\\LGRAVE\\StructType\\CompleteShipmentResponse',
            'CreateShipment' => '\\LGRAVE\\StructType\\CreateShipment',
            'CreateShipmentResponse' => '\\LGRAVE\\StructType\\CreateShipmentResponse',
            'CreateShipmentWithoutPrint' => '\\LGRAVE\\StructType\\CreateShipmentWithoutPrint',
            'CreateShipmentWithoutPrintResponse' => '\\LGRAVE\\StructType\\CreateShipmentWithoutPrintResponse',
            'CloseShipment' => '\\LGRAVE\\StructType\\CloseShipment',
            'CloseShipmentResponse' => '\\LGRAVE\\StructType\\CloseShipmentResponse',
        );
    }
}
