<?php

namespace LGRAVE\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseShipmentOutput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CloseShipmentOutput
 * @subpackage Structs
 */
class CloseShipmentOutput extends AbstractStructBase
{
    /**
     * The DocumentsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfDocumentData
     */
    public $DocumentsList;
    /**
     * The ErrorsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \LGRAVE\ArrayType\ArrayOfErrorData
     */
    public $ErrorsList;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for CloseShipmentOutput
     * @uses CloseShipmentOutput::setDocumentsList()
     * @uses CloseShipmentOutput::setErrorsList()
     * @uses CloseShipmentOutput::setStatus()
     * @param \LGRAVE\ArrayType\ArrayOfDocumentData $documentsList
     * @param \LGRAVE\ArrayType\ArrayOfErrorData $errorsList
     * @param string $status
     */
    public function __construct(\LGRAVE\ArrayType\ArrayOfDocumentData $documentsList = null, \LGRAVE\ArrayType\ArrayOfErrorData $errorsList = null, $status = null)
    {
        $this
            ->setDocumentsList($documentsList)
            ->setErrorsList($errorsList)
            ->setStatus($status);
    }
    /**
     * Get DocumentsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfDocumentData|null
     */
    public function getDocumentsList()
    {
        return isset($this->DocumentsList) ? $this->DocumentsList : null;
    }
    /**
     * Set DocumentsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfDocumentData $documentsList
     * @return \LGRAVE\StructType\CloseShipmentOutput
     */
    public function setDocumentsList(\LGRAVE\ArrayType\ArrayOfDocumentData $documentsList = null)
    {
        if (is_null($documentsList) || (is_array($documentsList) && empty($documentsList))) {
            unset($this->DocumentsList);
        } else {
            $this->DocumentsList = $documentsList;
        }
        return $this;
    }
    /**
     * Get ErrorsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LGRAVE\ArrayType\ArrayOfErrorData|null
     */
    public function getErrorsList()
    {
        return isset($this->ErrorsList) ? $this->ErrorsList : null;
    }
    /**
     * Set ErrorsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \LGRAVE\ArrayType\ArrayOfErrorData $errorsList
     * @return \LGRAVE\StructType\CloseShipmentOutput
     */
    public function setErrorsList(\LGRAVE\ArrayType\ArrayOfErrorData $errorsList = null)
    {
        if (is_null($errorsList) || (is_array($errorsList) && empty($errorsList))) {
            unset($this->ErrorsList);
        } else {
            $this->ErrorsList = $errorsList;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \LGRAVE\EnumType\StatusValues::valueIsValid()
     * @uses \LGRAVE\EnumType\StatusValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \LGRAVE\StructType\CloseShipmentOutput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\LGRAVE\EnumType\StatusValues::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \LGRAVE\EnumType\StatusValues', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \LGRAVE\EnumType\StatusValues::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
