<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\CreateShipment $parameters
     * @return \LGRAVE\StructType\CreateShipmentResponse|bool
     */
    public function CreateShipment(\LGRAVE\StructType\CreateShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateShipmentWithoutPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\CreateShipmentWithoutPrint $parameters
     * @return \LGRAVE\StructType\CreateShipmentWithoutPrintResponse|bool
     */
    public function CreateShipmentWithoutPrint(\LGRAVE\StructType\CreateShipmentWithoutPrint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateShipmentWithoutPrint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\CreateShipmentResponse|\LGRAVE\StructType\CreateShipmentWithoutPrintResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
