<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Complete ServiceType
 * @subpackage Services
 */
class Complete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CompleteShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\CompleteShipment $parameters
     * @return \LGRAVE\StructType\CompleteShipmentResponse|bool
     */
    public function CompleteShipment(\LGRAVE\StructType\CompleteShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CompleteShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\CompleteShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
