<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirDestinationAirport StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos de un ciudad, aeropuerto, estación de autobús o tren de destino en el sistema Servivuelo
 * - nillable: true
 * - type: tns:AirDestinationAirport
 * @subpackage Structs
 */
class AirDestinationAirport extends AbstractStructBase
{
    /**
     * The AirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código IATA del aeropuerto
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirportLocationCode;
    /**
     * The CityLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo IATA de la ciudad a la que pertenece el aeropueto (si tiene)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityLocationCode;
    /**
     * The IsCity
     * Meta information extracted from the WSDL
     * - documentation: Indica si el codigo IATA es un aeropuerto o una ciudad
     * - minOccurs: 0
     * @var bool
     */
    public $IsCity;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: Codigo de pais en que se encuentra el aeropuerto o ciudad
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Descripción completa del aeropuerto y del destino
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AirDestinationAirport
     * @uses AirDestinationAirport::setAirportLocationCode()
     * @uses AirDestinationAirport::setCityLocationCode()
     * @uses AirDestinationAirport::setIsCity()
     * @uses AirDestinationAirport::setCountry()
     * @uses AirDestinationAirport::setDescription()
     * @param string $airportLocationCode
     * @param string $cityLocationCode
     * @param bool $isCity
     * @param string $country
     * @param string $description
     */
    public function __construct($airportLocationCode = null, $cityLocationCode = null, $isCity = null, $country = null, $description = null)
    {
        $this
            ->setAirportLocationCode($airportLocationCode)
            ->setCityLocationCode($cityLocationCode)
            ->setIsCity($isCity)
            ->setCountry($country)
            ->setDescription($description);
    }
    /**
     * Get AirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirportLocationCode()
    {
        return isset($this->AirportLocationCode) ? $this->AirportLocationCode : null;
    }
    /**
     * Set AirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airportLocationCode
     * @return \StructType\AirDestinationAirport
     */
    public function setAirportLocationCode($airportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportLocationCode) && !is_string($airportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportLocationCode, true), gettype($airportLocationCode)), __LINE__);
        }
        if (is_null($airportLocationCode) || (is_array($airportLocationCode) && empty($airportLocationCode))) {
            unset($this->AirportLocationCode);
        } else {
            $this->AirportLocationCode = $airportLocationCode;
        }
        return $this;
    }
    /**
     * Get CityLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityLocationCode()
    {
        return isset($this->CityLocationCode) ? $this->CityLocationCode : null;
    }
    /**
     * Set CityLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityLocationCode
     * @return \StructType\AirDestinationAirport
     */
    public function setCityLocationCode($cityLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityLocationCode) && !is_string($cityLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityLocationCode, true), gettype($cityLocationCode)), __LINE__);
        }
        if (is_null($cityLocationCode) || (is_array($cityLocationCode) && empty($cityLocationCode))) {
            unset($this->CityLocationCode);
        } else {
            $this->CityLocationCode = $cityLocationCode;
        }
        return $this;
    }
    /**
     * Get IsCity value
     * @return bool|null
     */
    public function getIsCity()
    {
        return $this->IsCity;
    }
    /**
     * Set IsCity value
     * @param bool $isCity
     * @return \StructType\AirDestinationAirport
     */
    public function setIsCity($isCity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCity) && !is_bool($isCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCity, true), gettype($isCity)), __LINE__);
        }
        $this->IsCity = $isCity;
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\AirDestinationAirport
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirDestinationAirport
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
