<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingSearchRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase para indicar los criterios de búsqueda de las reservas aéreas
 * - nillable: true
 * - type: tns:AirBookingSearchRQ
 * @subpackage Structs
 */
class AirBookingSearchRQ extends AbstractStructBase
{
    /**
     * The BookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador en el proveedor de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingReference;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - documentation: Tipo de forma de pago
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentForm;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Apellidos del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The BookingStatus
     * Meta information extracted from the WSDL
     * - documentation: Estado de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingStatus;
    /**
     * The BookingDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de alta de la reserva (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingDate;
    /**
     * The BookingDateFrom
     * Meta information extracted from the WSDL
     * - documentation: Feccha de alta de la reserva Desde (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingDateFrom;
    /**
     * The BookingDateTo
     * Meta information extracted from the WSDL
     * - documentation: Feccha de alta de la reserva Hasta (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingDateTo;
    /**
     * The DeadLineDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha limite de la reserva (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeadLineDate;
    /**
     * The DeadLineDateFrom
     * Meta information extracted from the WSDL
     * - documentation: Fecha limite de la reserva desde (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeadLineDateFrom;
    /**
     * The DeadLineDateTo
     * Meta information extracted from the WSDL
     * - documentation: Fecha limite de la reserva hasta (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeadLineDateTo;
    /**
     * The NumberPage
     * Meta information extracted from the WSDL
     * - documentation: Numero de pagina a recuperar (La paginacion empieza en la pagina 0)
     * - minOccurs: 0
     * @var int
     */
    public $NumberPage;
    /**
     * The NumberRecordsPage
     * Meta information extracted from the WSDL
     * - documentation: Numero de registros por pagina a devolver
     * - minOccurs: 0
     * @var int
     */
    public $NumberRecordsPage;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Campo de ordenacion
     * - minOccurs: 0
     * @var string
     */
    public $Sort;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - documentation: Direccion de la ordenacion
     * - minOccurs: 0
     * @var string
     */
    public $SortOrder;
    /**
     * Constructor method for AirBookingSearchRQ
     * @uses AirBookingSearchRQ::setBookingReference()
     * @uses AirBookingSearchRQ::setPaymentForm()
     * @uses AirBookingSearchRQ::setLastName()
     * @uses AirBookingSearchRQ::setBookingStatus()
     * @uses AirBookingSearchRQ::setBookingDate()
     * @uses AirBookingSearchRQ::setBookingDateFrom()
     * @uses AirBookingSearchRQ::setBookingDateTo()
     * @uses AirBookingSearchRQ::setDeadLineDate()
     * @uses AirBookingSearchRQ::setDeadLineDateFrom()
     * @uses AirBookingSearchRQ::setDeadLineDateTo()
     * @uses AirBookingSearchRQ::setNumberPage()
     * @uses AirBookingSearchRQ::setNumberRecordsPage()
     * @uses AirBookingSearchRQ::setSort()
     * @uses AirBookingSearchRQ::setSortOrder()
     * @param string $bookingReference
     * @param string $paymentForm
     * @param string $lastName
     * @param string $bookingStatus
     * @param string $bookingDate
     * @param string $bookingDateFrom
     * @param string $bookingDateTo
     * @param string $deadLineDate
     * @param string $deadLineDateFrom
     * @param string $deadLineDateTo
     * @param int $numberPage
     * @param int $numberRecordsPage
     * @param string $sort
     * @param string $sortOrder
     */
    public function __construct($bookingReference = null, $paymentForm = null, $lastName = null, $bookingStatus = null, $bookingDate = null, $bookingDateFrom = null, $bookingDateTo = null, $deadLineDate = null, $deadLineDateFrom = null, $deadLineDateTo = null, $numberPage = null, $numberRecordsPage = null, $sort = null, $sortOrder = null)
    {
        $this
            ->setBookingReference($bookingReference)
            ->setPaymentForm($paymentForm)
            ->setLastName($lastName)
            ->setBookingStatus($bookingStatus)
            ->setBookingDate($bookingDate)
            ->setBookingDateFrom($bookingDateFrom)
            ->setBookingDateTo($bookingDateTo)
            ->setDeadLineDate($deadLineDate)
            ->setDeadLineDateFrom($deadLineDateFrom)
            ->setDeadLineDateTo($deadLineDateTo)
            ->setNumberPage($numberPage)
            ->setNumberRecordsPage($numberRecordsPage)
            ->setSort($sort)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get BookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingReference()
    {
        return isset($this->BookingReference) ? $this->BookingReference : null;
    }
    /**
     * Set BookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingReference
     * @return \StructType\AirBookingSearchRQ
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        if (is_null($bookingReference) || (is_array($bookingReference) && empty($bookingReference))) {
            unset($this->BookingReference);
        } else {
            $this->BookingReference = $bookingReference;
        }
        return $this;
    }
    /**
     * Get PaymentForm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentForm()
    {
        return isset($this->PaymentForm) ? $this->PaymentForm : null;
    }
    /**
     * Set PaymentForm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AirPaymentForms::valueIsValid()
     * @uses \EnumType\AirPaymentForms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentForm
     * @return \StructType\AirBookingSearchRQ
     */
    public function setPaymentForm($paymentForm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirPaymentForms::valueIsValid($paymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirPaymentForms', is_array($paymentForm) ? implode(', ', $paymentForm) : var_export($paymentForm, true), implode(', ', \EnumType\AirPaymentForms::getValidValues())), __LINE__);
        }
        if (is_null($paymentForm) || (is_array($paymentForm) && empty($paymentForm))) {
            unset($this->PaymentForm);
        } else {
            $this->PaymentForm = $paymentForm;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\AirBookingSearchRQ
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get BookingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingStatus()
    {
        return isset($this->BookingStatus) ? $this->BookingStatus : null;
    }
    /**
     * Set BookingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AirBookingStatus::valueIsValid()
     * @uses \EnumType\AirBookingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingStatus
     * @return \StructType\AirBookingSearchRQ
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirBookingStatus::valueIsValid($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirBookingStatus', is_array($bookingStatus) ? implode(', ', $bookingStatus) : var_export($bookingStatus, true), implode(', ', \EnumType\AirBookingStatus::getValidValues())), __LINE__);
        }
        if (is_null($bookingStatus) || (is_array($bookingStatus) && empty($bookingStatus))) {
            unset($this->BookingStatus);
        } else {
            $this->BookingStatus = $bookingStatus;
        }
        return $this;
    }
    /**
     * Get BookingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingDate()
    {
        return isset($this->BookingDate) ? $this->BookingDate : null;
    }
    /**
     * Set BookingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingDate
     * @return \StructType\AirBookingSearchRQ
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDate, true), gettype($bookingDate)), __LINE__);
        }
        if (is_null($bookingDate) || (is_array($bookingDate) && empty($bookingDate))) {
            unset($this->BookingDate);
        } else {
            $this->BookingDate = $bookingDate;
        }
        return $this;
    }
    /**
     * Get BookingDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingDateFrom()
    {
        return isset($this->BookingDateFrom) ? $this->BookingDateFrom : null;
    }
    /**
     * Set BookingDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingDateFrom
     * @return \StructType\AirBookingSearchRQ
     */
    public function setBookingDateFrom($bookingDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateFrom) && !is_string($bookingDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateFrom, true), gettype($bookingDateFrom)), __LINE__);
        }
        if (is_null($bookingDateFrom) || (is_array($bookingDateFrom) && empty($bookingDateFrom))) {
            unset($this->BookingDateFrom);
        } else {
            $this->BookingDateFrom = $bookingDateFrom;
        }
        return $this;
    }
    /**
     * Get BookingDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingDateTo()
    {
        return isset($this->BookingDateTo) ? $this->BookingDateTo : null;
    }
    /**
     * Set BookingDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingDateTo
     * @return \StructType\AirBookingSearchRQ
     */
    public function setBookingDateTo($bookingDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateTo) && !is_string($bookingDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateTo, true), gettype($bookingDateTo)), __LINE__);
        }
        if (is_null($bookingDateTo) || (is_array($bookingDateTo) && empty($bookingDateTo))) {
            unset($this->BookingDateTo);
        } else {
            $this->BookingDateTo = $bookingDateTo;
        }
        return $this;
    }
    /**
     * Get DeadLineDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeadLineDate()
    {
        return isset($this->DeadLineDate) ? $this->DeadLineDate : null;
    }
    /**
     * Set DeadLineDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deadLineDate
     * @return \StructType\AirBookingSearchRQ
     */
    public function setDeadLineDate($deadLineDate = null)
    {
        // validation for constraint: string
        if (!is_null($deadLineDate) && !is_string($deadLineDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deadLineDate, true), gettype($deadLineDate)), __LINE__);
        }
        if (is_null($deadLineDate) || (is_array($deadLineDate) && empty($deadLineDate))) {
            unset($this->DeadLineDate);
        } else {
            $this->DeadLineDate = $deadLineDate;
        }
        return $this;
    }
    /**
     * Get DeadLineDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeadLineDateFrom()
    {
        return isset($this->DeadLineDateFrom) ? $this->DeadLineDateFrom : null;
    }
    /**
     * Set DeadLineDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deadLineDateFrom
     * @return \StructType\AirBookingSearchRQ
     */
    public function setDeadLineDateFrom($deadLineDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($deadLineDateFrom) && !is_string($deadLineDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deadLineDateFrom, true), gettype($deadLineDateFrom)), __LINE__);
        }
        if (is_null($deadLineDateFrom) || (is_array($deadLineDateFrom) && empty($deadLineDateFrom))) {
            unset($this->DeadLineDateFrom);
        } else {
            $this->DeadLineDateFrom = $deadLineDateFrom;
        }
        return $this;
    }
    /**
     * Get DeadLineDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeadLineDateTo()
    {
        return isset($this->DeadLineDateTo) ? $this->DeadLineDateTo : null;
    }
    /**
     * Set DeadLineDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deadLineDateTo
     * @return \StructType\AirBookingSearchRQ
     */
    public function setDeadLineDateTo($deadLineDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($deadLineDateTo) && !is_string($deadLineDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deadLineDateTo, true), gettype($deadLineDateTo)), __LINE__);
        }
        if (is_null($deadLineDateTo) || (is_array($deadLineDateTo) && empty($deadLineDateTo))) {
            unset($this->DeadLineDateTo);
        } else {
            $this->DeadLineDateTo = $deadLineDateTo;
        }
        return $this;
    }
    /**
     * Get NumberPage value
     * @return int|null
     */
    public function getNumberPage()
    {
        return $this->NumberPage;
    }
    /**
     * Set NumberPage value
     * @param int $numberPage
     * @return \StructType\AirBookingSearchRQ
     */
    public function setNumberPage($numberPage = null)
    {
        // validation for constraint: int
        if (!is_null($numberPage) && !(is_int($numberPage) || ctype_digit($numberPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberPage, true), gettype($numberPage)), __LINE__);
        }
        $this->NumberPage = $numberPage;
        return $this;
    }
    /**
     * Get NumberRecordsPage value
     * @return int|null
     */
    public function getNumberRecordsPage()
    {
        return $this->NumberRecordsPage;
    }
    /**
     * Set NumberRecordsPage value
     * @param int $numberRecordsPage
     * @return \StructType\AirBookingSearchRQ
     */
    public function setNumberRecordsPage($numberRecordsPage = null)
    {
        // validation for constraint: int
        if (!is_null($numberRecordsPage) && !(is_int($numberRecordsPage) || ctype_digit($numberRecordsPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberRecordsPage, true), gettype($numberRecordsPage)), __LINE__);
        }
        $this->NumberRecordsPage = $numberRecordsPage;
        return $this;
    }
    /**
     * Get Sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @uses \EnumType\AirBookingSearchSortFields::valueIsValid()
     * @uses \EnumType\AirBookingSearchSortFields::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sort
     * @return \StructType\AirBookingSearchRQ
     */
    public function setSort($sort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirBookingSearchSortFields::valueIsValid($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirBookingSearchSortFields', is_array($sort) ? implode(', ', $sort) : var_export($sort, true), implode(', ', \EnumType\AirBookingSearchSortFields::getValidValues())), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @uses \EnumType\SortOrder::valueIsValid()
     * @uses \EnumType\SortOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\AirBookingSearchRQ
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortOrder::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SortOrder', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\SortOrder::getValidValues())), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
}
