<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingRateNotesRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto de response que devuelve las notas de tarifa de una reserva o de una disponibilidad de vuelos
 * - nillable: true
 * - type: tns:AirBookingRateNotesRS
 * @subpackage Structs
 */
class AirBookingRateNotesRS extends AbstractStructBase
{
    /**
     * The RateNotes
     * Meta information extracted from the WSDL
     * - documentation: Devuelve las notas de tarifa
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RateNotes;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el identificador único de la petición al web service
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de realizar la búsqueda
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirBookingRateNotesRS
     * @uses AirBookingRateNotesRS::setRateNotes()
     * @uses AirBookingRateNotesRS::setRequestID()
     * @uses AirBookingRateNotesRS::setError()
     * @param string $rateNotes
     * @param int $requestID
     * @param \StructType\ResponseError $error
     */
    public function __construct($rateNotes = null, $requestID = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setRateNotes($rateNotes)
            ->setRequestID($requestID)
            ->setError($error);
    }
    /**
     * Get RateNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRateNotes()
    {
        return isset($this->RateNotes) ? $this->RateNotes : null;
    }
    /**
     * Set RateNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rateNotes
     * @return \StructType\AirBookingRateNotesRS
     */
    public function setRateNotes($rateNotes = null)
    {
        // validation for constraint: string
        if (!is_null($rateNotes) && !is_string($rateNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateNotes, true), gettype($rateNotes)), __LINE__);
        }
        if (is_null($rateNotes) || (is_array($rateNotes) && empty($rateNotes))) {
            unset($this->RateNotes);
        } else {
            $this->RateNotes = $rateNotes;
        }
        return $this;
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirBookingRateNotesRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingRateNotesRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
