<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingGetRateNotes StructType
 * @subpackage Structs
 */
class AirBookingGetRateNotes extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The bookingID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bookingID;
    /**
     * Constructor method for AirBookingGetRateNotes
     * @uses AirBookingGetRateNotes::setCredentials()
     * @uses AirBookingGetRateNotes::setBookingID()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param int $bookingID
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, $bookingID = null)
    {
        $this
            ->setCredentials($credentials)
            ->setBookingID($bookingID);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingGetRateNotes
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get bookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->bookingID;
    }
    /**
     * Set bookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingGetRateNotes
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->bookingID = $bookingID;
        return $this;
    }
}
